/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FragmentedEditorHighlighter
implements EditorHighlighter {
    private final List<Element> myPieces;
    private final Document myDocument;
    private final int myAdditionalOffset;
    private final boolean myMergeByTextAttributes;

    public FragmentedEditorHighlighter(@NotNull EditorHighlighter highlighter, TextRange range2) {
        if (highlighter == null) {
            FragmentedEditorHighlighter.$$$reportNull$$$0(0);
        }
        this(highlighter.createIterator(range2.getStartOffset()), Collections.singletonList(range2));
    }

    private FragmentedEditorHighlighter(@NotNull HighlighterIterator sourceIterator, List<? extends TextRange> ranges2) {
        if (sourceIterator == null) {
            FragmentedEditorHighlighter.$$$reportNull$$$0(1);
        }
        this(sourceIterator, ranges2, 0, false);
    }

    private FragmentedEditorHighlighter(@NotNull HighlighterIterator sourceIterator, List<? extends TextRange> ranges2, int additionalOffset, boolean mergeByTextAttributes) {
        if (sourceIterator == null) {
            FragmentedEditorHighlighter.$$$reportNull$$$0(2);
        }
        this.myMergeByTextAttributes = mergeByTextAttributes;
        this.myDocument = sourceIterator.getDocument();
        this.myPieces = new ArrayList<Element>();
        this.myAdditionalOffset = additionalOffset;
        this.translate(sourceIterator, ranges2);
    }

    private void translate(HighlighterIterator iterator2, List<? extends TextRange> ranges2) {
        int offset = 0;
        int index = 0;
        while (!iterator2.atEnd() && index < ranges2.size()) {
            TextRange range2 = ranges2.get(index);
            if (range2.getStartOffset() >= iterator2.getEnd()) {
                iterator2.advance();
                continue;
            }
            if (range2.getEndOffset() >= iterator2.getStart()) {
                int relativeStart = Math.max(iterator2.getStart() - range2.getStartOffset(), 0);
                int relativeEnd = Math.min(iterator2.getEnd() - range2.getStartOffset(), range2.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, iterator2.getTokenType(), iterator2.getTextAttributes()));
            }
            if (range2.getEndOffset() < iterator2.getEnd()) {
                int lastEnd = this.myPieces.isEmpty() ? -1 : this.myPieces.get(this.myPieces.size() - 1).getEnd();
                this.addElement(new Element(Math.max((offset += range2.getLength() + 1 + this.myAdditionalOffset) - 1 - this.myAdditionalOffset, lastEnd), offset, null, TextAttributes.ERASE_MARKER));
                ++index;
                continue;
            }
            iterator2.advance();
        }
    }

    private void addElement(@NotNull Element element2) {
        Element oldElement;
        if (element2 == null) {
            FragmentedEditorHighlighter.$$$reportNull$$$0(3);
        }
        boolean merged = false;
        if (this.myMergeByTextAttributes && !this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element2.getStart() && Comparing.equal(oldElement.getAttributes(), element2.getAttributes()) && Comparing.equal(oldElement.getElementType(), element2.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element2.getEnd(), element2.getElementType(), element2.getAttributes()));
        }
        if (!merged) {
            this.myPieces.add(element2);
        }
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), Comparator.comparingInt(Element::getStart));
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index);
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            FragmentedEditorHighlighter.$$$reportNull$$$0(4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceIterator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/highlighter/FragmentedEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start2, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start2;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private class ProxyIterator
    implements HighlighterIterator {
        private final Document myDocument;
        private int myIdx;

        private ProxyIterator(Document document, int idx) {
            this.myDocument = document;
            this.myIdx = idx;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getAttributes();
        }

        @Override
        public int getStart() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getStart();
        }

        @Override
        public int getEnd() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return ((Element)FragmentedEditorHighlighter.this.myPieces.get(this.myIdx)).myElementType;
        }

        @Override
        public void advance() {
            if (this.myIdx < FragmentedEditorHighlighter.this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        @Override
        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        @Override
        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= FragmentedEditorHighlighter.this.myPieces.size();
        }

        @Override
        public Document getDocument() {
            return this.myDocument;
        }
    }
}

