/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessibleGutterLine
extends JPanel {
    private final EditorGutterComponentImpl myGutter;
    private AccessibleGutterElement mySelectedElement;
    private final int myLogicalLineNum;
    private final int myVisualLineNum;
    private static boolean actionHandlerInstalled;

    public static AccessibleGutterLine createAndActivate(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(0);
        }
        return new AccessibleGutterLine(gutter);
    }

    public void escape(boolean requestFocusToEditor) {
        this.myGutter.remove(this);
        this.myGutter.repaint();
        this.myGutter.setCurrentAccessibleLine(null);
        if (requestFocusToEditor) {
            IdeFocusManager.getGlobalInstance().requestFocus(this.myGutter.getEditor().getContentComponent(), true);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.mySelectedElement.paint(g);
    }

    public static void installListeners(final @NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(1);
        }
        if (!actionHandlerInstalled) {
            actionHandlerInstalled = true;
            EditorActionManager.getInstance().setActionHandler("EditorShowGutterIconTooltip", new EditorActionHandler(){

                @Override
                protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                    AccessibleGutterLine line;
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((line = ((EditorGutterComponentImpl)editor.getGutter()).getCurrentAccessibleLine()) != null) {
                        line.showTooltipIfPresent();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/AccessibleGutterLine$1", "doExecute"));
                }
            });
        }
        gutter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                gutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(gutter));
            }
        });
        gutter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                gutter.escapeCurrentAccessibleLine();
            }
        });
        gutter.getEditor().getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretPositionChanged(@NotNull CaretEvent event) {
                AccessibleGutterLine line;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((line = gutter.getCurrentAccessibleLine()) != null) {
                    line.maybeLineChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/AccessibleGutterLine$4", "caretPositionChanged"));
            }
        });
    }

    private void moveRight() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentAfter(this, this.mySelectedElement), true);
    }

    private void moveLeft() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentBefore(this, this.mySelectedElement), true);
    }

    public void showTooltipIfPresent() {
        this.mySelectedElement.showTooltip();
    }

    private AccessibleGutterLine(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(2);
        }
        super(null);
        EditorImpl editor = gutter.getEditor();
        int lineHeight = editor.getLineHeight();
        this.myGutter = gutter;
        this.myLogicalLineNum = editor.getCaretModel().getPrimaryCaret().getLogicalPosition().line;
        this.myVisualLineNum = editor.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (this.myGutter.isLineNumbersShown()) {
            this.addNewElement(new SimpleAccessible(){

                @Override
                @NotNull
                public String getAccessibleName() {
                    String string = "line " + (AccessibleGutterLine.this.myLogicalLineNum + 1);
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public String getAccessibleTooltipText() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$5", "getAccessibleName"));
                }
            }, this.myGutter.getLineNumberAreaOffset(), 0, this.myGutter.getLineNumberAreaWidth(), lineHeight);
        }
        if (this.myGutter.isAnnotationsShown()) {
            int x2 = this.myGutter.getAnnotationsAreaOffset();
            int width = 0;
            String tooltipText = null;
            final StringBuilder buf = new StringBuilder("annotation: ");
            for (int i = 0; i < this.myGutter.myTextAnnotationGutters.size(); ++i) {
                TextAnnotationGutterProvider gutterProvider = this.myGutter.myTextAnnotationGutters.get(i);
                if (tooltipText == null) {
                    tooltipText = gutterProvider.getToolTip(this.myLogicalLineNum, editor);
                }
                int annotationSize = this.myGutter.myTextAnnotationGutterSizes.get(i);
                buf.append(ObjectUtils.notNull(gutterProvider.getLineText(this.myLogicalLineNum, editor), ""));
                width += annotationSize;
            }
            if (buf.length() > 0) {
                final String tt = tooltipText;
                this.addNewElement(new SimpleAccessible(){

                    @Override
                    @NotNull
                    public String getAccessibleName() {
                        String string = buf.toString();
                        if (string == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @Override
                    public String getAccessibleTooltipText() {
                        return tt;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$6", "getAccessibleName"));
                    }
                }, x2, 0, width, lineHeight);
            }
        }
        if (this.myGutter.areIconsShown()) {
            List<GutterMark> row = this.myGutter.getGutterRenderers(this.myVisualLineNum);
            this.myGutter.processIconsRow(this.myVisualLineNum, row, (x, y, renderer) -> {
                Icon icon2 = this.myGutter.scaleIcon(renderer.getIcon());
                this.addNewElement(new SimpleAccessible(){

                    @Override
                    @NotNull
                    public String getAccessibleName() {
                        if (renderer instanceof SimpleAccessible) {
                            String string = ((SimpleAccessible)((Object)renderer)).getAccessibleName();
                            if (string == null) {
                                7.$$$reportNull$$$0(0);
                            }
                            return string;
                        }
                        String string = "icon: " + renderer.getClass().getSimpleName();
                        if (string == null) {
                            7.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    @Override
                    public String getAccessibleTooltipText() {
                        return renderer.getTooltipText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$7", "getAccessibleName"));
                    }
                }, x, 0, icon2.getIconWidth(), lineHeight);
            });
        }
        if (this.myGutter.isLineMarkersShown()) {
            int firstVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum);
            int lastVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum + 1);
            this.myGutter.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                Rectangle bounds2;
                Rectangle rect;
                LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
                if (renderer instanceof ActiveGutterRenderer && (rect = this.myGutter.getLineRendererRectangle(highlighter)) != null && (bounds2 = ((ActiveGutterRenderer)renderer).calcBounds(editor, this.myVisualLineNum, rect)) != null) {
                    this.addNewElement((ActiveGutterRenderer)renderer, bounds2.x, 0, bounds2.width, bounds2.height);
                }
            });
        }
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setBounds(0, editor.visualLineToY(this.myVisualLineNum), this.myGutter.getWhitespaceSeparatorOffset(), lineHeight);
        this.myGutter.add(this);
        this.mySelectedElement = (AccessibleGutterElement)this.getFocusTraversalPolicy().getFirstComponent(this);
        if (this.mySelectedElement == null) {
            Rectangle b = this.getBounds();
            this.mySelectedElement = this.addNewElement(new SimpleAccessible(){

                @Override
                @NotNull
                public String getAccessibleName() {
                    return "empty";
                }

                @Override
                public String getAccessibleTooltipText() {
                    return null;
                }
            }, 0, 0, b.width, b.height);
        }
        this.installActionHandler(CommonShortcuts.ESCAPE, () -> this.escape(true));
        this.installActionHandler(CommonShortcuts.ENTER, () -> {});
        this.installActionHandler(MyShortcuts.MOVE_RIGHT, this::moveRight);
        this.installActionHandler(MyShortcuts.MOVE_LEFT, this::moveLeft);
        IdeFocusManager.getGlobalInstance().requestFocus(this.mySelectedElement, true);
    }

    private void installActionHandler(ShortcutSet shortcut, Runnable action2) {
        DumbAwareAction.create(e -> action2.run()).registerCustomShortcutSet(shortcut, this);
    }

    @NotNull
    private AccessibleGutterElement addNewElement(@NotNull SimpleAccessible accessible, int x, int y, int width, int height) {
        if (accessible == null) {
            AccessibleGutterLine.$$$reportNull$$$0(3);
        }
        AccessibleGutterElement obj = new AccessibleGutterElement(accessible, new Rectangle(x, y, width, height));
        this.add(obj);
        AccessibleGutterElement accessibleGutterElement = obj;
        if (accessibleGutterElement == null) {
            AccessibleGutterLine.$$$reportNull$$$0(4);
        }
        return accessibleGutterElement;
    }

    @Override
    public void removeNotify() {
        this.repaint();
        super.removeNotify();
    }

    private void maybeLineChanged() {
        if (this.myLogicalLineNum == this.myGutter.getEditor().getCaretModel().getPrimaryCaret().getLogicalPosition().line) {
            return;
        }
        this.myGutter.remove(this);
        this.myGutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(this.myGutter));
    }

    @Override
    public void repaint() {
        if (this.myGutter == null) {
            return;
        }
        int y = this.myGutter.getEditor().visualLineToY(this.myVisualLineNum);
        this.myGutter.repaint(0, y, this.myGutter.getWhitespaceSeparatorOffset(), y + this.myGutter.getEditor().getLineHeight());
    }

    private boolean isActive() {
        return this == this.myGutter.getCurrentAccessibleLine();
    }

    public static boolean isAccessibleGutterElement(Object element2) {
        return element2 instanceof SimpleAccessible;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessible";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndActivate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installListeners";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addNewElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AccessibleGutterElement
    extends JLabel {
        @NotNull
        private final SimpleAccessible myAccessible;

        AccessibleGutterElement(@NotNull SimpleAccessible accessible, Rectangle bounds2) {
            if (accessible == null) {
                AccessibleGutterElement.$$$reportNull$$$0(0);
            }
            if (bounds2 == null) {
                AccessibleGutterElement.$$$reportNull$$$0(1);
            }
            this.myAccessible = accessible;
            this.setFocusable(true);
            this.setBounds(bounds2.x, bounds2.y, bounds2.width, AccessibleGutterLine.this.myGutter.getEditor().getLineHeight());
            this.setOpaque(false);
            this.setText(this.myAccessible.getAccessibleName());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AccessibleGutterLine.this.mySelectedElement = AccessibleGutterElement.this;
                    AccessibleGutterElement.this.getParent().repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(e.getOppositeComponent() instanceof AccessibleGutterElement) && AccessibleGutterLine.this.isActive()) {
                        AccessibleGutterLine.this.escape(false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (AccessibleGutterLine.this.mySelectedElement != this) {
                return;
            }
            Color oldColor = g.getColor();
            try {
                g.setColor(JBColor.blue);
                Point parentLoc = this.getParent().getLocation();
                Rectangle bounds2 = this.getBounds();
                bounds2.setLocation(parentLoc.x + bounds2.x, parentLoc.y + bounds2.y);
                int y = bounds2.y + bounds2.height - JBUIScale.scale(1);
                LinePainter2D.paint((Graphics2D)g, bounds2.x, y, bounds2.x + bounds2.width, y, LinePainter2D.StrokeType.INSIDE, JBUIScale.scale(1));
            }
            finally {
                g.setColor(oldColor);
            }
        }

        public void showTooltip() {
            if (this.myAccessible.getAccessibleTooltipText() != null) {
                Rectangle bounds2 = this.getBounds();
                Rectangle pBounds = this.getParent().getBounds();
                int x = pBounds.x + bounds2.x + bounds2.width / 2;
                int y = pBounds.y + bounds2.y + bounds2.height / 2;
                AccessibleGutterLine.this.myGutter.showToolTip(this.myAccessible.getAccessibleTooltipText(), new Point(x, y), Balloon.Position.atRight);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JLabel.AccessibleJLabel(){

                    @Override
                    public String getAccessibleName() {
                        return AccessibleGutterElement.this.getText();
                    }
                };
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bounds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$AccessibleGutterElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyShortcuts {
        static final CustomShortcutSet MOVE_RIGHT = new CustomShortcutSet(new KeyboardShortcut(KeyStroke.getKeyStroke(39, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null));
        static final CustomShortcutSet MOVE_LEFT = new CustomShortcutSet(new KeyboardShortcut(KeyStroke.getKeyStroke(37, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 64), null));

        private MyShortcuts() {
        }
    }
}

