/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocumentMarkupModelManager {
    private static final Logger LOG = Logger.getInstance(DocumentMarkupModelManager.class);
    private final WeakList<Document> myDocumentSet;
    private volatile boolean myDisposed;

    public static DocumentMarkupModelManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DocumentMarkupModelManager.$$$reportNull$$$0(0);
        }
        return project2.getService(DocumentMarkupModelManager.class);
    }

    public DocumentMarkupModelManager(@NotNull Project project2) {
        if (project2 == null) {
            DocumentMarkupModelManager.$$$reportNull$$$0(1);
        }
        this.myDocumentSet = new WeakList();
        Disposer.register(project2, () -> this.cleanupProjectMarkups(project2));
    }

    public void registerDocument(Document document) {
        LOG.assertTrue(!this.myDisposed);
        this.myDocumentSet.add(document);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void cleanupProjectMarkups(@NotNull Project project2) {
        if (project2 == null) {
            DocumentMarkupModelManager.$$$reportNull$$$0(2);
        }
        if (!this.myDisposed) {
            this.myDisposed = true;
            for (Document document : this.myDocumentSet.toStrongList()) {
                DocumentMarkupModel.removeMarkupModel(document, project2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/editor/impl/DocumentMarkupModelManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupProjectMarkups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

