/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.reference.SoftReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterCache {
    private static final Key<WeakReference<EditorHighlighter>> ourSomeEditorSyntaxHighlighter = Key.create("some editor highlighter");

    private EditorHighlighterCache() {
    }

    public static void rememberEditorHighlighterForCachesOptimization(Document document, @NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            EditorHighlighterCache.$$$reportNull$$$0(0);
        }
        document.putUserData(ourSomeEditorSyntaxHighlighter, new WeakReference<EditorHighlighter>(highlighter));
    }

    @Nullable
    public static EditorHighlighter getEditorHighlighterForCachesBuilding(Document document) {
        if (document == null) {
            return null;
        }
        WeakReference<EditorHighlighter> editorHighlighterWeakReference = document.getUserData(ourSomeEditorSyntaxHighlighter);
        EditorHighlighter someEditorHighlighter = SoftReference.dereference(editorHighlighterWeakReference);
        if (someEditorHighlighter instanceof LexerEditorHighlighter && ((LexerEditorHighlighter)someEditorHighlighter).isValid()) {
            return someEditorHighlighter;
        }
        document.putUserData(ourSomeEditorSyntaxHighlighter, null);
        return null;
    }

    @Nullable
    public static Lexer getLexerBasedOnLexerHighlighter(CharSequence text2, VirtualFile virtualFile2, Project project2) {
        EditorHighlighter cachedEditorHighlighter;
        EditorHighlighter highlighter = null;
        PsiFile psiFile = virtualFile2 != null ? PsiManager.getInstance(project2).findFile(virtualFile2) : null;
        Document document = psiFile != null ? PsiDocumentManager.getInstance(project2).getDocument(psiFile) : null;
        boolean alreadyInitializedHighlighter = false;
        if (document != null && (cachedEditorHighlighter = EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document)) != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(text2, cachedEditorHighlighter)) {
            highlighter = cachedEditorHighlighter;
            alreadyInitializedHighlighter = true;
        } else if (virtualFile2 != null) {
            highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, virtualFile2);
        }
        if (highlighter != null) {
            return new LexerEditorHighlighterLexer(highlighter, alreadyInitializedHighlighter);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorHighlighterCache", "rememberEditorHighlighterForCachesOptimization"));
    }
}

