/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.FoldRegionsTree;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelImpl
extends InlayModel.SimpleAdapter
implements FoldingModelEx,
PrioritizedDocumentListener,
Dumpable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(FoldingModelImpl.class);
    public static final Key<Boolean> SELECT_REGION_ON_CARET_NEARBY = Key.create("select.region.on.caret.nearby");
    private static final Key<SavedCaretPosition> SAVED_CARET_POSITION = Key.create("saved.position.before.folding");
    private static final Key<Boolean> MARK_FOR_UPDATE = Key.create("marked.for.position.update");
    private final List<FoldingListener> myListeners;
    private boolean myIsFoldingEnabled;
    private final EditorImpl myEditor;
    private final RangeMarkerTree<FoldRegionImpl> myRegionTree;
    private final FoldRegionsTree myFoldTree;
    private TextAttributes myFoldTextAttributes;
    private boolean myIsBatchFoldingProcessing;
    private boolean myDoNotCollapseCaret;
    private boolean myFoldRegionsProcessed;
    private final MultiMap<FoldingGroup, FoldRegion> myGroups;
    private boolean myDocumentChangeProcessed;
    private final AtomicLong myExpansionCounter;
    private final EditorScrollingPositionKeeper myScrollingPositionKeeper;

    FoldingModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            FoldingModelImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myGroups = new MultiMap();
        this.myDocumentChangeProcessed = true;
        this.myExpansionCounter = new AtomicLong();
        this.myEditor = editor;
        this.myIsFoldingEnabled = true;
        this.myIsBatchFoldingProcessing = false;
        this.myDoNotCollapseCaret = false;
        this.myRegionTree = new MyMarkerTree(editor.getDocument());
        this.myFoldTree = new FoldRegionsTree(this.myRegionTree){

            @Override
            protected boolean isFoldingEnabled() {
                return FoldingModelImpl.this.isFoldingEnabled();
            }

            @Override
            protected boolean hasBlockInlays() {
                return FoldingModelImpl.this.myEditor.getInlayModel().hasBlockElements();
            }

            @Override
            protected int getBlockInlaysHeight(int startOffset, int endOffset) {
                return EditorUtil.getTotalInlaysHeight(FoldingModelImpl.this.myEditor.getInlayModel().getBlockElementsInRange(startOffset, endOffset));
            }
        };
        this.myFoldRegionsProcessed = false;
        this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper(editor);
        Disposer.register(editor.getDisposable(), this.myScrollingPositionKeeper);
        this.refreshSettings();
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(@NotNull FoldingGroup group) {
        if (group == null) {
            FoldingModelImpl.$$$reportNull$$$0(1);
        }
        List list2 = (List)this.myGroups.get(group);
        if (list2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myFoldTree.clearDocumentRangesModificationStatus();
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(3);
        }
        FoldingModelImpl.assertReadAccess();
        return region instanceof FoldRegionImpl && ((FoldRegionImpl)region).hasDocumentRegionChanged();
    }

    public int getEndOffset(@NotNull FoldingGroup group) {
        if (group == null) {
            FoldingModelImpl.$$$reportNull$$$0(4);
        }
        List<FoldRegion> regions = this.getGroupedRegions(group);
        int endOffset = 0;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            endOffset = Math.max(endOffset, region.getEndOffset());
        }
        return endOffset;
    }

    void refreshSettings() {
        this.myFoldTextAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myIsFoldingEnabled;
    }

    @Override
    public boolean isOffsetCollapsed(int offset) {
        FoldingModelImpl.assertReadAccess();
        return this.getCollapsedRegionAtOffset(offset) != null;
    }

    private boolean isOffsetInsideCollapsedRegion(int offset) {
        FoldingModelImpl.assertReadAccess();
        FoldRegion region = this.getCollapsedRegionAtOffset(offset);
        return region != null && region.getStartOffset() < offset;
    }

    void onPlaceholderTextChanged(FoldRegionImpl region) {
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be changed inside batchFoldProcessing() only");
        }
        this.myFoldRegionsProcessed = true;
        this.myEditor.myView.invalidateFoldRegionLayout(region);
        this.notifyListenersOnFoldRegionStateChange(region);
    }

    private static void assertIsDispatchThreadForEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    private static void assertOurRegion(FoldRegion region) {
        if (!(region instanceof FoldRegionImpl)) {
            throw new IllegalArgumentException("Only regions created by this instance of FoldingModel are accepted");
        }
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myIsFoldingEnabled = isEnabled;
    }

    @Override
    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            FoldingModelImpl.$$$reportNull$$$0(5);
        }
        return this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
    }

    @Override
    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean allowMovingCaret, boolean keepRelativeCaretPosition) {
        if (operation == null) {
            FoldingModelImpl.$$$reportNull$$$0(6);
        }
        this.runBatchFoldingOperation(operation, !allowMovingCaret, true, keepRelativeCaretPosition);
    }

    @Override
    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaret) {
        if (operation == null) {
            FoldingModelImpl.$$$reportNull$$$0(7);
        }
        this.runBatchFoldingOperation(operation, false, moveCaret, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatchFoldingOperation(@NotNull Runnable operation, boolean dontCollapseCaret, boolean moveCaret, boolean adjustScrollingPosition) {
        if (operation == null) {
            FoldingModelImpl.$$$reportNull$$$0(8);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (this.myEditor.getInlayModel().isInBatchMode()) {
            LOG.error("Folding operations shouldn't be performed during inlay batch update");
        }
        boolean oldDontCollapseCaret = this.myDoNotCollapseCaret;
        this.myDoNotCollapseCaret |= dontCollapseCaret;
        boolean oldBatchFlag = this.myIsBatchFoldingProcessing;
        if (!oldBatchFlag && adjustScrollingPosition) {
            ((ScrollingModelImpl)this.myEditor.getScrollingModel()).finishAnimation();
            this.myScrollingPositionKeeper.savePosition();
        }
        this.myIsBatchFoldingProcessing = true;
        try {
            operation.run();
        }
        finally {
            if (!oldBatchFlag) {
                this.myIsBatchFoldingProcessing = false;
                if (this.myFoldRegionsProcessed) {
                    this.notifyBatchFoldingProcessingDone(moveCaret, adjustScrollingPosition);
                    this.myFoldRegionsProcessed = false;
                }
            }
            this.myDoNotCollapseCaret = oldDontCollapseCaret;
        }
    }

    @Override
    public FoldRegion @NotNull [] getAllFoldRegions() {
        FoldingModelImpl.assertReadAccess();
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchAllRegions();
        if (foldRegionArray == null) {
            FoldingModelImpl.$$$reportNull$$$0(9);
        }
        return foldRegionArray;
    }

    @Override
    @Nullable
    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Override
    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        FoldingModelImpl.assertReadAccess();
        return this.myFoldTree.getRegionAt(startOffset, endOffset);
    }

    @Override
    @Nullable
    public FoldRegion getFoldingPlaceholderAt(@NotNull Point p) {
        if (p == null) {
            FoldingModelImpl.$$$reportNull$$$0(10);
        }
        VisualPosition visualPosition = this.myEditor.xyToVisualPosition(p);
        int visualLineStartY = this.myEditor.visualLineToY(visualPosition.line);
        if (p.y < visualLineStartY || p.y >= visualLineStartY + this.myEditor.getLineHeight()) {
            return null;
        }
        LogicalPosition pos = this.myEditor.visualToLogicalPosition(visualPosition);
        int line = pos.line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Override
    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(11);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        FoldingModelImpl.assertOurRegion(region);
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        ((FoldRegionImpl)region).setExpanded(true, false);
        this.notifyListenersOnFoldRegionStateChange(region);
        this.notifyListenersOnFoldRegionRemove(region);
        this.myFoldRegionsProcessed = true;
        region.dispose();
    }

    void removeRegionFromTree(@NotNull FoldRegionImpl region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        this.myFoldRegionsProcessed = true;
        this.myRegionTree.removeInterval(region);
        this.removeRegionFromGroup(region);
    }

    void removeRegionFromGroup(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(13);
        }
        this.myGroups.remove(region.getGroup(), region);
    }

    void dispose() {
        this.doClearFoldRegions();
        this.myRegionTree.dispose(this.myEditor.getDocument());
    }

    @Override
    public void clearFoldRegions() {
        FoldRegion[] regions;
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return;
        }
        for (FoldRegion region : regions = this.getAllFoldRegions()) {
            if (!region.isExpanded()) {
                this.notifyListenersOnFoldRegionStateChange(region);
            }
            this.notifyListenersOnFoldRegionRemove(region);
            region.dispose();
        }
        this.doClearFoldRegions();
    }

    private void doClearFoldRegions() {
        this.myGroups.clear();
        this.myFoldTree.clear();
    }

    void expandFoldRegion(@NotNull FoldRegion region, boolean notify) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(14);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (region.isExpanded() || region.shouldNeverExpand()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            SavedCaretPosition savedPosition = caret.getUserData(SAVED_CARET_POSITION);
            if (savedPosition != null && savedPosition.isUpToDate(this.myEditor)) {
                int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position);
                FoldRegion[] allCollapsed = this.myFoldTree.fetchCollapsedAt(savedOffset);
                if (allCollapsed.length != 1 || allCollapsed[0] != region) continue;
                caret.putUserData(MARK_FOR_UPDATE, Boolean.TRUE);
                continue;
            }
            if (caret.getOffset() != region.getStartOffset()) continue;
            caret.putUserData(MARK_FOR_UPDATE, Boolean.TRUE);
            caret.putUserData(SAVED_CARET_POSITION, new SavedCaretPosition(caret));
        }
        this.myFoldRegionsProcessed = true;
        this.myExpansionCounter.incrementAndGet();
        ((FoldRegionImpl)region).setExpandedInternal(true);
        if (notify) {
            this.notifyListenersOnFoldRegionStateChange(region);
        }
    }

    void collapseFoldRegion(@NotNull FoldRegion region, boolean notify) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(15);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        if (this.myDoNotCollapseCaret) {
            for (Caret caret : carets) {
                if (!FoldRegionsTree.containsStrict(region, caret.getOffset())) continue;
                return;
            }
        }
        for (Caret caret : carets) {
            SavedCaretPosition savedPosition;
            if (!FoldRegionsTree.containsStrict(region, caret.getOffset()) || (savedPosition = caret.getUserData(SAVED_CARET_POSITION)) != null && savedPosition.isUpToDate(this.myEditor)) continue;
            caret.putUserData(SAVED_CARET_POSITION, new SavedCaretPosition(caret));
        }
        this.myFoldRegionsProcessed = true;
        ((FoldRegionImpl)region).setExpandedInternal(false);
        if (notify) {
            this.notifyListenersOnFoldRegionStateChange(region);
        }
    }

    private void notifyBatchFoldingProcessingDone(boolean moveCaretFromCollapsedRegion, boolean adjustScrollingPosition) {
        this.clearCachedValues();
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldProcessingEnd();
        }
        this.myEditor.updateCaretCursor();
        this.myEditor.recalculateSizeAndRepaint();
        this.myEditor.getGutterComponentEx().updateSize();
        this.myEditor.getGutterComponentEx().repaint();
        this.myEditor.invokeDelayedErrorStripeRepaint();
        this.myEditor.getCaretModel().runBatchCaretOperation(() -> {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                boolean markedForUpdate;
                LogicalPosition positionToUse = null;
                int offsetToUse = -1;
                SavedCaretPosition savedPosition = caret.getUserData(SAVED_CARET_POSITION);
                boolean bl = markedForUpdate = caret.getUserData(MARK_FOR_UPDATE) != null;
                if (savedPosition != null && savedPosition.isUpToDate(this.myEditor)) {
                    int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position);
                    FoldRegion collapsedAtSaved = this.myFoldTree.fetchOutermost(savedOffset);
                    if (collapsedAtSaved == null) {
                        positionToUse = savedPosition.position;
                    } else {
                        offsetToUse = collapsedAtSaved.getStartOffset();
                    }
                }
                if ((markedForUpdate || moveCaretFromCollapsedRegion) && caret.isUpToDate()) {
                    if (offsetToUse >= 0) {
                        caret.moveToOffset(offsetToUse);
                    } else if (positionToUse != null) {
                        caret.moveToLogicalPosition(positionToUse);
                    } else {
                        ((CaretImpl)caret).updateVisualPosition();
                    }
                }
                caret.putUserData(SAVED_CARET_POSITION, savedPosition);
                caret.putUserData(MARK_FOR_UPDATE, null);
                int selectionStart = caret.getSelectionStart();
                int selectionEnd = caret.getSelectionEnd();
                if (this.isOffsetInsideCollapsedRegion(selectionStart) || this.isOffsetInsideCollapsedRegion(selectionEnd)) {
                    caret.removeSelection();
                    continue;
                }
                if (selectionStart >= this.myEditor.getDocument().getTextLength()) continue;
                caret.setSelection(selectionStart, selectionEnd);
            }
        });
        if (adjustScrollingPosition) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    @Override
    public void rebuild() {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    public boolean isInBatchFoldingOperation() {
        return this.myIsBatchFoldingProcessing;
    }

    private void updateCachedOffsets() {
        this.myFoldTree.updateCachedOffsets();
    }

    public int getFoldedLinesCountBefore(int offset) {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getFoldedLinesCountBefore(offset);
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getTotalNumberOfFoldedLines();
    }

    int getHeightOfFoldedBlockInlaysBefore(int offset) {
        return this.myFoldTree.getHeightOfFoldedBlockInlaysBefore(offset);
    }

    int getTotalHeightOfFoldedBlockInlays() {
        return this.myFoldTree.getTotalHeightOfFoldedBlockInlays();
    }

    @Override
    public FoldRegion @Nullable [] fetchTopLevel() {
        return this.myFoldTree.fetchTopLevel();
    }

    FoldRegion @NotNull [] fetchCollapsedAt(int offset) {
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchCollapsedAt(offset);
        if (foldRegionArray == null) {
            FoldingModelImpl.$$$reportNull$$$0(16);
        }
        return foldRegionArray;
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        return this.myFoldTree.intersectsRegion(startOffset, endOffset);
    }

    FoldRegion @Nullable [] fetchVisible() {
        return this.myFoldTree.fetchVisible();
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myFoldTextAttributes;
    }

    void flushCaretPosition(@NotNull Caret caret) {
        if (caret == null) {
            FoldingModelImpl.$$$reportNull$$$0(17);
        }
        caret.putUserData(SAVED_CARET_POSITION, null);
    }

    void onBulkDocumentUpdateStarted() {
        this.clearCachedValues();
    }

    void clearCachedValues() {
        this.myFoldTree.clearCachedValues();
    }

    void onBulkDocumentUpdateFinished() {
        this.myFoldTree.rebuild();
    }

    @Override
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            FoldingModelImpl.$$$reportNull$$$0(18);
        }
        if (this.myIsBatchFoldingProcessing) {
            LOG.error("Document changes are not allowed during batch folding update");
        }
        this.myDocumentChangeProcessed = false;
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            FoldingModelImpl.$$$reportNull$$$0(19);
        }
        try {
            if (event.getDocument().isInBulkUpdate()) {
                return;
            }
            if (DocumentEventUtil.isMoveInsertion(event)) {
                this.myFoldTree.rebuild();
            } else {
                this.updateCachedOffsets();
            }
        }
        finally {
            this.myDocumentChangeProcessed = true;
        }
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public void onUpdated(@NotNull Inlay inlay, int changeFlags) {
        if (inlay == null) {
            FoldingModelImpl.$$$reportNull$$$0(20);
        }
        if ((inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE) && (changeFlags & 2) != 0) {
            this.myFoldTree.clearCachedInlayValues();
        }
    }

    @Override
    @Nullable
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group, boolean neverExpands) {
        if (placeholder == null) {
            FoldingModelImpl.$$$reportNull$$$0(21);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return null;
        }
        if (!this.isFoldingEnabled() || startOffset >= endOffset || neverExpands && group != null || DocumentUtil.isInsideCharacterPair(this.myEditor.getDocument(), startOffset) || DocumentUtil.isInsideCharacterPair(this.myEditor.getDocument(), endOffset) || !this.myFoldTree.checkIfValidToCreate(startOffset, endOffset)) {
            return null;
        }
        FoldRegionImpl region = new FoldRegionImpl(this.myEditor, startOffset, endOffset, placeholder, group, neverExpands);
        this.myRegionTree.addInterval(region, startOffset, endOffset, false, false, false, 0);
        LOG.assertTrue(region.isValid());
        if (neverExpands) {
            this.collapseFoldRegion(region, false);
            if (region.isExpanded()) {
                this.myRegionTree.removeInterval(region);
                return null;
            }
        }
        this.myFoldRegionsProcessed = true;
        if (group != null) {
            this.myGroups.putValue(group, region);
        }
        this.notifyListenersOnFoldRegionStateChange(region);
        LOG.assertTrue(region.isValid());
        return region;
    }

    @Override
    public void addListener(@NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(22);
        }
        if (parentDisposable == null) {
            FoldingModelImpl.$$$reportNull$$$0(23);
        }
        this.myListeners.add(listener2);
        Disposer.register(parentDisposable, () -> this.myListeners.remove(listener2));
    }

    private void notifyListenersOnFoldRegionStateChange(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(24);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldRegionStateChange(foldRegion);
        }
    }

    private void notifyListenersOnFoldRegionRemove(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(25);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.beforeFoldRegionRemoved(foldRegion);
        }
    }

    @Override
    @NotNull
    public String dumpState() {
        String string = Arrays.toString(this.myFoldTree.fetchTopLevel());
        if (string == null) {
            FoldingModelImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    @Override
    public long getModificationCount() {
        return this.myExpansionCounter.get();
    }

    void validateState() {
        FoldRegion[] actualTopLevels;
        DocumentEx document = this.myEditor.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        FoldRegion[] allFoldRegions = this.getAllFoldRegions();
        boolean[] invisibleRegions = new boolean[allFoldRegions.length];
        for (int i = 0; i < allFoldRegions.length; ++i) {
            FoldRegion r1 = allFoldRegions[i];
            LOG.assertTrue(r1.isValid() && !DocumentUtil.isInsideCharacterPair(document, r1.getStartOffset()) && !DocumentUtil.isInsideCharacterPair(document, r1.getEndOffset()), "Invalid region");
            for (int j = i + 1; j < allFoldRegions.length; ++j) {
                FoldRegion r2 = allFoldRegions[j];
                int r1s = r1.getStartOffset();
                int r1e = r1.getEndOffset();
                int r2s = r2.getStartOffset();
                int r2e = r2.getEndOffset();
                LOG.assertTrue(r1s < r2s && (r1e <= r2s || r1e >= r2e) || r1s == r2s && r1e != r2e || r1s > r2s && r1s < r2e && r1e <= r2e || r1s >= r2e, "Disallowed relative position of regions");
                if (!r1.isExpanded() && r1s <= r2s && r1e >= r2e) {
                    invisibleRegions[j] = true;
                }
                if (r2.isExpanded() || r2s > r1s || r2e < r1e) continue;
                invisibleRegions[i] = true;
            }
        }
        THashSet<FoldRegion> visibleRegions = new THashSet<FoldRegion>(FoldRegionsTree.OFFSET_BASED_HASHING_STRATEGY);
        ArrayList<FoldRegion[]> topLevelRegions = new ArrayList<FoldRegion[]>();
        for (int i = 0; i < allFoldRegions.length; ++i) {
            if (invisibleRegions[i]) continue;
            FoldRegion[] region = allFoldRegions[i];
            LOG.assertTrue(visibleRegions.add((FoldRegion)region), "Duplicate visible regions");
            if (region.isExpanded()) continue;
            topLevelRegions.add(region);
        }
        Collections.sort(topLevelRegions, Comparator.comparingInt(r -> r.getStartOffset()));
        FoldRegion[] actualVisibles = this.fetchVisible();
        if (actualVisibles != null) {
            for (FoldRegion r2 : actualVisibles) {
                LOG.assertTrue(visibleRegions.remove(r2), "Unexpected visible region");
            }
            LOG.assertTrue(visibleRegions.isEmpty(), "Missing visible region");
        }
        if ((actualTopLevels = this.fetchTopLevel()) != null) {
            LOG.assertTrue(actualTopLevels.length == topLevelRegions.size(), "Wrong number of top-level regions");
            for (int i = 0; i < actualTopLevels.length; ++i) {
                LOG.assertTrue(FoldRegionsTree.OFFSET_BASED_HASHING_STRATEGY.equals(actualTopLevels[i], (FoldRegion)topLevelRegions.get(i)), "Unexpected top-level region");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingModelImpl";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedRegions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFoldRegions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCollapsedAt";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupedRegions";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDocumentRegionChangedFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingPlaceholderAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFoldRegion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeRegionFromTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeRegionFromGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expandFoldRegion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collapseFoldRegion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "flushCaretPosition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFoldRegion";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnFoldRegionStateChange";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnFoldRegionRemove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMarkerTree
    extends HardReferencingRangeMarkerTree<FoldRegionImpl> {
        private boolean inCollectCall;

        private MyMarkerTree(Document document) {
            super(document);
        }

        @NotNull
        private FoldRegionImpl getRegion(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> node) {
            if (node == null) {
                MyMarkerTree.$$$reportNull$$$0(0);
            }
            assert (node.intervals.size() == 1);
            FoldRegionImpl region = (FoldRegionImpl)node.intervals.get(0).get();
            assert (region != null);
            FoldRegionImpl foldRegionImpl = region;
            if (foldRegionImpl == null) {
                MyMarkerTree.$$$reportNull$$$0(1);
            }
            return foldRegionImpl;
        }

        @Override
        @NotNull
        protected HardReferencingRangeMarkerTree.Node<FoldRegionImpl> createNewNode(@NotNull FoldRegionImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (key == null) {
                MyMarkerTree.$$$reportNull$$$0(2);
            }
            return new HardReferencingRangeMarkerTree.Node<FoldRegionImpl>((RangeMarkerTree)this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void onRemoved() {
                    for (Getter getter : this.intervals) {
                        FoldingModelImpl.this.removeRegionFromGroup((FoldRegion)getter.get());
                    }
                }

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> otherNode) {
                    if (otherNode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FoldRegionImpl region = MyMarkerTree.this.getRegion(this);
                    FoldRegionImpl otherRegion = MyMarkerTree.this.getRegion(otherNode);
                    if (otherRegion.mySizeBeforeUpdate > region.mySizeBeforeUpdate) {
                        MyMarkerTree.this.setNode(region, null);
                        FoldingModelImpl.this.removeRegionFromGroup(region);
                        this.removeIntervalInternal(0);
                        super.addIntervalsFrom(otherNode);
                    } else {
                        otherNode.setValid(false);
                        ((RangeMarkerTree.RMNode)otherNode).onRemoved();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherNode", "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree$1", "addIntervalsFrom"));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<FoldRegionImpl> root, int start2, int end, int lengthDelta, @NotNull List<? super IntervalTreeImpl.IntervalNode<FoldRegionImpl>> affected) {
            void result2;
            if (affected == null) {
                MyMarkerTree.$$$reportNull$$$0(3);
            }
            if (this.inCollectCall) {
                return super.collectAffectedMarkersAndShiftSubtrees(root, start2, end, lengthDelta, affected);
            }
            this.inCollectCall = true;
            try {
                boolean result22 = super.collectAffectedMarkersAndShiftSubtrees(root, start2, end, lengthDelta, affected);
            }
            finally {
                this.inCollectCall = false;
            }
            int oldLength = end - start2;
            if (oldLength > 0) {
                for (IntervalTreeImpl.IntervalNode<FoldRegionImpl> intervalNode : affected) {
                    HardReferencingRangeMarkerTree.Node node = (HardReferencingRangeMarkerTree.Node)intervalNode;
                    FoldRegionImpl region = this.getRegion(node);
                    region.mySizeBeforeUpdate = region.isExpanded() ? 0 : node.intervalEnd() - node.intervalStart();
                }
            }
            return (boolean)result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affected";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRegion";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SavedCaretPosition {
        private final LogicalPosition position;
        private final long docStamp;

        private SavedCaretPosition(Caret caret) {
            this.position = caret.getLogicalPosition();
            this.docStamp = caret.getEditor().getDocument().getModificationStamp();
        }

        private boolean isUpToDate(Editor editor) {
            return this.docStamp == editor.getDocument().getModificationStamp();
        }
    }
}

