/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class FoldingPopupManager
implements EditorMouseListener,
EditorMouseMotionListener {
    private static final Key<Boolean> DISABLED = Key.create("FoldingPopupManager.disabled");
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    private static final int TOOLTIP_DELAY_MS = 300;
    private final Alarm myAlarm;

    public static void disableForEditor(@NotNull Editor editor) {
        if (editor == null) {
            FoldingPopupManager.$$$reportNull$$$0(0);
        }
        editor.putUserData(DISABLED, Boolean.TRUE);
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, null, true);
    }

    public static void enableForEditor(@NotNull Editor editor) {
        if (editor == null) {
            FoldingPopupManager.$$$reportNull$$$0(1);
        }
        editor.putUserData(DISABLED, null);
    }

    FoldingPopupManager(EditorImpl editor) {
        this.myAlarm = new Alarm(editor.getDisposable());
        editor.addEditorMouseListener(this);
        editor.addEditorMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(2);
        }
        this.myAlarm.cancelAllRequests();
        Editor editor = e.getEditor();
        if (editor.getUserData(DISABLED) != null) {
            return;
        }
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
            MouseEvent mouseEvent = e.getMouseEvent();
            Point point = mouseEvent.getPoint();
            FoldRegion fold = ((EditorEx)editor).getFoldingModel().getFoldingPlaceholderAt(point);
            TooltipController controller = TooltipController.getInstance();
            if (fold != null && !fold.shouldNeverExpand()) {
                this.myAlarm.addRequest(() -> {
                    if (editor.getUserData(DISABLED) != null || !editor.getComponent().isShowing() || !fold.isValid() || fold.isExpanded()) {
                        return;
                    }
                    DocumentFragment range2 = FoldingPopupManager.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, editor.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip(editor, p, new DocumentFragmentTooltipRenderer(range2), false, FOLDING_TOOLTIP_GROUP);
                }, 300);
            } else {
                controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, mouseEvent, true);
            }
        }
    }

    @NotNull
    private static DocumentFragment createDocumentFragment(@NotNull FoldRegion fold) {
        int groupEndOffset;
        if (fold == null) {
            FoldingPopupManager.$$$reportNull$$$0(3);
        }
        EditorImpl editor = (EditorImpl)fold.getEditor();
        DocumentEx document = editor.getDocument();
        FoldingGroup group = fold.getGroup();
        int startOffset = fold.getStartOffset();
        int endOffset = fold.getEndOffset();
        if (group != null && editor.offsetToVisualLine(groupEndOffset = editor.getFoldingModel().getEndOffset(group)) == editor.offsetToVisualLine(startOffset)) {
            endOffset = groupEndOffset;
        }
        return new DocumentFragment(document, startOffset, endOffset);
    }

    @Override
    public void mouseExited(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        if (e.getEditor().getUserData(DISABLED) != null) {
            return;
        }
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e.getMouseEvent(), true);
    }

    @Override
    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void mousePressed(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void mouseClicked(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(7);
        }
    }

    @Override
    public void mouseReleased(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(8);
        }
    }

    @Override
    public void mouseEntered(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fold";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingPopupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableForEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocumentFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDragged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mousePressed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseReleased";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseEntered";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

