/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class GutterIconDropAnimator
extends AbstractPainter {
    private final Point myExplosionLocation;
    private final Image myImage;
    @NotNull
    private final Disposable myPainterListenersDisposable;
    private static final long TIME_PER_FRAME = 30L;
    private final int myWidth;
    private final int myHeight;
    private long lastRepaintTime;
    private int frameIndex;
    private static final int TOTAL_FRAMES = 8;
    private final AtomicBoolean nrp;

    GutterIconDropAnimator(Point explosionLocation, Image image, @NotNull Disposable painterListenersDisposable) {
        if (painterListenersDisposable == null) {
            GutterIconDropAnimator.$$$reportNull$$$0(0);
        }
        this.lastRepaintTime = System.currentTimeMillis();
        this.nrp = new AtomicBoolean(true);
        this.myExplosionLocation = new Point(explosionLocation.x, explosionLocation.y);
        this.myImage = image;
        this.myPainterListenersDisposable = painterListenersDisposable;
        this.myWidth = this.myImage.getWidth(null);
        this.myHeight = this.myImage.getHeight(null);
    }

    @Override
    public void executePaint(Component component2, Graphics2D g) {
        if (!this.nrp.get()) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        float alpha = 1.0f - (float)this.frameIndex / 8.0f;
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        Image scaledImage = ImageUtil.scaleImage(this.myImage, alpha);
        int x = this.myExplosionLocation.x - scaledImage.getWidth(null) / 2;
        int y = this.myExplosionLocation.y - scaledImage.getHeight(null) / 2;
        if (currentTimeMillis - this.lastRepaintTime < 30L) {
            UIUtil.drawImage((Graphics)g, scaledImage, x, y, null);
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> component2.repaint(x, y, this.myWidth, this.myHeight), 30L, TimeUnit.MILLISECONDS);
            return;
        }
        this.lastRepaintTime = currentTimeMillis;
        ++this.frameIndex;
        UIUtil.drawImage((Graphics)g, scaledImage, x, y, null);
        if (this.frameIndex == 8) {
            this.nrp.set(false);
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose(this.myPainterListenersDisposable));
            component2.repaint(x, y, this.myWidth, this.myHeight);
        }
        component2.repaint(x, y, this.myWidth, this.myHeight);
    }

    @Override
    public boolean needsRepaint() {
        return this.nrp.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painterListenersDisposable", "com/intellij/openapi/editor/impl/GutterIconDropAnimator", "<init>"));
    }
}

