/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeHighlighterImpl
extends RangeMarkerImpl
implements RangeHighlighterEx,
Getter<RangeHighlighterEx> {
    private static final Color NULL_COLOR = new Color(0, 0, 0);
    private static final Key<Boolean> VISIBLE_IF_FOLDED = Key.create("visible.folded");
    private final MarkupModelImpl myModel;
    private TextAttributes myTextAttributes;
    private LineMarkerRenderer myLineMarkerRenderer;
    private Color myErrorStripeColor;
    private Color myLineSeparatorColor;
    private SeparatorPlacement mySeparatorPlacement;
    private GutterIconRenderer myGutterIconRenderer;
    private Object myErrorStripeTooltip;
    private MarkupEditorFilter myFilter;
    private CustomHighlighterRenderer myCustomRenderer;
    private LineSeparatorRenderer myLineSeparatorRenderer;
    private byte myFlags;
    private static final byte AFTER_END_OF_LINE_MASK = 1;
    private static final byte ERROR_STRIPE_IS_THIN_MASK = 2;
    private static final byte TARGET_AREA_IS_EXACT_MASK = 4;
    private static final byte IN_BATCH_CHANGE_MASK = 8;
    static final byte CHANGED_MASK = 16;
    static final byte RENDERERS_CHANGED_MASK = 32;
    static final byte FONT_STYLE_OR_COLOR_CHANGED_MASK = 64;

    RangeHighlighterImpl(@NotNull MarkupModelImpl model, int start2, int end, int layer, @NotNull HighlighterTargetArea target2, TextAttributes textAttributes, boolean greedyToLeft, boolean greedyToRight) {
        if (model == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(1);
        }
        super((DocumentEx)model.getDocument(), start2, end, false, false);
        this.myFilter = MarkupEditorFilter.EMPTY;
        this.myTextAttributes = textAttributes;
        this.setFlag((byte)4, target2 == HighlighterTargetArea.EXACT_RANGE);
        this.myModel = model;
        this.registerInTree(start2, end, greedyToLeft, greedyToRight, layer);
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value2) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value2);
    }

    @Override
    public TextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    @Override
    public void setTextAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(2);
        }
        boolean oldRenderedInScrollBar = this.isRenderedInScrollBar();
        TextAttributes old = this.myTextAttributes;
        this.myTextAttributes = textAttributes;
        if (this.isRenderedInScrollBar() != oldRenderedInScrollBar) {
            this.myModel.treeFor(this).updateRenderedFlags(this);
        }
        if (old != textAttributes && (old == TextAttributes.ERASE_MARKER || textAttributes == TextAttributes.ERASE_MARKER)) {
            this.fireChanged(false, true);
        } else if (!Comparing.equal(old, textAttributes)) {
            this.fireChanged(false, RangeHighlighterImpl.getFontStyle(old) != RangeHighlighterImpl.getFontStyle(textAttributes) || !Comparing.equal(RangeHighlighterImpl.getForegroundColor(old), RangeHighlighterImpl.getForegroundColor(textAttributes)));
        }
    }

    @Override
    public void setVisibleIfFolded(boolean value2) {
        this.putUserData(VISIBLE_IF_FOLDED, value2 ? Boolean.TRUE : null);
    }

    @Override
    public boolean isVisibleIfFolded() {
        return VISIBLE_IF_FOLDED.isIn(this);
    }

    private static int getFontStyle(TextAttributes textAttributes) {
        return textAttributes == null ? 0 : textAttributes.getFontType();
    }

    private static Color getForegroundColor(TextAttributes textAttributes) {
        return textAttributes == null ? null : textAttributes.getForegroundColor();
    }

    @Override
    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = this.isFlagSet((byte)4) ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
        if (highlighterTargetArea == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(3);
        }
        return highlighterTargetArea;
    }

    @Override
    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.myLineMarkerRenderer;
    }

    @Override
    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        boolean oldRenderedInGutter = this.isRenderedInGutter();
        LineMarkerRenderer old = this.myLineMarkerRenderer;
        this.myLineMarkerRenderer = renderer;
        if (this.isRenderedInGutter() != oldRenderedInGutter) {
            this.myModel.treeFor(this).updateRenderedFlags(this);
        }
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true, false);
        }
    }

    @Override
    public CustomHighlighterRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    @Override
    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        CustomHighlighterRenderer old = this.myCustomRenderer;
        this.myCustomRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true, false);
        }
    }

    @Override
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        boolean oldRenderedInGutter = this.isRenderedInGutter();
        GutterIconRenderer old = this.myGutterIconRenderer;
        this.myGutterIconRenderer = renderer;
        if (this.isRenderedInGutter() != oldRenderedInGutter) {
            this.myModel.treeFor(this).updateRenderedFlags(this);
        }
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true, false);
        }
    }

    @Override
    public Color getErrorStripeMarkColor() {
        if (this.myErrorStripeColor == NULL_COLOR) {
            return null;
        }
        if (this.myErrorStripeColor != null) {
            return this.myErrorStripeColor;
        }
        if (this.myTextAttributes != null) {
            return this.myTextAttributes.getErrorStripeColor();
        }
        return null;
    }

    @Override
    public void setErrorStripeMarkColor(Color color) {
        boolean oldRenderedInScrollBar = this.isRenderedInScrollBar();
        if (color == null) {
            color = NULL_COLOR;
        }
        Color old = this.myErrorStripeColor;
        this.myErrorStripeColor = color;
        if (this.isRenderedInScrollBar() != oldRenderedInScrollBar) {
            this.myModel.treeFor(this).updateRenderedFlags(this);
        }
        if (!Comparing.equal(old, color)) {
            this.fireChanged(false, false);
        }
    }

    @Override
    public Object getErrorStripeTooltip() {
        return this.myErrorStripeTooltip;
    }

    @Override
    public void setErrorStripeTooltip(Object tooltipObject) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object old = this.myErrorStripeTooltip;
        this.myErrorStripeTooltip = tooltipObject;
        if (!Comparing.equal(old, tooltipObject)) {
            this.fireChanged(false, false);
        }
    }

    @Override
    public boolean isThinErrorStripeMark() {
        return this.isFlagSet((byte)2);
    }

    @Override
    public void setThinErrorStripeMark(boolean value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean old = this.isThinErrorStripeMark();
        this.setFlag((byte)2, value2);
        if (old != value2) {
            this.fireChanged(false, false);
        }
    }

    @Override
    public Color getLineSeparatorColor() {
        return this.myLineSeparatorColor;
    }

    @Override
    public void setLineSeparatorColor(Color color) {
        Color old = this.myLineSeparatorColor;
        this.myLineSeparatorColor = color;
        if (!Comparing.equal(old, color)) {
            this.fireChanged(false, false);
        }
    }

    @Override
    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.mySeparatorPlacement;
    }

    @Override
    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        SeparatorPlacement old = this.mySeparatorPlacement;
        this.mySeparatorPlacement = placement;
        if (!Comparing.equal(old, placement)) {
            this.fireChanged(false, false);
        }
    }

    @Override
    public void setEditorFilter(@NotNull MarkupEditorFilter filter2) {
        if (filter2 == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(4);
        }
        this.myFilter = filter2;
        this.fireChanged(false, false);
    }

    @Override
    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.myFilter;
        if (markupEditorFilter == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(5);
        }
        return markupEditorFilter;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)1);
    }

    @Override
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        boolean old = this.isAfterEndOfLine();
        this.setFlag((byte)1, afterEndOfLine);
        if (old != afterEndOfLine) {
            this.fireChanged(false, false);
        }
    }

    private void fireChanged(boolean renderersChanged, boolean fontStyleOrColorChanged) {
        if (this.isFlagSet((byte)8)) {
            this.setFlag((byte)16, true);
            if (renderersChanged) {
                this.setFlag((byte)32, true);
            }
            if (fontStyleOrColorChanged) {
                this.setFlag((byte)64, true);
            }
        } else {
            this.myModel.fireAttributesChanged(this, renderersChanged, fontStyleOrColorChanged);
        }
    }

    @Override
    public int getAffectedAreaStartOffset() {
        int startOffset = this.getStartOffset();
        switch (this.getTargetArea()) {
            case EXACT_RANGE: {
                return startOffset;
            }
            case LINES_IN_RANGE: {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (startOffset >= textLength) {
                    return textLength;
                }
                return document.getLineStartOffset(document.getLineNumber(startOffset));
            }
        }
        throw new IllegalStateException(this.getTargetArea().toString());
    }

    @Override
    public int getAffectedAreaEndOffset() {
        int endOffset = this.getEndOffset();
        switch (this.getTargetArea()) {
            case EXACT_RANGE: {
                return endOffset;
            }
            case LINES_IN_RANGE: {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (endOffset >= textLength) {
                    return endOffset;
                }
                return Math.min(textLength, document.getLineEndOffset(document.getLineNumber(endOffset)) + 1);
            }
        }
        throw new IllegalStateException(this.getTargetArea().toString());
    }

    @ChangeStatus
    byte changeAttributesNoEvents(@NotNull Consumer<? super RangeHighlighterEx> change) {
        if (change == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(6);
        }
        assert (!this.isFlagSet((byte)8));
        assert (!this.isFlagSet((byte)16));
        this.setFlag((byte)8, true);
        this.setFlag((byte)32, false);
        this.setFlag((byte)64, false);
        byte result2 = 0;
        try {
            change.consume(this);
        }
        finally {
            this.setFlag((byte)8, false);
            if (this.isFlagSet((byte)16)) {
                result2 = (byte)(result2 | 0x10);
                if (this.isFlagSet((byte)32)) {
                    result2 = (byte)(result2 | 0x20);
                }
                if (this.isFlagSet((byte)64)) {
                    result2 = (byte)(result2 | 0x40);
                }
            }
            this.setFlag((byte)16, false);
            this.setFlag((byte)32, false);
            this.setFlag((byte)64, false);
        }
        return result2;
    }

    private MarkupModel getMarkupModel() {
        return this.myModel;
    }

    @Override
    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
        LineSeparatorRenderer old = this.myLineSeparatorRenderer;
        this.myLineSeparatorRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true, false);
        }
    }

    @Override
    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return this.myLineSeparatorRenderer;
    }

    @Override
    protected void registerInTree(int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ((MarkupModelEx)this.getMarkupModel()).addRangeHighlighter(this, start2, end, greedyToLeft, greedyToRight, layer);
    }

    @Override
    protected void unregisterInTree() {
        if (!this.isValid()) {
            return;
        }
        this.getMarkupModel().removeHighlighter(this);
    }

    @Override
    public RangeHighlighterImpl get() {
        return this;
    }

    @Override
    public int getLayer() {
        RangeHighlighterTree.RHNode node = (RangeHighlighterTree.RHNode)this.myNode;
        return node == null ? -1 : node.myLayer;
    }

    @Override
    public String toString() {
        return "RangeHighlighter: (" + this.getStartOffset() + "," + this.getEndOffset() + "); layer:" + this.getLayer() + "; tooltip: " + this.getErrorStripeTooltip();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeHighlighterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetArea";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTextAttributes";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEditorFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesNoEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static @interface ChangeStatus {
    }

    private static @interface FlagConstant {
    }
}

