/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.PatternUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsImpl
implements EditorSettings {
    private static final Logger LOG = Logger.getInstance(SettingsImpl.class);
    @Nullable
    private final EditorEx myEditor;
    @Nullable
    private Supplier<? extends Language> myLanguageSupplier;
    private Boolean myIsCamelWords;
    private final SoftWrapAppliancePlaces mySoftWrapAppliancePlace;
    private int myAdditionalLinesCount = Registry.intValue("editor.virtual.lines", 5);
    private int myAdditionalColumnsCount = 3;
    private int myLineCursorWidth = EditorUtil.getDefaultCaretWidth();
    private boolean myLineMarkerAreaShown = true;
    private boolean myAllowSingleLogicalLineFolding = false;
    private boolean myAutoCodeFoldingEnabled = true;
    private Integer myTabSize = null;
    private Integer myCachedTabSize = null;
    private Boolean myUseTabCharacter = null;
    private final Object myTabSizeLock = new Object();
    private Boolean myIsVirtualSpace = null;
    private Boolean myIsCaretInsideTabs = null;
    private Boolean myIsCaretBlinking = null;
    private Integer myCaretBlinkingPeriod = null;
    private Boolean myIsRightMarginShown = null;
    private Integer myRightMargin = null;
    private Boolean myAreLineNumbersShown = null;
    private Boolean myGutterIconsShown = null;
    private Boolean myIsFoldingOutlineShown = null;
    private Boolean myIsSmartHome = null;
    private Boolean myIsBlockCursor = null;
    private Boolean myCaretRowShown = null;
    private Boolean myIsWhitespacesShown = null;
    private Boolean myIsLeadingWhitespacesShown = null;
    private Boolean myIsInnerWhitespacesShown = null;
    private Boolean myIsTrailingWhitespacesShown = null;
    private Boolean myIndentGuidesShown = null;
    private Boolean myIsAnimatedScrolling = null;
    private Boolean myIsAdditionalPageAtBottom = null;
    private Boolean myIsDndEnabled = null;
    private Boolean myIsWheelFontChangeEnabled = null;
    private Boolean myIsMouseClickSelectionHonorsCamelWords = null;
    private Boolean myIsRenameVariablesInplace = null;
    private Boolean myIsRefrainFromScrolling = null;
    private Boolean myUseSoftWraps = null;
    private Boolean myUseCustomSoftWrapIndent = null;
    private Integer myCustomSoftWrapIndent = null;
    private Boolean myRenamePreselect = null;
    private Boolean myWrapWhenTypingReachesRightMargin = null;
    private Boolean myShowIntentionBulb = null;
    private List<Integer> mySoftMargins = null;

    public SettingsImpl() {
        this(null, null);
    }

    SettingsImpl(@Nullable EditorEx editor, @Nullable EditorKind kind) {
        this.myEditor = editor;
        this.mySoftWrapAppliancePlace = EditorKind.CONSOLE.equals((Object)kind) ? SoftWrapAppliancePlaces.CONSOLE : (EditorKind.PREVIEW.equals((Object)kind) ? SoftWrapAppliancePlaces.PREVIEW : SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    @Override
    public boolean isRightMarginShown() {
        return this.myIsRightMarginShown != null ? this.myIsRightMarginShown.booleanValue() : EditorSettingsExternalizable.getInstance().isRightMarginShown();
    }

    @Override
    public void setRightMarginShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsRightMarginShown)) {
            return;
        }
        this.myIsRightMarginShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isWhitespacesShown() {
        return this.myIsWhitespacesShown != null ? this.myIsWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isWhitespacesShown();
    }

    @Override
    public void setWhitespacesShown(boolean val) {
        this.myIsWhitespacesShown = val;
    }

    @Override
    public boolean isLeadingWhitespaceShown() {
        return this.myIsLeadingWhitespacesShown != null ? this.myIsLeadingWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isLeadingWhitespacesShown();
    }

    @Override
    public void setLeadingWhitespaceShown(boolean val) {
        this.myIsLeadingWhitespacesShown = val;
    }

    @Override
    public boolean isInnerWhitespaceShown() {
        return this.myIsInnerWhitespacesShown != null ? this.myIsInnerWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isInnerWhitespacesShown();
    }

    @Override
    public void setInnerWhitespaceShown(boolean val) {
        this.myIsInnerWhitespacesShown = val;
    }

    @Override
    public boolean isTrailingWhitespaceShown() {
        return this.myIsTrailingWhitespacesShown != null ? this.myIsTrailingWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isTrailingWhitespacesShown();
    }

    @Override
    public void setTrailingWhitespaceShown(boolean val) {
        this.myIsTrailingWhitespacesShown = val;
    }

    @Override
    public boolean isIndentGuidesShown() {
        return this.myIndentGuidesShown != null ? this.myIndentGuidesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
    }

    @Override
    public void setIndentGuidesShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIndentGuidesShown)) {
            return;
        }
        this.myIndentGuidesShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isLineNumbersShown() {
        return this.myAreLineNumbersShown != null ? this.myAreLineNumbersShown.booleanValue() : EditorSettingsExternalizable.getInstance().isLineNumbersShown();
    }

    @Override
    public void setLineNumbersShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myAreLineNumbersShown)) {
            return;
        }
        this.myAreLineNumbersShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean areGutterIconsShown() {
        return this.myGutterIconsShown != null ? this.myGutterIconsShown.booleanValue() : EditorSettingsExternalizable.getInstance().areGutterIconsShown();
    }

    @Override
    public void setGutterIconsShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myGutterIconsShown)) {
            return;
        }
        this.myGutterIconsShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public int getRightMargin(Project project2) {
        if (this.myRightMargin != null) {
            return this.myRightMargin;
        }
        return this.myEditor != null ? CodeStyle.getSettings(this.myEditor).getRightMargin(this.getLanguage()) : CodeStyle.getProjectOrDefaultSettings(project2).getRightMargin(this.getLanguage());
    }

    @Override
    public boolean isWrapWhenTypingReachesRightMargin(Project project2) {
        if (this.myWrapWhenTypingReachesRightMargin != null) {
            return this.myWrapWhenTypingReachesRightMargin;
        }
        return this.myEditor == null ? CodeStyle.getDefaultSettings().isWrapOnTyping(this.getLanguage()) : CodeStyle.getSettings(this.myEditor).isWrapOnTyping(this.getLanguage());
    }

    @Override
    public void setWrapWhenTypingReachesRightMargin(boolean val) {
        this.myWrapWhenTypingReachesRightMargin = val;
    }

    @Override
    public void setRightMargin(int rightMargin) {
        Integer newValue = rightMargin;
        if (newValue.equals(this.myRightMargin)) {
            return;
        }
        this.myRightMargin = newValue;
        this.fireEditorRefresh();
    }

    @Override
    @NotNull
    public List<Integer> getSoftMargins() {
        if (this.mySoftMargins != null) {
            List<Integer> list2 = this.mySoftMargins;
            if (list2 == null) {
                SettingsImpl.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<Integer> list3 = this.myEditor == null ? CodeStyle.getDefaultSettings().getSoftMargins(this.getLanguage()) : CodeStyle.getSettings(this.myEditor).getSoftMargins(this.getLanguage());
        if (list3 == null) {
            SettingsImpl.$$$reportNull$$$0(1);
        }
        return list3;
    }

    @Override
    public void setSoftMargins(@Nullable List<Integer> softMargins) {
        if (Objects.equals(this.mySoftMargins, softMargins)) {
            return;
        }
        this.mySoftMargins = softMargins != null ? new ArrayList<Integer>(softMargins) : null;
        this.fireEditorRefresh();
    }

    @Override
    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    @Override
    public void setAdditionalLinesCount(int additionalLinesCount) {
        if (this.myAdditionalLinesCount == additionalLinesCount) {
            return;
        }
        this.myAdditionalLinesCount = additionalLinesCount;
        this.fireEditorRefresh();
    }

    @Override
    public int getAdditionalColumnsCount() {
        return this.myAdditionalColumnsCount;
    }

    @Override
    public void setAdditionalColumnsCount(int additionalColumnsCount) {
        if (this.myAdditionalColumnsCount == additionalColumnsCount) {
            return;
        }
        this.myAdditionalColumnsCount = additionalColumnsCount;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isLineMarkerAreaShown() {
        return this.myLineMarkerAreaShown;
    }

    @Override
    public void setLineMarkerAreaShown(boolean lineMarkerAreaShown) {
        if (this.myLineMarkerAreaShown == lineMarkerAreaShown) {
            return;
        }
        this.myLineMarkerAreaShown = lineMarkerAreaShown;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isFoldingOutlineShown() {
        return this.myIsFoldingOutlineShown != null ? this.myIsFoldingOutlineShown.booleanValue() : EditorSettingsExternalizable.getInstance().isFoldingOutlineShown();
    }

    @Override
    public void setFoldingOutlineShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsFoldingOutlineShown)) {
            return;
        }
        this.myIsFoldingOutlineShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isAutoCodeFoldingEnabled() {
        return this.myAutoCodeFoldingEnabled;
    }

    @Override
    public void setAutoCodeFoldingEnabled(boolean val) {
        this.myAutoCodeFoldingEnabled = val;
    }

    @Override
    public boolean isUseTabCharacter(Project project2) {
        if (this.myUseTabCharacter != null) {
            return this.myUseTabCharacter;
        }
        PsiFile file2 = this.getPsiFile(project2);
        return file2 != null ? CodeStyle.getIndentOptions((PsiFile)file2).USE_TAB_CHARACTER : CodeStyle.getProjectOrDefaultSettings((Project)project2).getIndentOptions(null).USE_TAB_CHARACTER;
    }

    @Override
    public void setUseTabCharacter(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myUseTabCharacter)) {
            return;
        }
        this.myUseTabCharacter = newValue;
        this.fireEditorRefresh();
    }

    @Deprecated
    public SoftWrapAppliancePlaces getSoftWrapAppliancePlace() {
        return this.mySoftWrapAppliancePlace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitSettings() {
        Object object = this.myTabSizeLock;
        synchronized (object) {
            this.myCachedTabSize = null;
            this.reinitDocumentIndentOptions();
        }
    }

    private void reinitDocumentIndentOptions() {
        if (this.myEditor == null || this.myEditor.isViewer()) {
            return;
        }
        Project project2 = this.myEditor.getProject();
        DocumentEx document = this.myEditor.getDocument();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance(project2);
        PsiFile file2 = psiManager.getPsiFile(document);
        if (file2 == null) {
            return;
        }
        CodeStyle.updateDocumentIndentOptions(project2, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTabSize(Project project2) {
        Object object = this.myTabSizeLock;
        synchronized (object) {
            if (this.myTabSize != null) {
                return this.myTabSize;
            }
            if (this.myCachedTabSize == null) {
                int tabSize;
                try {
                    if (project2 == null || project2.isDisposed()) {
                        tabSize = CodeStyle.getDefaultSettings().getTabSize(null);
                    } else {
                        PsiFile file2 = this.getPsiFile(project2);
                        if (this.myEditor != null && this.myEditor.isViewer()) {
                            FileType fileType = file2 != null ? file2.getFileType() : null;
                            tabSize = CodeStyle.getSettings((Project)project2).getIndentOptions((FileType)fileType).TAB_SIZE;
                        } else {
                            tabSize = file2 != null ? CodeStyle.getIndentOptions((PsiFile)file2).TAB_SIZE : CodeStyle.getSettings(project2).getTabSize(null);
                        }
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("Error determining tab size", e);
                    tabSize = new CommonCodeStyleSettings.IndentOptions().TAB_SIZE;
                }
                this.myCachedTabSize = Math.max(1, tabSize);
            }
            return this.myCachedTabSize;
        }
    }

    @Nullable
    private PsiFile getPsiFile(@Nullable Project project2) {
        if (project2 != null && this.myEditor != null) {
            return PsiDocumentManager.getInstance(project2).getPsiFile(this.myEditor.getDocument());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTabSize(int tabSize) {
        Integer newValue = Math.max(1, tabSize);
        Object object = this.myTabSizeLock;
        synchronized (object) {
            if (newValue.equals(this.myTabSize)) {
                return;
            }
            this.myTabSize = newValue;
        }
        this.fireEditorRefresh();
    }

    @Override
    public boolean isSmartHome() {
        return this.myIsSmartHome != null ? this.myIsSmartHome.booleanValue() : EditorSettingsExternalizable.getInstance().isSmartHome();
    }

    @Override
    public void setSmartHome(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsSmartHome)) {
            return;
        }
        this.myIsSmartHome = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isVirtualSpace() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsVirtualSpace != null ? this.myIsVirtualSpace.booleanValue() : EditorSettingsExternalizable.getInstance().isVirtualSpace();
    }

    @Override
    public void setVirtualSpace(boolean allow) {
        Boolean newValue = allow;
        if (newValue.equals(this.myIsVirtualSpace)) {
            return;
        }
        this.myIsVirtualSpace = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isAdditionalPageAtBottom() {
        return this.myIsAdditionalPageAtBottom != null ? this.myIsAdditionalPageAtBottom.booleanValue() : EditorSettingsExternalizable.getInstance().isAdditionalPageAtBottom();
    }

    @Override
    public void setAdditionalPageAtBottom(boolean val) {
        this.myIsAdditionalPageAtBottom = val;
    }

    @Override
    public boolean isCaretInsideTabs() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsCaretInsideTabs != null ? this.myIsCaretInsideTabs.booleanValue() : EditorSettingsExternalizable.getInstance().isCaretInsideTabs();
    }

    @Override
    public void setCaretInsideTabs(boolean allow) {
        Boolean newValue = allow;
        if (newValue.equals(this.myIsCaretInsideTabs)) {
            return;
        }
        this.myIsCaretInsideTabs = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isBlockCursor() {
        return this.myIsBlockCursor != null ? this.myIsBlockCursor.booleanValue() : EditorSettingsExternalizable.getInstance().isBlockCursor();
    }

    @Override
    public void setBlockCursor(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsBlockCursor)) {
            return;
        }
        this.myIsBlockCursor = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isCaretRowShown() {
        return this.myCaretRowShown != null ? this.myCaretRowShown.booleanValue() : EditorSettingsExternalizable.getInstance().isCaretRowShown();
    }

    @Override
    public void setCaretRowShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myCaretRowShown)) {
            return;
        }
        this.myCaretRowShown = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public int getLineCursorWidth() {
        return this.myLineCursorWidth;
    }

    @Override
    public void setLineCursorWidth(int width) {
        this.myLineCursorWidth = width;
    }

    @Override
    public boolean isAnimatedScrolling() {
        return !SystemProperties.isTrueSmoothScrollingEnabled() && this.myIsAnimatedScrolling != null ? this.myIsAnimatedScrolling.booleanValue() : EditorSettingsExternalizable.getInstance().isSmoothScrolling();
    }

    @Override
    public void setAnimatedScrolling(boolean val) {
        this.myIsAnimatedScrolling = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isCamelWords() {
        return this.myIsCamelWords != null ? this.myIsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isCamelWords();
    }

    @Override
    public void setCamelWords(boolean val) {
        this.myIsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void resetCamelWords() {
        this.myIsCamelWords = null;
    }

    @Override
    public boolean isBlinkCaret() {
        return this.myIsCaretBlinking != null ? this.myIsCaretBlinking.booleanValue() : EditorSettingsExternalizable.getInstance().isBlinkCaret();
    }

    @Override
    public void setBlinkCaret(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsCaretBlinking)) {
            return;
        }
        this.myIsCaretBlinking = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public int getCaretBlinkPeriod() {
        return this.myCaretBlinkingPeriod != null ? this.myCaretBlinkingPeriod.intValue() : EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    @Override
    public void setCaretBlinkPeriod(int blinkPeriod) {
        Integer newValue = blinkPeriod;
        if (newValue.equals(this.myCaretBlinkingPeriod)) {
            return;
        }
        this.myCaretBlinkingPeriod = newValue;
        this.fireEditorRefresh();
    }

    @Override
    public boolean isDndEnabled() {
        return this.myIsDndEnabled != null ? this.myIsDndEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isDndEnabled();
    }

    @Override
    public void setDndEnabled(boolean val) {
        this.myIsDndEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isWheelFontChangeEnabled() {
        return this.myIsWheelFontChangeEnabled != null ? this.myIsWheelFontChangeEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled();
    }

    @Override
    public void setWheelFontChangeEnabled(boolean val) {
        this.myIsWheelFontChangeEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myIsMouseClickSelectionHonorsCamelWords != null ? this.myIsMouseClickSelectionHonorsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isMouseClickSelectionHonorsCamelWords();
    }

    @Override
    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myIsMouseClickSelectionHonorsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isVariableInplaceRenameEnabled() {
        return this.myIsRenameVariablesInplace != null ? this.myIsRenameVariablesInplace.booleanValue() : EditorSettingsExternalizable.getInstance().isVariableInplaceRenameEnabled();
    }

    @Override
    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myIsRenameVariablesInplace = val ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isRefrainFromScrolling() {
        if (this.myIsRefrainFromScrolling != null) {
            return this.myIsRefrainFromScrolling;
        }
        return EditorSettingsExternalizable.getInstance().isRefrainFromScrolling();
    }

    @Override
    public void setRefrainFromScrolling(boolean b) {
        this.myIsRefrainFromScrolling = b ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isUseSoftWraps() {
        if (this.myUseSoftWraps != null) {
            return this.myUseSoftWraps;
        }
        boolean softWrapsEnabled = EditorSettingsExternalizable.getInstance().isUseSoftWraps(this.mySoftWrapAppliancePlace);
        if (!softWrapsEnabled || this.mySoftWrapAppliancePlace != SoftWrapAppliancePlaces.MAIN_EDITOR || this.myEditor == null) {
            return softWrapsEnabled;
        }
        String masks = EditorSettingsExternalizable.getInstance().getSoftWrapFileMasks();
        if (masks.trim().equals("*")) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        return file2 != null && SettingsImpl.fileNameMatches(file2.getName(), masks);
    }

    private static boolean fileNameMatches(@NotNull String fileName, @NotNull String globPatterns) {
        if (fileName == null) {
            SettingsImpl.$$$reportNull$$$0(2);
        }
        if (globPatterns == null) {
            SettingsImpl.$$$reportNull$$$0(3);
        }
        for (String p : globPatterns.split(";")) {
            String pTrimmed = p.trim();
            if (pTrimmed.isEmpty() || !PatternUtil.fromMask(pTrimmed).matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUseSoftWraps(boolean use2) {
        Boolean newValue;
        Boolean bl = newValue = use2 ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myUseSoftWraps)) {
            return;
        }
        this.myUseSoftWraps = newValue;
        this.fireEditorRefresh();
    }

    void setUseSoftWrapsQuiet() {
        this.myUseSoftWraps = Boolean.TRUE;
    }

    @Override
    public boolean isAllSoftWrapsShown() {
        return EditorSettingsExternalizable.getInstance().isAllSoftWrapsShown();
    }

    @Override
    public boolean isUseCustomSoftWrapIndent() {
        return this.myUseCustomSoftWrapIndent == null ? EditorSettingsExternalizable.getInstance().isUseCustomSoftWrapIndent() : this.myUseCustomSoftWrapIndent.booleanValue();
    }

    @Override
    public void setUseCustomSoftWrapIndent(boolean useCustomSoftWrapIndent) {
        this.myUseCustomSoftWrapIndent = useCustomSoftWrapIndent;
    }

    @Override
    public int getCustomSoftWrapIndent() {
        return this.myCustomSoftWrapIndent == null ? EditorSettingsExternalizable.getInstance().getCustomSoftWrapIndent() : this.myCustomSoftWrapIndent.intValue();
    }

    @Override
    public void setCustomSoftWrapIndent(int indent) {
        this.myCustomSoftWrapIndent = indent;
    }

    @Override
    public boolean isAllowSingleLogicalLineFolding() {
        return this.myAllowSingleLogicalLineFolding;
    }

    @Override
    public void setAllowSingleLogicalLineFolding(boolean allow) {
        this.myAllowSingleLogicalLineFolding = allow;
    }

    private void fireEditorRefresh() {
        if (this.myEditor != null) {
            this.myEditor.reinitSettings();
        }
    }

    @Override
    public boolean isPreselectRename() {
        return this.myRenamePreselect == null ? EditorSettingsExternalizable.getInstance().isPreselectRename() : this.myRenamePreselect.booleanValue();
    }

    @Override
    public void setPreselectRename(boolean val) {
        this.myRenamePreselect = val;
    }

    @Override
    public boolean isShowIntentionBulb() {
        return this.myShowIntentionBulb == null ? EditorSettingsExternalizable.getInstance().isShowIntentionBulb() : this.myShowIntentionBulb.booleanValue();
    }

    @Override
    public void setShowIntentionBulb(boolean show2) {
        this.myShowIntentionBulb = show2;
    }

    @Nullable
    public Language getLanguage() {
        if (this.myLanguageSupplier != null) {
            return this.myLanguageSupplier.get();
        }
        return null;
    }

    @Override
    public void setLanguageSupplier(@Nullable Supplier<? extends Language> languageSupplier) {
        this.myLanguageSupplier = languageSupplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/SettingsImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftMargins";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/SettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileNameMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

