/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.WrapElementIterator;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WrapElementMeasuringIterator
extends WrapElementIterator {
    private final EditorView myView;
    private final Document myDocument;
    private final List<Inlay> inlineInlays;
    private final List<Inlay> afterLineEndInlays;
    private int inlineInlayIndex;
    private int afterLineEndInlayIndex;

    public WrapElementMeasuringIterator(@NotNull EditorView view, int startOffset, int endOffset) {
        if (view == null) {
            WrapElementMeasuringIterator.$$$reportNull$$$0(0);
        }
        super(view.getEditor(), startOffset, endOffset);
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.inlineInlays = view.getEditor().getInlayModel().getInlineElementsInRange(startOffset, endOffset);
        this.afterLineEndInlays = view.getEditor().getInlayModel().getAfterLineEndElementsInRange(DocumentUtil.getLineStartOffset(startOffset, this.myDocument), endOffset);
    }

    public float getElementEndX(float startX) {
        FoldRegion fold = this.getCurrentFold();
        if (fold == null) {
            int codePoint = this.getCodePoint();
            if (codePoint == 9) {
                return EditorUtil.nextTabStop(startX + this.getInlaysPrefixWidth(), this.myView.getPlainSpaceWidth(), this.myView.getTabSize()) + this.getInlaysSuffixWidth();
            }
            if (codePoint == 13) {
                return startX;
            }
            return startX + this.getInlaysPrefixWidth() + this.myView.getCodePointWidth(codePoint, this.getFontStyle()) + this.getInlaysSuffixWidth();
        }
        return startX + this.myView.getFoldRegionLayout(fold).getWidth();
    }

    private float getInlaysPrefixWidth() {
        return this.getInlaysWidthForOffset(this.getElementStartOffset());
    }

    private float getInlaysSuffixWidth() {
        int nextOffset = this.getElementEndOffset();
        if (nextOffset < this.myText.length() && "\r\n".indexOf(this.myText.charAt(nextOffset)) == -1 || this.nextIsFoldRegion()) {
            return 0.0f;
        }
        int afterLineEndInlaysWidth = this.getAfterLineEndInlaysWidth(this.getLogicalLine());
        return (float)this.getInlaysWidthForOffset(nextOffset) + (afterLineEndInlaysWidth == 0 ? 0.0f : this.myView.getPlainSpaceWidth() + (float)afterLineEndInlaysWidth);
    }

    private int getInlaysWidthForOffset(int offset) {
        while (this.inlineInlayIndex < this.inlineInlays.size() && this.inlineInlays.get(this.inlineInlayIndex).getOffset() < offset) {
            ++this.inlineInlayIndex;
        }
        while (this.inlineInlayIndex > 0 && this.inlineInlays.get(this.inlineInlayIndex - 1).getOffset() >= offset) {
            --this.inlineInlayIndex;
        }
        int width = 0;
        while (this.inlineInlayIndex < this.inlineInlays.size() && this.inlineInlays.get(this.inlineInlayIndex).getOffset() == offset) {
            width += this.inlineInlays.get(this.inlineInlayIndex++).getWidthInPixels();
        }
        return width;
    }

    private int getAfterLineEndInlaysWidth(int logicalLine) {
        Inlay inlay;
        int offset;
        int startOffset = this.myDocument.getLineStartOffset(logicalLine);
        int endOffset = this.myDocument.getLineEndOffset(logicalLine);
        while (this.afterLineEndInlayIndex < this.afterLineEndInlays.size() && this.afterLineEndInlays.get(this.afterLineEndInlayIndex).getOffset() < startOffset) {
            ++this.afterLineEndInlayIndex;
        }
        while (this.afterLineEndInlayIndex > 0 && this.afterLineEndInlays.get(this.afterLineEndInlayIndex - 1).getOffset() >= startOffset) {
            --this.afterLineEndInlayIndex;
        }
        int width = 0;
        while (this.afterLineEndInlayIndex < this.afterLineEndInlays.size() && (offset = (inlay = this.afterLineEndInlays.get(this.afterLineEndInlayIndex)).getOffset()) >= startOffset && offset <= endOffset) {
            width += inlay.getWidthInPixels();
            ++this.afterLineEndInlayIndex;
        }
        return width;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/WrapElementMeasuringIterator", "<init>"));
    }
}

