/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributesEffectsBuilder {
    private static final Logger LOG = Logger.getInstance(TextAttributesEffectsBuilder.class);
    private static final Map<EffectType, EffectSlot> EFFECT_SLOTS_MAP = ContainerUtil.immutableMapBuilder().put(EffectType.STRIKEOUT, EffectSlot.STRIKE_SLOT).put(EffectType.BOXED, EffectSlot.FRAME_SLOT).put(EffectType.ROUNDED_BOX, EffectSlot.FRAME_SLOT).put(EffectType.BOLD_LINE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT).put(EffectType.LINE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT).put(EffectType.WAVE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT).put(EffectType.BOLD_DOTTED_LINE, EffectSlot.UNDERLINE_SLOT).build();
    private final Map<EffectSlot, EffectDescriptor> myEffectsMap = new HashMap<EffectSlot, EffectDescriptor>(EffectSlot.values().length);

    private TextAttributesEffectsBuilder() {
    }

    @NotNull
    public static TextAttributesEffectsBuilder create() {
        return new TextAttributesEffectsBuilder();
    }

    @NotNull
    public static TextAttributesEffectsBuilder create(@NotNull TextAttributes deepestAttributes) {
        if (deepestAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(0);
        }
        return TextAttributesEffectsBuilder.create().coverWith(deepestAttributes);
    }

    @NotNull
    public final TextAttributesEffectsBuilder coverWith(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(1);
        }
        attributes.forEachAdditionalEffect(this::coverWith);
        this.coverWith(attributes.getEffectType(), attributes.getEffectColor());
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(2);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public final TextAttributesEffectsBuilder slipUnder(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(3);
        }
        this.slipUnder(attributes.getEffectType(), attributes.getEffectColor());
        attributes.forEachAdditionalEffect(this::slipUnder);
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(4);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder coverWith(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::put);
    }

    @NotNull
    public TextAttributesEffectsBuilder slipUnder(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::putIfAbsent);
    }

    @NotNull
    private TextAttributesEffectsBuilder mutateBuilder(@Nullable EffectType effectType, @Nullable Color effectColor, @NotNull BiConsumer<? super EffectSlot, ? super EffectDescriptor> slotMutator) {
        if (slotMutator == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(5);
        }
        if (effectColor != null && effectType != null) {
            EffectSlot slot = EFFECT_SLOTS_MAP.get((Object)effectType);
            if (slot != null) {
                slotMutator.accept(slot, EffectDescriptor.create(effectType, effectColor));
            } else {
                LOG.debug("Effect " + (Object)((Object)effectType) + " is not supported by builder");
            }
        }
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(6);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    Map<EffectType, Color> getEffectsMap() {
        if (this.myEffectsMap.isEmpty()) {
            Map<EffectType, Color> map2 = Collections.emptyMap();
            if (map2 == null) {
                TextAttributesEffectsBuilder.$$$reportNull$$$0(7);
            }
            return map2;
        }
        HashMap<EffectType, Color> result2 = new HashMap<EffectType, Color>();
        this.myEffectsMap.forEach((key, val) -> {
            if (val != null) {
                result2.put(val.effectType, val.effectColor);
            }
        });
        HashMap<EffectType, Color> hashMap = result2;
        if (hashMap == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    public TextAttributes applyTo(@NotNull TextAttributes targetAttributes) {
        Iterator<EffectDescriptor> effectsIterator;
        if (targetAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(9);
        }
        if (!(effectsIterator = this.myEffectsMap.values().iterator()).hasNext()) {
            targetAttributes.setEffectColor(null);
            targetAttributes.setEffectType(EffectType.BOXED);
            targetAttributes.setAdditionalEffects(Collections.emptyMap());
        } else {
            EffectDescriptor mainEffectDescriptor = effectsIterator.next();
            targetAttributes.setEffectType(mainEffectDescriptor.effectType);
            targetAttributes.setEffectColor(mainEffectDescriptor.effectColor);
            int effectsLeft = this.myEffectsMap.size() - 1;
            if (effectsLeft == 0) {
                targetAttributes.setAdditionalEffects(Collections.emptyMap());
            } else if (effectsLeft == 1) {
                EffectDescriptor additionalEffect = effectsIterator.next();
                targetAttributes.setAdditionalEffects(Collections.singletonMap(additionalEffect.effectType, additionalEffect.effectColor));
            } else {
                HashMap<EffectType, Color> effectsMap = new HashMap<EffectType, Color>(effectsLeft);
                effectsIterator.forEachRemaining(it -> effectsMap.put(it.effectType, it.effectColor));
                targetAttributes.setAdditionalEffects(effectsMap);
            }
        }
        TextAttributes textAttributes = targetAttributes;
        if (textAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(10);
        }
        return textAttributes;
    }

    @Nullable
    @Contract(value="null -> null")
    public EffectDescriptor getEffectDescriptor(@Nullable EffectSlot effectSlot) {
        return this.myEffectsMap.get((Object)effectSlot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepestAttributes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slotMutator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "coverWith";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "slipUnder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mutateBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectsMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "coverWith";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "slipUnder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mutateBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EffectDescriptor {
        @NotNull
        public final EffectType effectType;
        @NotNull
        public final Color effectColor;

        private EffectDescriptor(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(0);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(1);
            }
            this.effectType = effectType;
            this.effectColor = effectColor;
        }

        @NotNull
        static EffectDescriptor create(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(2);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(3);
            }
            return new EffectDescriptor(effectType, effectColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectColor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder$EffectDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum EffectSlot {
        FRAME_SLOT,
        UNDERLINE_SLOT,
        STRIKE_SLOT;

    }
}

