/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public abstract class ForcedCopyModeAction
extends DumbAwareAction {
    private final boolean myRichCopyEnabled;

    protected ForcedCopyModeAction(boolean richCopyEnabled) {
        this.myRichCopyEnabled = richCopyEnabled;
        this.setEnabledInModalContext(true);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ForcedCopyModeAction.$$$reportNull$$$0(0);
        }
        Presentation p = e.getPresentation();
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        p.setVisible(RichCopySettings.getInstance().isEnabled() != this.myRichCopyEnabled && (e.isFromActionToolbar() || editor != null && editor.getSelectionModel().hasSelection(true)) && (editor == null || ForcedCopyModeAction.isRichCopyPossible(editor)));
        p.setEnabled(true);
    }

    private static boolean isRichCopyPossible(@NotNull Editor editor) {
        if (editor == null) {
            ForcedCopyModeAction.$$$reportNull$$$0(1);
        }
        return FileDocumentManager.getInstance().getFile(editor.getDocument()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ForcedCopyModeAction.$$$reportNull$$$0(2);
        }
        RichCopySettings settings = RichCopySettings.getInstance();
        boolean savedValue = settings.isEnabled();
        try {
            settings.setEnabled(this.myRichCopyEnabled);
            ActionManager.getInstance().getAction("EditorCopy").actionPerformed(e);
        }
        finally {
            settings.setEnabled(savedValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/richcopy/ForcedCopyModeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRichCopyPossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

