/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.util.registry.Registry;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntaxAwareReader
extends Reader {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareReader.class);
    protected String myRawText;
    @NotNull
    protected final SyntaxInfo mySyntaxInfo;
    @Nullable
    private transient Reader myDelegate;

    public AbstractSyntaxAwareReader(@NotNull SyntaxInfo syntaxInfo) {
        if (syntaxInfo == null) {
            AbstractSyntaxAwareReader.$$$reportNull$$$0(0);
        }
        this.mySyntaxInfo = syntaxInfo;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(char @NotNull [] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            AbstractSyntaxAwareReader.$$$reportNull$$$0(1);
        }
        return this.getDelegate().read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private Reader getDelegate() {
        if (this.myDelegate != null) {
            Reader reader = this.myDelegate;
            if (reader == null) {
                AbstractSyntaxAwareReader.$$$reportNull$$$0(2);
            }
            return reader;
        }
        Reader reader = this.myDelegate = new StringReader(this.getBuffer().toString());
        if (reader == null) {
            AbstractSyntaxAwareReader.$$$reportNull$$$0(3);
        }
        return reader;
    }

    @NotNull
    public final CharSequence getBuffer() {
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, Registry.intValue("editor.richcopy.max.size.megabytes") * 0x100000);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + buffer);
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            AbstractSyntaxAwareReader.$$$reportNull$$$0(4);
        }
        return stringBuilder;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbuf";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

