/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.openapi.util.UserDataHolderBase;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextComponentCaret
extends UserDataHolderBase
implements Caret {
    private final TextComponentEditorImpl myEditor;

    TextComponentCaret(TextComponentEditorImpl editor) {
        this.myEditor = editor;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        TextComponentEditorImpl textComponentEditorImpl = this.myEditor;
        if (textComponentEditorImpl == null) {
            TextComponentCaret.$$$reportNull$$$0(0);
        }
        return textComponentEditorImpl;
    }

    @Override
    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        if (caretModel == null) {
            TextComponentCaret.$$$reportNull$$$0(1);
        }
        return caretModel;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, scrollToCaret);
    }

    @Override
    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(2);
        }
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    @Override
    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(3);
        }
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    @Override
    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    @Override
    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int currentPosition;
        JTextComponent textComponent = this.getTextComponent();
        int targetOffset = Math.min(offset, textComponent.getText().length());
        if (targetOffset != (currentPosition = textComponent.getCaretPosition())) {
            if (targetOffset == textComponent.getCaret().getMark()) {
                textComponent.setCaretPosition(currentPosition);
                textComponent.moveCaretPosition(targetOffset);
            } else {
                textComponent.setCaretPosition(targetOffset);
            }
        }
    }

    @Override
    public boolean isUpToDate() {
        return true;
    }

    @Override
    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        JTextComponent textComponent = this.getTextComponent();
        int caretPos = textComponent.getCaretPosition();
        if (textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)textComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        return new LogicalPosition(line, caretPos - lineStart);
    }

    @Override
    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        return new VisualPosition(pos.line, pos.column);
    }

    @Override
    public int getOffset() {
        return this.getTextComponent().getCaretPosition();
    }

    @Override
    public int getVisualLineStart() {
        return 0;
    }

    @Override
    public int getVisualLineEnd() {
        return 0;
    }

    @Override
    public int getSelectionStart() {
        return this.getTextComponent().getSelectionStart();
    }

    @Override
    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionStart());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(4);
        }
        return visualPosition;
    }

    @Override
    public int getSelectionEnd() {
        return this.getTextComponent().getSelectionEnd();
    }

    @Override
    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionEnd());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    @Override
    @Nullable
    public String getSelectedText() {
        return this.getTextComponent().getSelectedText();
    }

    @Override
    public int getLeadSelectionOffset() {
        JTextComponent textComponent = this.getTextComponent();
        int caretPosition = textComponent.getCaretPosition();
        int start2 = textComponent.getSelectionStart();
        int end = textComponent.getSelectionEnd();
        return caretPosition == start2 ? end : start2;
    }

    @Override
    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getLeadSelectionOffset());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    @Override
    public boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    @Override
    public void setSelection(int startOffset, int endOffset) {
        JTextComponent textComponent = this.getTextComponent();
        if (textComponent.getCaretPosition() == startOffset) {
            textComponent.setCaretPosition(endOffset);
            textComponent.moveCaretPosition(startOffset);
        } else {
            textComponent.setCaretPosition(startOffset);
            textComponent.moveCaretPosition(endOffset);
        }
    }

    @Override
    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    @Override
    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    @Override
    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    @Override
    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    @Override
    public void removeSelection() {
        JTextComponent textComponent = this.getTextComponent();
        int position = textComponent.getCaretPosition();
        textComponent.select(position, position);
    }

    @Override
    public void selectLineAtCaret() {
        SelectionModelImpl.doSelectLineAtCaret(this);
    }

    @Override
    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler2.execute(this.myEditor, null, DataManager.getInstance().getDataContext(this.myEditor.getComponent()));
    }

    @Override
    @Nullable
    public Caret clone(boolean above) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isAtRtlLocation() {
        return false;
    }

    @Override
    public boolean isAtBidiRunBoundary() {
        return false;
    }

    @Override
    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = CaretVisualAttributes.DEFAULT;
        if (caretVisualAttributes == null) {
            TextComponentCaret.$$$reportNull$$$0(7);
        }
        return caretVisualAttributes;
    }

    @Override
    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            TextComponentCaret.$$$reportNull$$$0(8);
        }
    }

    private JTextComponent getTextComponent() {
        return this.myEditor.getContentComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

