/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EmptyIndentsModel;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.textarea.TextAreaDocument;
import com.intellij.openapi.editor.textarea.TextComponentCaretModel;
import com.intellij.openapi.editor.textarea.TextComponentDocument;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.editor.textarea.TextComponentFoldingModel;
import com.intellij.openapi.editor.textarea.TextComponentInlayModel;
import com.intellij.openapi.editor.textarea.TextComponentScrollingModel;
import com.intellij.openapi.editor.textarea.TextComponentSelectionModel;
import com.intellij.openapi.editor.textarea.TextComponentSoftWrapModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentEditorImpl
extends UserDataHolderBase
implements TextComponentEditor {
    private final Project myProject;
    private final JTextComponent myTextComponent;
    private final TextComponentDocument myDocument;
    private final TextComponentCaretModel myCaretModel;
    private final TextComponentSelectionModel mySelectionModel;
    private final TextComponentScrollingModel myScrollingModel;
    private final TextComponentSoftWrapModel mySoftWrapModel;
    private final TextComponentFoldingModel myFoldingModel;
    private EditorSettings mySettings;

    public TextComponentEditorImpl(Project project2, @NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myTextComponent = textComponent;
        this.myDocument = textComponent instanceof JTextArea ? new TextAreaDocument((JTextArea)textComponent) : new TextComponentDocument(textComponent);
        this.myCaretModel = new TextComponentCaretModel(this);
        this.mySelectionModel = new TextComponentSelectionModel(this);
        this.myScrollingModel = new TextComponentScrollingModel(textComponent);
        this.mySoftWrapModel = new TextComponentSoftWrapModel();
        this.myFoldingModel = new TextComponentFoldingModel();
    }

    @Override
    @NotNull
    public Document getDocument() {
        TextComponentDocument textComponentDocument = this.myDocument;
        if (textComponentDocument == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(1);
        }
        return textComponentDocument;
    }

    @Override
    public boolean isViewer() {
        return !this.myTextComponent.isEditable();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(2);
        }
        return jTextComponent;
    }

    @Override
    @NotNull
    public JTextComponent getContentComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(3);
        }
        return jTextComponent;
    }

    @Override
    public void setBorder(@Nullable Border border) {
    }

    @Override
    public Insets getInsets() {
        return JBUI.emptyInsets();
    }

    @Override
    @NotNull
    public TextComponentSelectionModel getSelectionModel() {
        TextComponentSelectionModel textComponentSelectionModel = this.mySelectionModel;
        if (textComponentSelectionModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(4);
        }
        return textComponentSelectionModel;
    }

    @Override
    @NotNull
    public MarkupModel getMarkupModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public FoldingModel getFoldingModel() {
        TextComponentFoldingModel textComponentFoldingModel = this.myFoldingModel;
        if (textComponentFoldingModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(5);
        }
        return textComponentFoldingModel;
    }

    @Override
    @NotNull
    public ScrollingModel getScrollingModel() {
        TextComponentScrollingModel textComponentScrollingModel = this.myScrollingModel;
        if (textComponentScrollingModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(6);
        }
        return textComponentScrollingModel;
    }

    @Override
    @NotNull
    public CaretModel getCaretModel() {
        TextComponentCaretModel textComponentCaretModel = this.myCaretModel;
        if (textComponentCaretModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(7);
        }
        return textComponentCaretModel;
    }

    @Override
    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        TextComponentSoftWrapModel textComponentSoftWrapModel = this.mySoftWrapModel;
        if (textComponentSoftWrapModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(8);
        }
        return textComponentSoftWrapModel;
    }

    @Override
    @NotNull
    public InlayModel getInlayModel() {
        return new TextComponentInlayModel();
    }

    @Override
    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = EditorKind.UNTYPED;
        if (editorKind == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(9);
        }
        return editorKind;
    }

    @Override
    @NotNull
    public EditorSettings getSettings() {
        if (this.mySettings == null) {
            this.mySettings = new SettingsImpl();
        }
        EditorSettings editorSettings = this.mySettings;
        if (editorSettings == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(10);
        }
        return editorSettings;
    }

    @Override
    @NotNull
    public EditorColorsScheme getColorsScheme() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getLineHeight() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(12);
        }
        if (pos.line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        return this.myDocument.getLineStartOffset(pos.line) + pos.column;
    }

    @Override
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(13);
        }
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @Override
    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(16);
        }
        return new LogicalPosition(visiblePos.line, visiblePos.column);
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        return new LogicalPosition(line, offset - lineStartOffset);
    }

    @Override
    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        return new VisualPosition(line, offset - lineStartOffset);
    }

    @Override
    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset);
        if (visualPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(17);
        }
        return visualPosition;
    }

    @Override
    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(19);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(22);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(24);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isInsertMode() {
        return true;
    }

    @Override
    public boolean isColumnMode() {
        return false;
    }

    @Override
    public boolean isOneLineMode() {
        return !(this.myTextComponent instanceof JTextArea);
    }

    @Override
    @NotNull
    public EditorGutter getGutter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(25);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setHeaderComponent(@Nullable JComponent header) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean hasHeaderComponent() {
        return false;
    }

    @Override
    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    @NotNull
    public IndentsModel getIndentsModel() {
        return new EmptyIndentsModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentEditorImpl";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPos";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePos";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentEditorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToXY";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToPoint2D";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "xyToLogicalPosition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseMotionListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMouseEventArea";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

