/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarProvider;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarProvider;", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarProvider;", "actionGroupId", "", "(Ljava/lang/String;)V", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "toolbars", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "register", "", "toolbar", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateAllToolbarComponents", "Companion", "intellij.platform.ide.impl"})
public abstract class AbstractFloatingToolbarProvider
implements FloatingToolbarProvider {
    @NotNull
    private final ActionGroup actionGroup;
    private final CopyOnWriteArrayList<FloatingToolbarComponent> toolbars;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    @Override
    public void register(@NotNull FloatingToolbarComponent toolbar, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.toolbars.add(toolbar);
        Disposer.register(parentDisposable, new Disposable(this, toolbar){
            final /* synthetic */ AbstractFloatingToolbarProvider this$0;
            final /* synthetic */ FloatingToolbarComponent $toolbar;

            public final void dispose() {
                AbstractFloatingToolbarProvider.access$getToolbars$p(this.this$0).remove(this.$toolbar);
            }
            {
                this.this$0 = abstractFloatingToolbarProvider;
                this.$toolbar = floatingToolbarComponent;
            }
        });
    }

    public final void updateAllToolbarComponents() {
        Iterable $this$forEach$iv = this.toolbars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FloatingToolbarComponent it = (FloatingToolbarComponent)element$iv;
            boolean bl = false;
            it.update();
        }
    }

    public AbstractFloatingToolbarProvider(@NotNull String actionGroupId) {
        Intrinsics.checkParameterIsNotNull((Object)actionGroupId, (String)"actionGroupId");
        this.actionGroup = AbstractFloatingToolbarProvider.Companion.resolveActionGroup(actionGroupId);
        this.toolbars = new CopyOnWriteArrayList();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance("#com.intellij.openapi.editor.toolbar.floating");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026editor.toolbar.floating\")");
        LOG = logger;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getToolbars$p(AbstractFloatingToolbarProvider $this) {
        return $this.toolbars;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "resolveActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "actionGroupId", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final ActionGroup resolveActionGroup(String actionGroupId) {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction action2 = actionManager.getAction(actionGroupId);
            if (action2 instanceof ActionGroup) {
                return (ActionGroup)action2;
            }
            LOG.warn("Cannot initialize action group using (" + action2.getClass() + ')');
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            actionManager.registerAction(actionGroupId, defaultActionGroup);
            return defaultActionGroup;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

