/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.editor.toolbar.floating.ToolbarVisibilityController;
import com.intellij.openapi.editor.toolbar.floating.VisibilityController;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponentImpl;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "parentComponent", "Ljavax/swing/JComponent;", "contextComponent", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "autoHideable", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljavax/swing/JComponent;Ljavax/swing/JComponent;Lcom/intellij/openapi/actionSystem/ActionGroup;ZLcom/intellij/openapi/Disposable;)V", "actionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "visibilityController", "Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController;", "getData", "", "dataId", "", "paint", "", "g", "Ljava/awt/Graphics;", "paintChildren", "paintComponent", "scheduleHide", "scheduleShow", "update", "Companion", "intellij.platform.ide.impl"})
public final class FloatingToolbarComponentImpl
extends JPanel
implements FloatingToolbarComponent,
DataProvider {
    private final ActionToolbar actionToolbar;
    private final VisibilityController visibilityController;
    private final JComponent contextComponent;
    @NotNull
    private static final JBColor BACKGROUND;
    private static final float BACKGROUND_ALPHA = 0.9f;
    private static final float FOREGROUND_ALPHA = 1.0f;
    public static final Companion Companion;

    @Override
    public void update() {
        this.actionToolbar.updateActionsImmediately();
    }

    @Override
    public void scheduleShow() {
        this.visibilityController.scheduleShow();
    }

    @Override
    public void scheduleHide() {
        this.visibilityController.scheduleHide();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        if (FloatingToolbarComponent.Companion.getKEY().is(dataId)) {
            return this;
        }
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext(this.contextComponent);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"dataManager.getDataContext(contextComponent)");
        DataContext dataContext2 = dataContext;
        return dataContext2.getData(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2 = (Graphics2D)graphics;
        try {
            float alpha = this.visibilityController.getOpacity() * 1.0f;
            graphics2.setComposite(AlphaComposite.getInstance(10, alpha));
            super.paintChildren(graphics2);
        }
        finally {
            graphics2.dispose();
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        this.paintComponent(g);
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Rectangle r = this.getBounds();
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2 = (Graphics2D)graphics;
        try {
            float alpha = this.visibilityController.getOpacity() * 0.9f;
            graphics2.setComposite(AlphaComposite.getInstance(3, alpha));
            graphics2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2.setColor(BACKGROUND);
            graphics2.fillRoundRect(0, 0, r.width, r.height, 6, 6);
        }
        finally {
            graphics2.dispose();
        }
    }

    public FloatingToolbarComponentImpl(@NotNull JComponent parentComponent, @NotNull JComponent contextComponent, @NotNull ActionGroup actionGroup, boolean autoHideable, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkParameterIsNotNull((Object)contextComponent, (String)"contextComponent");
        Intrinsics.checkParameterIsNotNull((Object)actionGroup, (String)"actionGroup");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.contextComponent = contextComponent;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setVisible(false);
        this.actionToolbar = new ActionToolbarImpl("ContextToolbar", actionGroup, true);
        this.actionToolbar.setTargetComponent(this);
        this.actionToolbar.setMinimumButtonSize(new Dimension(22, 22));
        ((ActionToolbarImpl)this.actionToolbar).setSkipWindowAdjustments(true);
        this.actionToolbar.setReservePlaceAutoPopupIcon(false);
        ((ActionToolbarImpl)this.actionToolbar).setOpaque(false);
        this.add((Component)((Object)this.actionToolbar), "Center");
        this.visibilityController = new ToolbarVisibilityController(autoHideable, parentComponent, this.actionToolbar, this);
        this.visibilityController.scheduleHide();
        Disposer.register(parentDisposable, this.visibilityController);
    }

    static {
        Companion = new Companion(null);
        JBColor jBColor = JBColor.namedColor("Toolbar.Floating.background", new JBColor(0xEDEDED, 4541005));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"Tool\u2026olor(0xEDEDED, 0x454A4D))");
        BACKGROUND = jBColor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponentImpl$Companion;", "", "()V", "BACKGROUND", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getBACKGROUND", "()Lcom/intellij/ui/JBColor;", "BACKGROUND_ALPHA", "", "FOREGROUND_ALPHA", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final JBColor getBACKGROUND() {
            return BACKGROUND;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

