/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionProcessingHelper {
    public static <T> void forEachExtensionSafe(@NotNull Consumer<? super T> extensionConsumer, @NotNull Iterable<? extends T> iterable) {
        if (extensionConsumer == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(0);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(1);
        }
        for (T t : iterable) {
            if (t == null) break;
            try {
                extensionConsumer.accept(t);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
    }

    @Nullable
    public static <T> T findFirstSafe(@NotNull Predicate<? super T> predicate, @NotNull Iterable<? extends T> iterable) {
        if (predicate == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(2);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(3);
        }
        return (T)ExtensionProcessingHelper.computeSafeIfAny(o -> predicate.test(o) ? o : null, iterable);
    }

    @Nullable
    public static <T, R> R computeSafeIfAny(@NotNull Function<? super T, ? extends R> processor2, @NotNull Iterable<? extends T> iterable) {
        if (processor2 == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(4);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(5);
        }
        for (T t : iterable) {
            if (t == null) {
                return null;
            }
            try {
                R result2 = processor2.apply(t);
                if (result2 == null) continue;
                return result2;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionConsumer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionProcessingHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachExtensionSafe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstSafe";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeSafeIfAny";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

