/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExternalSystemRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExternalSystemRunConfigurationMenu.$$$reportNull$$$0(0);
        }
        for (AnAction action2 : this.getChildActionsOrStubs()) {
            if (!(action2 instanceof ExecuteExternalSystemRunConfigurationAction)) continue;
            this.remove(action2);
        }
        Project project2 = e.getProject();
        List<ExternalSystemNode> selectedNodes = e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunConfigurationNode runConfigurationNode = (RunConfigurationNode)selectedNodes.get(0);
        RunnerAndConfigurationSettings settings = runConfigurationNode.getSettings();
        if (settings == null || project2 == null) {
            return;
        }
        ProjectSystemId projectSystemId = e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        ArrayList<Executor> executors = new ArrayList<Executor>();
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (executor instanceof ExecutorGroup) {
                executors.addAll(((ExecutorGroup)executor).childExecutors());
                continue;
            }
            executors.add(executor);
        }
        int i = executors.size();
        while (--i >= 0) {
            Executor executor;
            executor = (Executor)executors.get(i);
            if (!executor.isApplicable(project2)) continue;
            ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(executor.getId(), settings.getConfiguration());
            ExecuteExternalSystemRunConfigurationAction action3 = new ExecuteExternalSystemRunConfigurationAction(executor, runner != null, project2, projectSystemId, settings);
            this.addAction(action3, Constraints.FIRST);
        }
        super.update(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu", "update"));
    }

    private static class ExecuteExternalSystemRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;
        private final ProjectSystemId mySystemId;

        ExecuteExternalSystemRunConfigurationAction(Executor executor, boolean enabled, Project project2, ProjectSystemId projectSystemId, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project2;
            this.mySettings = settings;
            this.mySystemId = projectSystemId;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                ExecuteExternalSystemRunConfigurationAction.$$$reportNull$$$0(0);
            }
            if (this.myEnabled) {
                ExternalSystemActionsCollector.trigger(this.myProject, this.mySystemId, this, event);
                ProgramRunnerUtil.executeConfiguration(this.mySettings, this.myExecutor);
                RunManager.getInstance(this.myProject).setSelectedConfiguration(this.mySettings);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteExternalSystemRunConfigurationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myEnabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu$ExecuteExternalSystemRunConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

