/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.task.ui.ConfigureTasksActivationDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenTasksActivationManagerAction
extends ExternalSystemNodeAction<AbstractExternalEntityData> {
    public OpenTasksActivationManagerAction() {
        super(AbstractExternalEntityData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer("external.system.task.activation.title", new Object[0]));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer("external.system.task.activation.description", "external system"));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenTasksActivationManagerAction.$$$reportNull$$$0(0);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        List<ExternalSystemNode> selectedNodes = e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        Object externalData = selectedNodes.get(0).getData();
        ProjectSystemId projectSystemId = this.getSystemId(e);
        e.getPresentation().setText(ExternalSystemBundle.messagePointer("external.system.task.activation.title", new Object[0]));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer("external.system.task.activation.description", projectSystemId.getReadableName()));
        boolean isProjectNode = externalData instanceof ProjectData || externalData instanceof ModuleData;
        return isProjectNode && StringUtil.isNotEmpty(((ExternalConfigPathAware)externalData).getLinkedExternalProjectPath());
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData externalEntityData, @NotNull AnActionEvent e) {
        ExternalConfigPathAware externalConfigPathAware;
        if (project2 == null) {
            OpenTasksActivationManagerAction.$$$reportNull$$$0(1);
        }
        if (projectSystemId == null) {
            OpenTasksActivationManagerAction.$$$reportNull$$$0(2);
        }
        if (externalEntityData == null) {
            OpenTasksActivationManagerAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            OpenTasksActivationManagerAction.$$$reportNull$$$0(4);
        }
        List<ExternalSystemNode> selectedNodes = e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        ExternalSystemNode externalSystemNode = ContainerUtil.getFirstItem(selectedNodes);
        assert (externalSystemNode != null);
        ExternalConfigPathAware externalConfigPathAware2 = externalConfigPathAware = externalSystemNode.getData() instanceof ExternalConfigPathAware ? (ExternalConfigPathAware)externalSystemNode.getData() : null;
        assert (externalConfigPathAware != null);
        new ConfigureTasksActivationDialog(project2, projectSystemId, externalConfigPathAware.getLinkedExternalProjectPath()).showAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalEntityData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/OpenTasksActivationManagerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

