/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.autoimport.ProjectNotificationAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/HideProjectRefreshAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.externalSystem.impl"})
public final class HideProjectRefreshAction
extends DumbAwareAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project3);
        notificationAware.hideNotification();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project3);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(notificationAware.isNotificationVisible());
    }

    public HideProjectRefreshAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        presentation.setText(ExternalSystemBundle.message("external.system.reload.notification.action.hide.text", new Object[0]));
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.Close);
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"templatePresentation");
        presentation3.setHoveredIcon(AllIcons.Actions.CloseHovered);
    }
}

