/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.externalSystem.autoimport.ProjectNotificationAware;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectRefreshActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "()V", "toolbarComponent", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getToolbarComponent", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "ensureValidActionVisibility", "", "e", "update", "isFileEditor", "", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.externalSystem.impl"})
public final class ProjectRefreshActionGroup
extends DefaultActionGroup {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        FloatingToolbarComponent floatingToolbarComponent = this.getToolbarComponent(e);
        if (floatingToolbarComponent == null) {
            return;
        }
        FloatingToolbarComponent toolbarComponent = floatingToolbarComponent;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project3);
        boolean bl = notificationAware.isNotificationVisible();
        if (bl) {
            toolbarComponent.scheduleShow();
        } else {
            toolbarComponent.scheduleHide();
        }
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        block2: {
            Editor editor;
            block1: {
                Editor editor2 = e.getData(CommonDataKeys.EDITOR);
                if (editor2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
                editor = editor2;
                if (!DiffUtil.isDiffEditor(editor)) break block1;
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setVisible(false);
                break block2;
            }
            if (this.isFileEditor(editor)) break block2;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setVisible(false);
        }
    }

    private final boolean isFileEditor(@NotNull Editor $this$isFileEditor) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager documentManager = fileDocumentManager;
        VirtualFile virtualFile2 = documentManager.getFile($this$isFileEditor.getDocument());
        if (virtualFile2 instanceof LightVirtualFileBase) {
            return false;
        }
        return virtualFile2 != null && virtualFile2.isValid();
    }

    private final FloatingToolbarComponent getToolbarComponent(@NotNull AnActionEvent $this$toolbarComponent) {
        return $this$toolbarComponent.getData(FloatingToolbarComponent.Companion.getKEY());
    }
}

