/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus$ModificationType$WhenMappings;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003 !\"B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010\u001c\u001a\u00020\n*\u00020\u001b2\u0006\u0010\b\u001a\u00020\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u001eH\u0002J(\u0010\u001f\u001a\u00020\n*\u00020\u001b2\u0006\u0010\b\u001a\u00020\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u001eH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "", "debugName", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "kotlin.jvm.PlatformType", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "isDirty", "", "isUpToDate", "markBroken", "stamp", "", "markDirty", "type", "markModified", "markReverted", "markSynchronized", "update", "event", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "ifFuture", "action", "Lkotlin/Function1;", "withFuture", "ModificationType", "ProjectEvent", "ProjectState", "intellij.platform.externalSystem.impl"})
public final class ProjectStatus {
    private final Logger LOG;
    private AtomicReference<ProjectState> state;
    private final String debugName;

    public final boolean isDirty() {
        return this.state.get() instanceof ProjectState.Dirty;
    }

    public final boolean isUpToDate() {
        boolean bl;
        ProjectState projectState = this.state.get();
        if (projectState instanceof ProjectState.Modified || projectState instanceof ProjectState.Dirty || projectState instanceof ProjectState.Broken) {
            bl = false;
        } else if (projectState instanceof ProjectState.Synchronized || projectState instanceof ProjectState.Reverted) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public final ModificationType getModificationType() {
        ProjectState state = this.state.get();
        return state instanceof ProjectState.Dirty ? ((ProjectState.Dirty)state).getType() : (state instanceof ProjectState.Modified ? ((ProjectState.Modified)state).getType() : null);
    }

    @NotNull
    public final ProjectState markBroken(long stamp) {
        return this.update(new ProjectEvent.Break(stamp));
    }

    @NotNull
    public final ProjectState markDirty(long stamp, @NotNull ModificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return this.update(new ProjectEvent.Invalidate(stamp, type));
    }

    public static /* synthetic */ ProjectState markDirty$default(ProjectStatus projectStatus, long l, ModificationType modificationType, int n, Object object) {
        if ((n & 2) != 0) {
            modificationType = ModificationType.INTERNAL;
        }
        return projectStatus.markDirty(l, modificationType);
    }

    @NotNull
    public final ProjectState markModified(long stamp, @NotNull ModificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return this.update(new ProjectEvent.Modify(stamp, type));
    }

    public static /* synthetic */ ProjectState markModified$default(ProjectStatus projectStatus, long l, ModificationType modificationType, int n, Object object) {
        if ((n & 2) != 0) {
            modificationType = ModificationType.INTERNAL;
        }
        return projectStatus.markModified(l, modificationType);
    }

    @NotNull
    public final ProjectState markReverted(long stamp) {
        return this.update(new ProjectEvent.Revert(stamp));
    }

    @NotNull
    public final ProjectState markSynchronized(long stamp) {
        return this.update(new ProjectEvent.Synchronize(stamp));
    }

    @NotNull
    public final ProjectState update(@NotNull ProjectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.LOG.isDebugEnabled()) {
            String debugPrefix = this.debugName == null ? "" : this.debugName + ": ";
            String eventName = Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName();
            ProjectState state = this.state.get();
            String stateName = state.getClass().getSimpleName();
            this.LOG.debug(debugPrefix + "Event " + eventName + " is happened at " + event.getStamp() + ". Current state " + stateName + " is changed at " + state.getStamp());
        }
        ProjectState newState2 = this.state.updateAndGet(new UnaryOperator<ProjectState>(this, event){
            final /* synthetic */ ProjectStatus this$0;
            final /* synthetic */ ProjectEvent $event;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final ProjectState apply(ProjectState currentState) {
                ProjectState projectState;
                ProjectState projectState2 = currentState;
                if (projectState2 instanceof ProjectState.Synchronized) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.newState.1.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Modified>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Modified invoke(long it) {
                                return new ProjectState.Modified(it, ((ProjectEvent.Modify)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Revert) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.4.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.5.INSTANCE);
                    }
                    return projectState;
                } else if (projectState2 instanceof ProjectState.Dirty) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.6.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this, currentState){
                            final /* synthetic */ update.newState.1 this$0;
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Dirty)this.$currentState).getType().merge(((ProjectEvent.Invalidate)this.this$0.$event).getType()));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this, currentState){
                            final /* synthetic */ update.newState.1 this$0;
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Dirty)this.$currentState).getType().merge(((ProjectEvent.Modify)this.this$0.$event).getType()));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Revert) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(currentState){
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Dirty)this.$currentState).getType());
                            }
                            {
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(currentState){
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Dirty)this.$currentState).getType());
                            }
                            {
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                    }
                    return projectState;
                } else if (projectState2 instanceof ProjectState.Modified) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.11.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this, currentState){
                            final /* synthetic */ update.newState.1 this$0;
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Modified)this.$currentState).getType().merge(((ProjectEvent.Invalidate)this.this$0.$event).getType()));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Modified>(this, currentState){
                            final /* synthetic */ update.newState.1 this$0;
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Modified invoke(long it) {
                                return new ProjectState.Modified(it, ((ProjectState.Modified)this.$currentState).getType().merge(((ProjectEvent.Modify)this.this$0.$event).getType()));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Revert) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.14.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(currentState){
                            final /* synthetic */ ProjectState $currentState;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectState.Modified)this.$currentState).getType());
                            }
                            {
                                this.$currentState = projectState;
                                super(1);
                            }
                        });
                    }
                    return projectState;
                } else if (projectState2 instanceof ProjectState.Reverted) {
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.16.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Modified>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Modified invoke(long it) {
                                return new ProjectState.Modified(it, ((ProjectEvent.Modify)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Revert) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.newState.19.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.20.INSTANCE);
                    }
                    return projectState;
                } else {
                    if (!(projectState2 instanceof ProjectState.Broken)) throw new NoWhenBranchMatchedException();
                    ProjectEvent projectEvent = this.$event;
                    if (projectEvent instanceof ProjectEvent.Synchronize) {
                        projectState = ProjectStatus.access$ifFuture(this.this$0, this.$event, currentState, update.newState.21.INSTANCE);
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Modify) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, (Function1)new Function1<Long, ProjectState.Dirty>(this){
                            final /* synthetic */ update.newState.1 this$0;

                            @NotNull
                            public final ProjectState.Dirty invoke(long it) {
                                return new ProjectState.Dirty(it, ((ProjectEvent.Modify)this.this$0.$event).getType());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        return projectState;
                    } else if (projectEvent instanceof ProjectEvent.Revert) {
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.newState.24.INSTANCE);
                        return projectState;
                    } else {
                        if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                        projectState = ProjectStatus.access$withFuture(this.this$0, this.$event, currentState, update.newState.25.INSTANCE);
                    }
                }
                return projectState;
            }
            {
                this.this$0 = projectStatus;
                this.$event = projectEvent;
            }
        });
        if (this.LOG.isDebugEnabled()) {
            String debugPrefix = this.debugName == null ? "" : this.debugName + ": ";
            String eventName = Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName();
            ProjectState state = this.state.get();
            String stateName = state.getClass().getSimpleName();
            this.LOG.debug(debugPrefix + "State is " + stateName + " at " + state.getStamp() + " after event " + eventName + " that happen at " + event.getStamp() + '.');
        }
        ProjectState projectState = newState2;
        Intrinsics.checkExpressionValueIsNotNull((Object)projectState, (String)"newState");
        return projectState;
    }

    private final ProjectState withFuture(@NotNull ProjectEvent $this$withFuture, ProjectState state, Function1<? super Long, ? extends ProjectState> action2) {
        long l = $this$withFuture.getStamp();
        long l2 = state.getStamp();
        Function1<? super Long, ? extends ProjectState> function1 = action2;
        boolean bl = false;
        long l3 = Math.max(l, l2);
        return (ProjectState)function1.invoke((Object)l3);
    }

    private final ProjectState ifFuture(@NotNull ProjectEvent $this$ifFuture, ProjectState state, Function1<? super Long, ? extends ProjectState> action2) {
        return $this$ifFuture.getStamp() > state.getStamp() ? (ProjectState)action2.invoke((Object)$this$ifFuture.getStamp()) : state;
    }

    public ProjectStatus(@Nullable String debugName) {
        this.debugName = debugName;
        Logger logger = Logger.getInstance("#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        this.LOG = logger;
        this.state = new AtomicReference<ProjectState>(new ProjectState.Synchronized(-1L));
    }

    public /* synthetic */ ProjectStatus(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public ProjectStatus() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ProjectState access$withFuture(ProjectStatus $this, ProjectEvent $this$access_u24withFuture, ProjectState state, Function1 action2) {
        return $this.withFuture($this$access_u24withFuture, state, (Function1<? super Long, ? extends ProjectState>)action2);
    }

    public static final /* synthetic */ ProjectState access$ifFuture(ProjectStatus $this, ProjectEvent $this$access_u24ifFuture, ProjectState state, Function1 action2) {
        return $this.ifFuture($this$access_u24ifFuture, state, (Function1<? super Long, ? extends ProjectState>)action2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "", "(Ljava/lang/String;I)V", "merge", "other", "EXTERNAL", "INTERNAL", "intellij.platform.externalSystem.impl"})
    public static final class ModificationType
    extends Enum<ModificationType> {
        public static final /* enum */ ModificationType EXTERNAL;
        public static final /* enum */ ModificationType INTERNAL;
        private static final /* synthetic */ ModificationType[] $VALUES;

        static {
            ModificationType[] modificationTypeArray = new ModificationType[2];
            ModificationType[] modificationTypeArray2 = modificationTypeArray;
            modificationTypeArray[0] = EXTERNAL = new ModificationType();
            modificationTypeArray[1] = INTERNAL = new ModificationType();
            $VALUES = modificationTypeArray;
        }

        @NotNull
        public final ModificationType merge(@NotNull ModificationType other) {
            ModificationType modificationType;
            Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
            switch (ProjectStatus$ModificationType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    modificationType = INTERNAL;
                    break;
                }
                case 2: {
                    modificationType = other;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return modificationType;
        }

        public static ModificationType[] values() {
            return (ModificationType[])$VALUES.clone();
        }

        public static ModificationType valueOf(String string) {
            return Enum.valueOf(ModificationType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "", "stamp", "", "(J)V", "getStamp", "()J", "Break", "Invalidate", "Modify", "Revert", "Synchronize", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Revert;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Break;", "intellij.platform.externalSystem.impl"})
    public static abstract class ProjectEvent {
        private final long stamp;

        public final long getStamp() {
            return this.stamp;
        }

        private ProjectEvent(long stamp) {
            this.stamp = stamp;
        }

        public /* synthetic */ ProjectEvent(long stamp, DefaultConstructorMarker $constructor_marker) {
            this(stamp);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Synchronize
        extends ProjectEvent {
            public Synchronize(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "(JLcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;)V", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "intellij.platform.externalSystem.impl"})
        public static final class Invalidate
        extends ProjectEvent {
            @NotNull
            private final ModificationType type;

            @NotNull
            public final ModificationType getType() {
                return this.type;
            }

            public Invalidate(long stamp, @NotNull ModificationType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                super(stamp, null);
                this.type = type;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "(JLcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;)V", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "intellij.platform.externalSystem.impl"})
        public static final class Modify
        extends ProjectEvent {
            @NotNull
            private final ModificationType type;

            @NotNull
            public final ModificationType getType() {
                return this.type;
            }

            public Modify(long stamp, @NotNull ModificationType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                super(stamp, null);
                this.type = type;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Revert;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Revert
        extends ProjectEvent {
            public Revert(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Break;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Break
        extends ProjectEvent {
            public Break(long stamp) {
                super(stamp, null);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "", "stamp", "", "(J)V", "getStamp", "()J", "Broken", "Dirty", "Modified", "Reverted", "Synchronized", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Synchronized;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Reverted;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Broken;", "intellij.platform.externalSystem.impl"})
    public static abstract class ProjectState {
        private final long stamp;

        public final long getStamp() {
            return this.stamp;
        }

        private ProjectState(long stamp) {
            this.stamp = stamp;
        }

        public /* synthetic */ ProjectState(long stamp, DefaultConstructorMarker $constructor_marker) {
            this(stamp);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Synchronized;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Synchronized
        extends ProjectState {
            public Synchronized(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "(JLcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;)V", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "intellij.platform.externalSystem.impl"})
        public static final class Dirty
        extends ProjectState {
            @NotNull
            private final ModificationType type;

            @NotNull
            public final ModificationType getType() {
                return this.type;
            }

            public Dirty(long stamp, @NotNull ModificationType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                super(stamp, null);
                this.type = type;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "(JLcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;)V", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "intellij.platform.externalSystem.impl"})
        public static final class Modified
        extends ProjectState {
            @NotNull
            private final ModificationType type;

            @NotNull
            public final ModificationType getType() {
                return this.type;
            }

            public Modified(long stamp, @NotNull ModificationType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                super(stamp, null);
                this.type = type;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Reverted;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Reverted
        extends ProjectState {
            public Reverted(long stamp) {
                super(stamp, null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Broken;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "", "(J)V", "intellij.platform.externalSystem.impl"})
        public static final class Broken
        extends ProjectState {
            public Broken(long stamp) {
                super(stamp, null);
            }
        }
    }
}

