/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.operations.CompoundParallelOperationTrace;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/DocumentsChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesProvider;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "()V", "bulkUpdateOperation", "Lcom/intellij/openapi/observable/operations/CompoundParallelOperationTrace;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "bulkUpdateFinished", "", "document", "bulkUpdateStarting", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "isExternalModification", "", "subscribe", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.externalSystem.impl"})
public final class DocumentsChangesProvider
implements FilesChangesProvider,
DocumentListener {
    private final EventDispatcher<FilesChangesListener> eventDispatcher;
    private final CompoundParallelOperationTrace<Document> bulkUpdateOperation;

    @Override
    public void subscribe(@NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((FilesChangesListener)((EventListener)listener2), parentDisposable);
    }

    private final boolean isExternalModification() {
        return ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.isExternalModification()) {
            return;
        }
        Document document = event.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.document");
        Document document2 = document;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        VirtualFile virtualFile2 = fileDocumentManager2.getFile(document2);
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"fileDocumentManager.getFile(document) ?: return");
        VirtualFile file2 = virtualFile2;
        boolean bl = this.bulkUpdateOperation.isOperationCompleted();
        if (bl) {
            this.eventDispatcher.getMulticaster().init();
            String string = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            this.eventDispatcher.getMulticaster().onFileChange(string, document2.getModificationStamp(), ProjectStatus.ModificationType.INTERNAL);
            this.eventDispatcher.getMulticaster().apply();
        } else {
            String string = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            this.eventDispatcher.getMulticaster().onFileChange(string, document2.getModificationStamp(), ProjectStatus.ModificationType.INTERNAL);
        }
    }

    @Override
    public void bulkUpdateStarting(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.bulkUpdateOperation.startTask(document);
    }

    @Override
    public void bulkUpdateFinished(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.bulkUpdateOperation.finishTask(document);
    }

    public DocumentsChangesProvider() {
        EventDispatcher<FilesChangesListener> eventDispatcher = EventDispatcher.create(FilesChangesListener.class);
        Intrinsics.checkExpressionValueIsNotNull(eventDispatcher, (String)"EventDispatcher.create(F\u2026ngesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.bulkUpdateOperation = new CompoundParallelOperationTrace("Bulk document update operation");
        this.bulkUpdateOperation.beforeOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                ((FilesChangesListener)eventDispatcher.getMulticaster()).init();
            }
        }));
        this.bulkUpdateOperation.afterOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                ((FilesChangesListener)eventDispatcher.getMulticaster()).apply();
            }
        }));
    }
}

