/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryData
extends AbstractNamedData
implements Named,
ProjectCoordinate {
    private static final Interner<String> ourPathInterner = new WeakInterner<String>();
    private final Map<LibraryPathType, Set<String>> paths;
    private final boolean unresolved;
    private String group;
    private String artifactId;
    private String version;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        if (owner == null) {
            LibraryData.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LibraryData.$$$reportNull$$$0(1);
        }
        this(owner, name, false);
    }

    @PropertyMapping(value={"owner", "externalName", "unresolved"})
    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String externalName, boolean unresolved) {
        if (owner == null) {
            LibraryData.$$$reportNull$$$0(2);
        }
        if (externalName == null) {
            LibraryData.$$$reportNull$$$0(3);
        }
        super(owner, externalName, externalName.isEmpty() ? "" : owner.getReadableName() + ": " + externalName);
        this.paths = new EnumMap<LibraryPathType, Set<String>>(LibraryPathType.class);
        this.unresolved = unresolved;
    }

    private LibraryData() {
        super(ProjectSystemId.IDE, "");
        this.paths = new EnumMap<LibraryPathType, Set<String>>(LibraryPathType.class);
        this.unresolved = false;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId2) {
        this.artifactId = artifactId2;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        Set<String> result2;
        if (type == null) {
            LibraryData.$$$reportNull$$$0(4);
        }
        Set<Object> set = (result2 = this.paths.get((Object)type)) == null ? Collections.emptySet() : result2;
        if (set == null) {
            LibraryData.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        Set<String> paths;
        if (type == null) {
            LibraryData.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            LibraryData.$$$reportNull$$$0(7);
        }
        if ((paths = this.paths.get((Object)type)) == null) {
            paths = new LinkedHashSet<String>();
            this.paths.put(type, paths);
        }
        paths.add(ourPathInterner.intern(ExternalSystemApiUtil.toCanonicalPath(path2)));
    }

    public void forgetAllPaths() {
        this.paths.clear();
    }

    @Override
    public int hashCode() {
        int result2 = this.paths.hashCode();
        result2 = 31 * result2 + super.hashCode();
        result2 = 31 * result2 + (this.unresolved ? 0 : 1);
        result2 = 31 * result2 + (this.group != null ? this.group.hashCode() : 0);
        result2 = 31 * result2 + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result2 = 31 * result2 + (this.version != null ? this.version.hashCode() : 0);
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return super.equals(that) && this.unresolved == that.unresolved && this.paths.equals(that.paths);
    }

    public String toString() {
        String externalName = this.getExternalName();
        String displayName = StringUtil.isEmpty(externalName) ? this.paths.toString() : externalName;
        return String.format("library %s%s", displayName, this.unresolved ? "(unresolved)" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/LibraryData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/LibraryData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

