/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectRenameAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalToolWindowManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import org.jetbrains.annotations.NotNull;

final class ExternalSystemStartupActivity
implements StartupActivity.DumbAware {
    ExternalSystemStartupActivity() {
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemStartupActivity.$$$reportNull$$$0(0);
        }
        ExternalProjectsManagerImpl.getInstance(project2).init();
        ApplicationManager.getApplication().invokeLater(() -> {
            boolean isNewlyCreatedProject;
            ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> {
                if (manager instanceof StartupActivity) {
                    ((StartupActivity)((Object)manager)).runActivity(project2);
                }
            });
            boolean isNewlyImportedProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
            boolean bl = isNewlyCreatedProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
            if (!isNewlyImportedProject && isNewlyCreatedProject) {
                ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, manager.getSystemId()).createDirectoriesForEmptyContentRoots()));
            }
            ExternalToolWindowManager.handle(project2);
            ProjectRenameAware.beAware(project2);
        }, project2.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ExternalSystemStartupActivity", "runActivity"));
    }
}

