/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DeprecatedMethodException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private final ConfigurationFactory @NotNull [] myFactories;
    @NotNull
    private final NotNullLazyValue<Icon> myIcon;

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(0);
        }
        this.myFactories = new ConfigurationFactory[1];
        this.myIcon = new NotNullLazyValue<Icon>(){

            @Override
            @NotNull
            protected Icon compute() {
                ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
                Icon result2 = null;
                if (manager instanceof ExternalSystemUiAware) {
                    result2 = ((ExternalSystemUiAware)((Object)manager)).getProjectIcon();
                }
                Icon icon2 = result2 == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result2;
                if (icon2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1", "compute"));
            }
        };
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @Override
            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExternalSystemRunConfiguration externalSystemRunConfiguration = AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project2, this, "");
                if (externalSystemRunConfiguration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return externalSystemRunConfiguration;
            }

            @Override
            @NotNull
            public String getId() {
                String string = AbstractExternalSystemTaskConfigurationType.this.getConfigurationFactoryId();
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTemplateConfiguration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTemplateConfiguration";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NonNls
    @NotNull
    protected String getConfigurationFactoryId() {
        DeprecatedMethodException.reportDefaultImplementation("AbstractExternalSystemTaskConfigurationType::getConfigurationFactoryId", "The default implementation delegates to 'ProjectSystemId::getReadableName' which is supposed to be localized but return value of this method must not be localized.", this.getClass());
        String string = this.myExternalSystemId.getReadableName();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(2);
        }
        return projectSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactories[0];
        if (configurationFactory == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(3);
        }
        return configurationFactory;
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(5);
        }
        if (factory == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(6);
        }
        if (name == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(7);
        }
        return new ExternalSystemRunConfiguration(externalSystemId, project2, factory, name);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myExternalSystemId.getReadableName();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message("run.configuration.description", this.myExternalSystemId.getReadableName());
    }

    @Override
    public Icon getIcon() {
        return this.myIcon.getValue();
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myExternalSystemId.getReadableName() + "RunConfiguration";
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(11);
        }
        return AbstractExternalSystemTaskConfigurationType.generateName(project2, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(12);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(13);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(14);
        }
        return AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, externalProjectPath, taskNames, executionName, " [", "]");
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName, @NotNull String tasksPrefix, @NotNull String tasksPostfix) {
        String projectName;
        ExternalProjectInfo projectInfo;
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(15);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(16);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(17);
        }
        if (tasksPrefix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(18);
        }
        if (tasksPostfix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(19);
        }
        if (!StringUtil.isEmpty(executionName)) {
            String string = executionName;
            if (string == null) {
                AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(20);
            }
            return string;
        }
        boolean isTasksAbsent = taskNames.isEmpty();
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project2, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
        } else if (!StringUtil.isEmptyOrSpaces(externalProjectPath)) {
            buffer.append(externalProjectPath);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPrefix);
        }
        if (!StringUtil.isEmpty(executionName)) {
            buffer.append(executionName);
        } else if (!isTasksAbsent) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPostfix);
        }
        if (buffer.length() == 0) {
            buffer.append(ExecutionBundle.message("run.configuration.unnamed.name.prefix", new Object[0]));
        }
        String string = buffer.toString();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPrefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPostfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactoryId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConfiguration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

