/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.DefaultOutputMessageDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputDispatcherFactory;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputMessageDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.util.SmartList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher;", "Lcom/intellij/build/BuildEventDispatcher;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "progressListener", "Lcom/intellij/build/BuildProgressListener;", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/build/BuildProgressListener;)V", "appendOutputToMainConsole", "", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/build/BuildProgressListener;Z)V", "isStdOut", "outputMessageDispatcher", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemOutputMessageDispatcher;", "append", "c", "", "csq", "", "start", "", "end", "close", "", "invokeOnCompletion", "consumer", "Ljava/util/function/Consumer;", "", "onEvent", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "setStdOut", "stdOut", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public final class ExternalSystemEventDispatcher
implements BuildEventDispatcher {
    private ExternalSystemOutputMessageDispatcher outputMessageDispatcher;
    private boolean isStdOut;
    private static final ExtensionPointName<ExternalSystemOutputDispatcherFactory> EP_NAME;
    public static final Companion Companion;

    @Override
    public void setStdOut(boolean stdOut) {
        this.isStdOut = stdOut;
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.setStdOut(stdOut);
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.onEvent(buildId, event);
    }

    @Override
    public void invokeOnCompletion(@NotNull Consumer<Throwable> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.invokeOnCompletion(consumer);
    }

    @Override
    @Nullable
    public BuildEventDispatcher append(@NotNull CharSequence csq) {
        Intrinsics.checkParameterIsNotNull((Object)csq, (String)"csq");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.append(csq);
        return this;
    }

    @Override
    @Nullable
    public BuildEventDispatcher append(@NotNull CharSequence csq, int start2, int end) {
        Intrinsics.checkParameterIsNotNull((Object)csq, (String)"csq");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.append(csq, start2, end);
        return this;
    }

    @Override
    @Nullable
    public BuildEventDispatcher append(char c) {
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.append(c);
        return this;
    }

    @Override
    public void close() {
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
        }
        externalSystemOutputMessageDispatcher.close();
    }

    public ExternalSystemEventDispatcher(@NotNull ExternalSystemTaskId taskId, @Nullable BuildProgressListener progressListener, boolean appendOutputToMainConsole) {
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        this.isStdOut = true;
        SmartList buildOutputParsers = new SmartList();
        if (progressListener != null) {
            int n;
            ExtensionPointName<ExternalSystemOutputParserProvider> extensionPointName = ExternalSystemOutputParserProvider.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ExternalSystemOutputParserProvider.EP_NAME");
            ExternalSystemOutputParserProvider[] externalSystemOutputParserProviderArray = extensionPointName.getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemOutputParserProviderArray, (String)"ExternalSystemOutputPars\u2026ovider.EP_NAME.extensions");
            ExternalSystemOutputParserProvider[] $this$forEach$iv = externalSystemOutputParserProviderArray;
            boolean $i$f$forEach = false;
            ExternalSystemOutputParserProvider[] externalSystemOutputParserProviderArray2 = $this$forEach$iv;
            int n2 = externalSystemOutputParserProviderArray2.length;
            for (n = 0; n < n2; ++n) {
                ExternalSystemOutputParserProvider element$iv;
                ExternalSystemOutputParserProvider it = element$iv = externalSystemOutputParserProviderArray2[n];
                boolean bl = false;
                ProjectSystemId projectSystemId = taskId.getProjectSystemId();
                ExternalSystemOutputParserProvider externalSystemOutputParserProvider = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemOutputParserProvider, (String)"it");
                if (!Intrinsics.areEqual((Object)projectSystemId, (Object)externalSystemOutputParserProvider.getExternalSystemId())) continue;
                buildOutputParsers.addAll(it.getBuildOutputParsers(taskId));
            }
            ExternalSystemOutputDispatcherFactory foundFactory = null;
            ExternalSystemOutputDispatcherFactory[] externalSystemOutputDispatcherFactoryArray = EP_NAME.getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemOutputDispatcherFactoryArray, (String)"EP_NAME.extensions");
            ExternalSystemOutputDispatcherFactory[] $this$forEach$iv2 = externalSystemOutputDispatcherFactoryArray;
            boolean $i$f$forEach2 = false;
            ExternalSystemOutputDispatcherFactory[] externalSystemOutputDispatcherFactoryArray2 = $this$forEach$iv2;
            n = externalSystemOutputDispatcherFactoryArray2.length;
            for (int i = 0; i < n; ++i) {
                ExternalSystemOutputDispatcherFactory element$iv;
                ExternalSystemOutputDispatcherFactory it = element$iv = externalSystemOutputDispatcherFactoryArray2[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)taskId.getProjectSystemId(), (Object)it.getExternalSystemId())) continue;
                if (foundFactory != null) {
                    throw (Throwable)new RuntimeException("'" + EP_NAME.getName() + "' extension should be one per external system");
                }
                foundFactory = it;
            }
            Object object = foundFactory;
            if (object == null || (object = object.create(taskId, progressListener, appendOutputToMainConsole, buildOutputParsers)) == null) {
                object = new DefaultOutputMessageDispatcher(taskId, progressListener, buildOutputParsers);
            }
            this.outputMessageDispatcher = object;
        }
    }

    public ExternalSystemEventDispatcher(@NotNull ExternalSystemTaskId taskId, @Nullable BuildProgressListener progressListener) {
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        this(taskId, progressListener, true);
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create("com.intellij.externalSystemOutputDispatcher");
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ExtensionPointName.creat\u2026lSystemOutputDispatcher\")");
        EP_NAME = extensionPointName;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemOutputDispatcherFactory;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

