/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessHandler
extends BuildProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProcessHandler.class);
    private final String myExecutionName;
    @Nullable
    private ExternalSystemTask myTask;
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    @Nullable
    private OutputStream myProcessInput;

    public ExternalSystemProcessHandler(@NotNull ExternalSystemTask task2, String executionName) {
        if (task2 == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(0);
        }
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myTask = task2;
        this.myExecutionName = executionName;
        if (task2 instanceof UserDataHolder) {
            try {
                Pipe pipe = Pipe.open();
                BufferedInputStream inputStream = new BufferedInputStream(Channels.newInputStream(pipe.source()));
                this.myProcessInput = new BufferedOutputStream(Channels.newOutputStream(pipe.sink()));
                ((UserDataHolder)((Object)task2)).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, inputStream);
            }
            catch (IOException e) {
                LOG.warn("Unable to setup process input", e);
            }
        }
    }

    @Override
    public String getExecutionName() {
        return this.myExecutionName;
    }

    @Override
    public void notifyTextAvailable(@NotNull String text2, @NotNull Key outputType) {
        if (text2 == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(2);
        }
        this.myAnsiEscapeDecoder.escapeText(text2, outputType, this);
    }

    @Override
    protected void destroyProcessImpl() {
        ExternalSystemTask task2 = this.myTask;
        if (task2 != null) {
            task2.cancel(new ExternalSystemTaskNotificationListener[0]);
        }
        this.closeInput();
    }

    @Override
    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.closeInput();
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInput;
    }

    @Override
    public void notifyProcessTerminated(int exitCode) {
        super.notifyProcessTerminated(exitCode);
        this.closeInput();
    }

    @Override
    public void coloredTextAvailable(@NotNull String text2, @NotNull Key attributes) {
        if (text2 == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(4);
        }
        super.notifyTextAvailable(text2, attributes);
    }

    protected void closeInput() {
        StreamUtil.closeStream(this.myProcessInput);
        this.myProcessInput = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ExternalSystemTask task2 = this.myTask;
            if (task2 instanceof UserDataHolder) {
                UserDataHolder taskDataHolder = (UserDataHolder)((Object)task2);
                InputStream inputStream = taskDataHolder.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
                StreamUtil.closeStream(inputStream);
                taskDataHolder.putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
            }
            this.detachProcessImpl();
        }
        finally {
            this.myTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyTextAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

