/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject;
    @NotNull
    private final String myProjectPath;
    private final boolean myIsPreviewMode;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private final String myArguments;
    @Nullable
    private final ProjectResolverPolicy myResolverPolicy;

    public ExternalSystemResolveProjectTask(@NotNull Project project2, @NotNull String projectPath, @NotNull ImportSpec importSpec) {
        if (project2 == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(1);
        }
        if (importSpec == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(2);
        }
        super(importSpec.getExternalSystemId(), ExternalSystemTaskType.RESOLVE_PROJECT, project2, projectPath);
        this.myExternalProject = new AtomicReference();
        this.myProjectPath = projectPath;
        this.myIsPreviewMode = importSpec.isPreviewMode();
        this.myVmOptions = importSpec.getVmOptions();
        this.myArguments = importSpec.getArguments();
        this.myResolverPolicy = importSpec instanceof ImportSpecImpl ? ((ImportSpecImpl)importSpec).getProjectResolverPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        Object settings;
        RemoteExternalSystemProjectResolver resolver;
        Project ideProject;
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id2 = this.getId();
        try {
            progressNotificationManager.onStart(id2, this.myProjectPath);
            ideProject = this.getIdeProject();
            ExternalSystemTaskNotificationListener progressNotificationListener = ExternalSystemResolveProjectTask.wrapWithListener(progressNotificationManager);
            for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(this.getExternalSystemId())) {
                executionAware.prepareExecution(id2, this.myProjectPath, this.myIsPreviewMode, progressNotificationListener, ideProject);
            }
            ExternalSystemFacadeManager manager = ServiceManager.getService(ExternalSystemFacadeManager.class);
            resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
            settings = ExternalSystemApiUtil.getExecutionSettings(ideProject, this.myProjectPath, this.getExternalSystemId());
            if (StringUtil.isNotEmpty(this.myVmOptions)) {
                ((ExternalSystemExecutionSettings)settings).withVmOptions(ParametersListUtil.parse(this.myVmOptions));
            }
            if (StringUtil.isNotEmpty(this.myArguments)) {
                ((ExternalSystemExecutionSettings)settings).withArguments(ParametersListUtil.parse(this.myArguments));
            }
        }
        catch (Exception e) {
            progressNotificationManager.onFailure(id2, e);
            progressNotificationManager.onEnd(id2);
            throw e;
        }
        try {
            DataNode<ProjectData> project2 = resolver.resolveProjectInfo(id2, this.myProjectPath, this.myIsPreviewMode, settings, this.myResolverPolicy);
            if (project2 != null) {
                this.myExternalProject.set(project2);
                ExternalSystemManager<?, ?, ?, ?, ?> systemManager = ExternalSystemApiUtil.getManager(this.getExternalSystemId());
                assert (systemManager != null);
                HashSet<String> externalModulePaths = new HashSet<String>();
                Collection<DataNode<ModuleData>> moduleNodes = ExternalSystemApiUtil.findAll(project2, ProjectKeys.MODULE);
                for (DataNode<ModuleData> node : moduleNodes) {
                    externalModulePaths.add(node.getData().getLinkedExternalProjectPath());
                }
                String projectPath = project2.getData().getLinkedExternalProjectPath();
                Object linkedProjectSettings = ((AbstractExternalSystemSettings)systemManager.getSettingsProvider().fun(ideProject)).getLinkedProjectSettings(projectPath);
                if (linkedProjectSettings != null && !externalModulePaths.isEmpty()) {
                    ((ExternalProjectSettings)linkedProjectSettings).setModules(externalModulePaths);
                }
            }
            progressNotificationManager.onSuccess(id2);
        }
        finally {
            progressNotificationManager.onEnd(id2);
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text2) {
        if (text2 == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(3);
        }
        String string = ExternalSystemBundle.message("progress.update.text", this.getExternalSystemId().getReadableName(), text2);
        if (string == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(5);
        }
        super.setState(state);
        if (state.isStopped() && (this.myResolverPolicy == null || !this.myResolverPolicy.isPartialDataResolveAllowed())) {
            InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), this.myExternalProject.getAndSet(null));
            long currentTimeMillis = System.currentTimeMillis();
            projectInfo.setLastImportTimestamp(currentTimeMillis);
            projectInfo.setLastSuccessfulImportTimestamp(state == ExternalSystemTaskState.FAILED ? -1L : currentTimeMillis);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), projectInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

