/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableModel;
import com.intellij.openapi.externalSystem.service.project.ModifiableWorkspace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private final Map<Module, ModifiableRootModel> myModifiableRootModels;
    private final Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private final Map<Module, String> myProductionModulesForTestModules;
    private final Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private final ClassMap<ModifiableModel> myModifiableModels;
    @Nullable
    private ModifiableWorkspace myModifiableWorkspace;
    private final MyUserDataHolderBase myUserData;
    private volatile boolean myDisposed;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project2) {
        if (project2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myModifiableRootModels = new THashMap<Module, ModifiableRootModel>();
        this.myModifiableFacetModels = new THashMap<Module, ModifiableFacetModel>();
        this.myProductionModulesForTestModules = new THashMap<Module, String>();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myModifiableModels = new ClassMap();
        this.myUserData = new MyUserDataHolderBase();
        EP_NAME.forEachExtensionSafe(extension -> {
            Pair pair = extension.create(project2, this);
            this.myModifiableModels.put((Class)pair.first, (ModifiableModel)pair.second);
        });
    }

    @Override
    @Nullable
    public <T extends ModifiableModel> T findModifiableModel(@NotNull Class<T> instanceOf) {
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(1);
        }
        return (T)((ModifiableModel)ObjectUtils.tryCast(this.myModifiableModels.get(instanceOf), instanceOf));
    }

    @Override
    @NotNull
    public <T extends ModifiableModel> T getModifiableModel(@NotNull Class<T> instanceOf) {
        ModifiableModel model;
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(2);
        }
        if (instanceOf.isInstance(model = this.myModifiableModels.get(instanceOf))) {
            ModifiableModel modifiableModel = (ModifiableModel)instanceOf.cast(model);
            if (modifiableModel == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(3);
            }
            return (T)modifiableModel;
        }
        throw new AssertionError((Object)String.format("Unable to get `%s` model", instanceOf.getSimpleName()));
    }

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @Override
    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    public Module @NotNull [] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    @Override
    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(5);
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module2).getOrderEntries();
        if (orderEntryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(6);
        }
        return orderEntryArray;
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath2, String moduleTypeId) {
        if (filePath2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(7);
        }
        Module module2 = this.getModifiableModuleModel().newModule(filePath2, moduleTypeId);
        String moduleName = FileUtilRt.getNameWithoutExtension(new File(filePath2).getName());
        if (!module2.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module2, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn(exists);
            }
        }
        module2.setModuleType(moduleTypeId);
        Module module3 = module2;
        if (module3 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(8);
        }
        return module3;
    }

    @Override
    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(9);
        }
        String imlName = null;
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module2 = this.findIdeModule(candidate);
            if (module2 != null) continue;
            imlName = candidate;
            break;
        }
        assert (imlName != null) : "Too many duplicated module names";
        String filePath2 = ExternalSystemApiUtil.toCanonicalPath(moduleData.getModuleFileDirectoryPath() + "/" + imlName + ".iml");
        Module module3 = this.newModule(filePath2, moduleData.getModuleTypeId());
        if (module3 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(10);
        }
        return module3;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module2;
        if (ideModuleName == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(11);
        }
        return (module2 = this.getModifiableModuleModel().findModuleByName(ideModuleName)) == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module2;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(12);
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated(ideLibrary, libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    public VirtualFile @NotNull [] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getContentRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(13);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(14);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module2, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(16);
        }
        return modifiableModuleModel;
    }

    @Override
    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module2) {
        return (ModifiableRootModel)this.getRootModel(module2);
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module2) {
        ModuleRootModel moduleRootModel = this.myModifiableRootModels.computeIfAbsent(module2, k -> this.doGetModifiableRootModel(module2));
        if (moduleRootModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(17);
        }
        return moduleRootModel;
    }

    @Override
    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module2) {
        ModifiableFacetModel modifiableFacetModel = this.myModifiableFacetModels.computeIfAbsent(module2, k -> this.doGetModifiableFacetModel(module2));
        if (modifiableFacetModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(18);
        }
        return modifiableFacetModel;
    }

    @Override
    public Library @NotNull [] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(19);
        }
        return libraryArray;
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    @Override
    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    @Override
    public Library createLibrary(String name, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name, null, externalSource);
    }

    @Override
    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    @Override
    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Nullable
    public ModifiableWorkspace getModifiableWorkspace() {
        if (this.myModifiableWorkspace == null && ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
            this.myModifiableWorkspace = this.doGetModifiableWorkspace();
        }
        return this.myModifiableWorkspace;
    }

    @Override
    public String @NotNull [] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model;
        if (library == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(20);
        }
        if (type == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(21);
        }
        if ((model = this.myModifiableLibraryModels.get(library)) != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(22);
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    @Override
    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(24);
        }
        ArrayList<Module> list2 = new ArrayList<Module>();
        Graph<Module> graph2 = this.getModuleGraph();
        Iterator<Module> i = graph2.getOut(module2);
        while (i.hasNext()) {
            list2.add(i.next());
        }
        ArrayList<Module> arrayList = list2;
        if (arrayList == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private ModifiableWorkspace doGetModifiableWorkspace() {
        return ReadAction.compute(() -> ServiceManager.getService(this.myProject, ExternalProjectsWorkspaceImpl.class).createModifiableWorkspace(this));
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Module>(){

            @Override
            @NotNull
            public Collection<Module> getNodes() {
                List<Module> list2 = Arrays.asList(AbstractIdeModifiableModelsProvider.this.getModules());
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                Iterator<Module> iterator2 = Arrays.asList(dependentModules).iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    @Override
    public void commit() {
        ProjectRootManagerEx.getInstanceEx(this.myProject).mergeRootsChangesDuring(() -> {
            if (ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
                this.updateSubstitutions();
            }
            for (Map.Entry<Library, Library.ModifiableModel> entry : this.myModifiableLibraryModels.entrySet()) {
                Library fromLibrary = entry.getKey();
                Library.ModifiableModel modifiableModel = entry.getValue();
                if (fromLibrary instanceof LibraryEx && ((LibraryEx)fromLibrary).isDisposed()) {
                    Disposer.dispose(modifiableModel);
                    continue;
                }
                modifiableModel.commit();
            }
            this.getModifiableProjectLibrariesModel().commit();
            Collection<ModifiableRootModel> rootModels = this.myModifiableRootModels.values();
            ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[0]);
            for (ModifiableRootModel modifiableRootModel : rootModels1) {
                assert (!modifiableRootModel.isDisposed()) : "Already disposed: " + modifiableRootModel;
            }
            if (this.myModifiableModuleModel != null) {
                ModifiableModelCommitter.multiCommit(rootModels1, this.myModifiableModuleModel);
            } else {
                for (ModifiableRootModel modifiableRootModel : rootModels1) {
                    modifiableRootModel.commit();
                }
            }
            for (Map.Entry entry : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)entry.getKey()).setProductionModuleName((String)entry.getValue());
            }
            for (Map.Entry entry : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry.getKey()).isDisposed()) continue;
                ((ModifiableFacetModel)entry.getValue()).commit();
            }
            this.myModifiableModels.values().forEach(ModifiableModel::commit);
        });
        this.myUserData.clear();
    }

    @Override
    public void dispose() {
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (!this.myDisposed) : "Already disposed!";
        this.myDisposed = true;
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose(this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)((Object)modifiableModel)).isDisposed()) continue;
            Disposer.dispose(modifiableModel);
        }
        if (this.myModifiableModuleModel != null && this.myModifiableModuleModel.isChanged()) {
            this.myModifiableModuleModel.dispose();
        }
        this.myModifiableModels.values().forEach(ModifiableModel::dispose);
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    @Override
    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Override
    @Nullable
    public String getProductionModuleName(Module module2) {
        return this.myProductionModulesForTestModules.get(module2);
    }

    @Override
    public ModuleOrderEntry trySubstitute(Module ownerModule, LibraryOrderEntry libraryOrderEntry, ProjectCoordinate publicationId) {
        Module workspaceModule;
        String workspaceModuleCandidate = this.findModuleByPublication(publicationId);
        Module module2 = workspaceModule = workspaceModuleCandidate == null ? null : this.findIdeModule(workspaceModuleCandidate);
        if (workspaceModule == null) {
            return null;
        }
        ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(ownerModule);
        ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(workspaceModule);
        moduleOrderEntry.setScope(libraryOrderEntry.getScope());
        moduleOrderEntry.setExported(libraryOrderEntry.isExported());
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        assert (workspace != null);
        workspace.addSubstitution(ownerModule.getName(), workspaceModule.getName(), libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
        modifiableRootModel.removeOrderEntry(libraryOrderEntry);
        return moduleOrderEntry;
    }

    @Override
    public void registerModulePublication(Module module2, ProjectCoordinate modulePublication) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace != null) {
            workspace.register(modulePublication, module2);
        }
    }

    @Override
    public boolean isSubstituted(String libraryName) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.isSubstituted(libraryName);
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(26);
        }
        return this.myUserData.getUserData(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(27);
        }
        this.myUserData.putUserData(key, value2);
    }

    @Override
    @Nullable
    public String findModuleByPublication(ProjectCoordinate publicationId) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        return workspace == null ? null : workspace.findModule(publicationId);
    }

    private void updateSubstitutions() {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return;
        }
        List<String> oldModules = ContainerUtil.map(ModuleManager.getInstance(this.myProject).getModules(), module2 -> module2.getName());
        List<String> newModules = ContainerUtil.map(this.myModifiableModuleModel.getModules(), module2 -> module2.getName());
        THashSet<String> removedModules = new THashSet<String>(oldModules);
        removedModules.removeAll(newModules);
        HashMap<String, String> toSubstitute = new HashMap<String, String>();
        ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemManager.EP_NAME.getIterable()) {
            Collection<ExternalProjectInfo> projectsData = projectDataManager.getExternalProjectsData(this.myProject, manager.getSystemId());
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null) continue;
                Collection<DataNode<LibraryData>> libraryNodes = ExternalSystemApiUtil.findAll(projectInfo.getExternalProjectStructure(), ProjectKeys.LIBRARY);
                for (DataNode<LibraryData> libraryNode : libraryNodes) {
                    String substitutionModuleCandidate = this.findModuleByPublication(libraryNode.getData());
                    if (substitutionModuleCandidate == null) continue;
                    toSubstitute.put(libraryNode.getData().getInternalName(), substitutionModuleCandidate);
                }
            }
        }
        for (Module module3 : this.getModules()) {
            ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(module3);
            boolean changed2 = false;
            OrderEntry[] entries = modifiableRootModel.getOrderEntries();
            int length = entries.length;
            for (int i = 0; i < length; ++i) {
                Module ideModule;
                String workspaceModule;
                LibraryOrderEntry libraryOrderEntry;
                String workspaceModule2;
                OrderEntry orderEntry = entries[i];
                if (orderEntry instanceof ModuleOrderEntry && removedModules.contains(workspaceModule2 = ((ModuleOrderEntry)orderEntry).getModuleName())) {
                    Library library;
                    String libraryName;
                    DependencyScope scope = ((ModuleOrderEntry)orderEntry).getScope();
                    if (workspace.isSubstitution(module3.getName(), workspaceModule2, scope) && (libraryName = workspace.getSubstitutedLibrary(workspaceModule2)) != null && (library = this.getLibraryByName(libraryName)) != null) {
                        modifiableRootModel.removeOrderEntry(orderEntry);
                        entries[i] = modifiableRootModel.addLibraryEntry(library);
                        changed2 = true;
                        workspace.removeSubstitution(module3.getName(), workspaceModule2, libraryName, scope);
                    }
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || libraryOrderEntry.getLibraryName() == null || (workspaceModule = (String)toSubstitute.get(libraryOrderEntry.getLibraryName())) == null || (ideModule = this.findIdeModule(workspaceModule)) == null) continue;
                ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(ideModule);
                moduleOrderEntry.setScope(libraryOrderEntry.getScope());
                modifiableRootModel.removeOrderEntry(orderEntry);
                entries[i] = moduleOrderEntry;
                changed2 = true;
                workspace.addSubstitution(module3.getName(), workspaceModule, libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
            }
            if (!changed2) continue;
            modifiableRootModel.rearrangeOrderEntries(entries);
        }
        workspace.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModuleModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableFacetModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModifiableModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModel";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUserDataHolderBase
    extends UserDataHolderBase {
        private MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

