/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public IdeModifiableModelsProviderImpl(Project project2) {
        super(project2);
        this.myLibrariesModel = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getModifiableModel();
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        LibraryTable.ModifiableModel modifiableModel = this.myLibrariesModel;
        if (modifiableModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(0);
        }
        return modifiableModel;
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return ReadAction.compute(() -> ModuleManager.getInstance(this.myProject).getModifiableModel());
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module2) {
        if (module2 == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(1);
        }
        ModifiableRootModel modifiableRootModel = ReadAction.compute(() -> ModuleRootManagerEx.getInstanceEx(module2).getModifiableModel(new RootConfigurationAccessor(){

            @Override
            @Nullable
            public Library getLibrary(Library library, String libraryName, String libraryLevel) {
                if ("project".equals(libraryLevel)) {
                    return IdeModifiableModelsProviderImpl.this.myLibrariesModel.getLibraryByName(libraryName);
                }
                return library;
            }
        }));
        if (modifiableRootModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(2);
        }
        return modifiableRootModel;
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module2) {
        return FacetManager.getInstance(module2).createModifiableModel();
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return library.getModifiableModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableProjectLibrariesModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetModifiableRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGetModifiableRootModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

