/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.zip.CRC32;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.1")
public class ConfigurationFileCrcFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.externalSystem.autoimport");
    private final VirtualFile myFile;

    @Deprecated
    public ConfigurationFileCrcFactory(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(1);
        }
        this(file2);
    }

    public ConfigurationFileCrcFactory(VirtualFile file2) {
        this.myFile = file2;
    }

    public long create() {
        if (this.myFile.isDirectory()) {
            ConfigurationFileCrcFactory.debug("Cannot calculate CRC for directory '" + this.myFile.getPath() + "'");
            return this.myFile.getModificationStamp();
        }
        WordsScanner wordsScanner = ConfigurationFileCrcFactory.getScanner(this.myFile);
        if (wordsScanner == null) {
            ConfigurationFileCrcFactory.debug("WordsScanner not found for file '" + this.myFile.getPath() + "'");
            return this.myFile.getModificationStamp();
        }
        CRC32 crc32 = new CRC32();
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        CharSequence text2 = document != null ? document.getImmutableCharSequence() : LoadTextUtil.loadText(this.myFile);
        wordsScanner.processWords(text2, occurrence -> {
            if (occurrence.getKind() != WordOccurrence.Kind.COMMENTS) {
                CharSequence currentWord = occurrence.getBaseText().subSequence(occurrence.getStart(), occurrence.getEnd());
                int end = currentWord.length();
                for (int i = 0; i < end; ++i) {
                    crc32.update(currentWord.charAt(i));
                }
            }
            return true;
        });
        return crc32.getValue();
    }

    @Nullable
    private static WordsScanner getScanner(VirtualFile file2) {
        FileType fileType = file2.getFileType();
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return customWordsScanner;
        }
        if (fileType instanceof LanguageFileType) {
            Language lang2 = ((LanguageFileType)fileType).getLanguage();
            return LanguageFindUsages.getWordsScanner(lang2);
        }
        return null;
    }

    private static void debug(@NotNull String message) {
        if (message == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ConfigurationFileCrcFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "debug";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

