/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemProjectsWatcherImpl
implements ExternalSystemProjectsWatcher {
    private final Project project;
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create("com.intellij.externalProjectWatcherContributor");

    public ExternalSystemProjectsWatcherImpl(Project project2) {
        this.project = project2;
    }

    @Override
    public void markDirtyAllExternalProjects() {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance(this.project);
        this.findAllProjectSettings().forEach(it -> projectTracker.markDirty((ExternalSystemProjectId)it));
        for (Contributor contributor : EP_NAME.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.project);
        }
        projectTracker.scheduleProjectRefresh();
    }

    @Override
    public void markDirty(Module module2) {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance(this.project);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath(module2);
        this.findAllProjectSettings().stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty((ExternalSystemProjectId)it));
        for (Contributor contributor : EP_NAME.getExtensions()) {
            contributor.markDirty(module2);
        }
        projectTracker.scheduleProjectRefresh();
    }

    @Override
    public void markDirty(String projectPath) {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance(this.project);
        this.findAllProjectSettings().stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty((ExternalSystemProjectId)it));
        for (Contributor contributor : EP_NAME.getExtensions()) {
            contributor.markDirty(projectPath);
        }
        projectTracker.scheduleProjectRefresh();
    }

    private List<ExternalSystemProjectId> findAllProjectSettings() {
        ArrayList<ExternalSystemProjectId> list2 = new ArrayList<ExternalSystemProjectId>();
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> {
            ProjectSystemId systemId = manager.getSystemId();
            Collection linkedProjectsSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun(this.project)).getLinkedProjectsSettings();
            for (ExternalProjectSettings settings : linkedProjectsSettings) {
                String externalProjectPath = settings.getExternalProjectPath();
                if (externalProjectPath == null) continue;
                list2.add(new ExternalSystemProjectId(systemId, externalProjectPath));
            }
        });
        return list2;
    }

    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);

        default public void markDirty(@NotNull String projectPath) {
            if (projectPath == null) {
                Contributor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$Contributor", "markDirty"));
        }
    }
}

