/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileChangeListenerBase
implements BulkFileListener {
    protected abstract boolean isRelevant(String var1);

    protected abstract void updateFile(VirtualFile var1, VFileEvent var2);

    protected abstract void deleteFile(VirtualFile var1, VFileEvent var2);

    protected abstract void apply();

    @Override
    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            FileChangeListenerBase.$$$reportNull$$$0(0);
        }
        for (VFileEvent vFileEvent : events) {
            VFileMoveEvent moveEvent;
            String newPath;
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.deleteRecursively(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!this.isRelevant(vFileEvent.getPath())) continue;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                if (!FileChangeListenerBase.isRenamed(vFileEvent)) continue;
                this.deleteRecursively(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) || this.isRelevant(newPath = (moveEvent = (VFileMoveEvent)vFileEvent).getNewParent().getPath() + "/" + moveEvent.getFile().getName())) continue;
            this.deleteRecursively(moveEvent.getFile(), vFileEvent);
        }
    }

    private void deleteRecursively(VirtualFile f, final VFileEvent event) {
        VfsUtilCore.visitChildrenRecursively(f, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FileChangeListenerBase.this.isRelevant(f.getPath())) {
                    FileChangeListenerBase.this.deleteFile(f, event);
                }
                return true;
            }

            @Override
            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(1);
                }
                return f.isDirectory() && f instanceof NewVirtualFile ? ((NewVirtualFile)f).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "f";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/FileChangeListenerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            FileChangeListenerBase.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile newChild;
            if (!this.isRelevant(vFileEvent.getPath())) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                newChild = createEvent.getParent().findChild(createEvent.getChildName());
                if (newChild == null) continue;
                this.updateFile(newChild, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                newChild = copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
                if (newChild == null) continue;
                this.updateFile(newChild, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                if (!FileChangeListenerBase.isRenamed(vFileEvent)) continue;
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.updateFile(vFileEvent.getFile(), vFileEvent);
        }
        this.apply();
    }

    private static boolean isRenamed(VFileEvent each) {
        return ((VFilePropertyChangeEvent)each).getPropertyName().equals("name") && !Comparing.equal(((VFilePropertyChangeEvent)each).getOldValue(), ((VFilePropertyChangeEvent)each).getNewValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "events";
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/FileChangeListenerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

