/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ModuleDataServiceExtension;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create("MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create("LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create("ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> ORPHAN_MODULE_FILES = Key.create("ORPHAN_FILES");
    private static final Key<AtomicInteger> ORPHAN_MODULE_HANDLERS_COUNTER = Key.create("ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final NotificationGroup ORPHAN_MODULE_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup("Build sync orphan modules", "Build");
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);
    private static final ExtensionPointName<ModuleDataServiceExtension> EP_NAME = ExtensionPointName.create("com.intellij.externalSystem.moduleDataServiceExtension");

    @Override
    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module2;
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(2);
        }
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider);
        }
        for (DataNode node : toImport) {
            module2 = node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            ProjectCoordinate publication = ((ModuleData)node.getData()).getPublication();
            if (publication != null) {
                modelsProvider.registerModulePublication(module2, publication);
            }
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module2, productionModuleId);
            this.setModuleOptions(module2, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
            AbstractModuleDataService.syncPaths(module2, modifiableRootModel, (ModuleData)node.getData());
            EP_NAME.forEachExtensionSafe(extension -> extension.importModule(modelsProvider, module2, (ModuleData)node.getData()));
            this.importModuleSdk(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode node : toImport) {
            module2 = node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String[] groupPath2 = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module2, groupPath2);
        }
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<E> module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(4);
        }
        ModuleData data2 = (ModuleData)module2.getData();
        Module module3 = modelsProvider.newModule(data2);
        if (module3 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(5);
        }
        return module3;
    }

    private void createModules(@NotNull Collection<? extends DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toCreate == null) {
            AbstractModuleDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(7);
        }
        for (DataNode<E> module2 : toCreate) {
            Module created = this.createModule(module2, modelsProvider);
            module2.putUserData(MODULE_KEY, created);
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                @Override
                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object value2) {
                    if (libraryOrderEntry == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    modifiableRootModel.removeOrderEntry(libraryOrderEntry);
                    return value2;
                }

                @Override
                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object value2) {
                    if (moduleOrderEntry == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    modifiableRootModel.removeOrderEntry(moduleOrderEntry);
                    return value2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "libraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "moduleOrderEntry";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLibraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitModuleOrderEntry";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept(visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<? extends DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(9);
        }
        ArrayList<DataNode<DataNode<E>>> result2 = new ArrayList<DataNode<DataNode<E>>>();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module2 = modelsProvider.findIdeModule(moduleData);
            if (module2 == null) {
                UnloadedModuleDescription unloadedModuleDescription = modelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription == null) {
                    result2.add(node);
                }
                this.markExistedModulesWithSameRoot(node, modelsProvider);
                continue;
            }
            node.putUserData(MODULE_KEY, module2);
        }
        ArrayList<DataNode<DataNode<E>>> arrayList = result2;
        if (arrayList == null) {
            AbstractModuleDataService.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private void markExistedModulesWithSameRoot(DataNode<E> node, IdeModifiableModelsProvider modelsProvider) {
        ModuleData moduleData = (ModuleData)node.getData();
        ProjectSystemId projectSystemId = moduleData.getOwner();
        Arrays.stream(modelsProvider.getModules()).filter(ideModule -> AbstractModuleDataService.isModulePointsSameRoot(moduleData, ideModule)).filter(module2 -> !ExternalSystemApiUtil.isExternalSystemAwareModule(projectSystemId, module2)).forEach(module2 -> ExternalSystemModulePropertyManager.getInstance(module2).setExternalOptions(projectSystemId, moduleData, node.getData(ProjectKeys.PROJECT)));
    }

    private static boolean isModulePointsSameRoot(ModuleData moduleData, Module ideModule) {
        for (VirtualFile root : ModuleRootManager.getInstance(ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual(root.getPath(), moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return false;
    }

    private static void syncPaths(@NotNull Module module2, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data2) {
        CompilerModuleExtension extension;
        if (module2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(11);
        }
        if (modifiableModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(12);
        }
        if (data2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(13);
        }
        if ((extension = modifiableModel.getModuleExtension(CompilerModuleExtension.class)) == null) {
            LOG.debug(String.format("No compiler extension is found for '%s', compiler output path will not be synced.", module2.getName()));
            return;
        }
        String compileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl(compileOutputPath) : null);
        String testCompileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl(testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data2.isInheritProjectCompileOutputPath());
    }

    @Override
    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemoveComputable == null) {
            AbstractModuleDataService.$$$reportNull$$$0(14);
        }
        if (toIgnore == null) {
            AbstractModuleDataService.$$$reportNull$$$0(15);
        }
        if (projectData2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(17);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(18);
        }
        Collection<Module> toRemove2 = toRemoveComputable.compute();
        SmartList<Module> modules = new SmartList<Module>(toRemove2);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull(modules, module2);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates(modules);
        for (Module module3 : modules) {
            if (module3.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module3);
        }
        ExternalSystemApiUtil.executeOnEdt(true, () -> {
            AtomicInteger counter = project2.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
            if (counter == null) {
                counter = new AtomicInteger();
                project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, counter);
            }
            counter.incrementAndGet();
            Set<Path> orphanModules = project2.getUserData(ORPHAN_MODULE_FILES);
            if (orphanModules == null) {
                orphanModules = new LinkedHashSet<Path>();
                project2.putUserData(ORPHAN_MODULE_FILES, orphanModules);
            }
            LocalHistoryAction historyAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message("local.history.remove.orphan.modules", new Object[0]));
            try {
                String rootProjectPathKey = String.valueOf(projectData2.getLinkedExternalProjectPath().hashCode());
                Path unlinkedModulesDir = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve("orphanModules").resolve(rootProjectPathKey);
                if (!FileUtil.createDirectory(unlinkedModulesDir.toFile())) {
                    LOG.warn("Unable to create " + unlinkedModulesDir);
                    return;
                }
                Object localSettings = ExternalSystemApiUtil.getLocalSettings(project2, projectData2.getOwner());
                AbstractExternalSystemLocalSettings.SyncType syncType = ((AbstractExternalSystemLocalSettings)localSettings).getProjectSyncType().get(projectData2.getLinkedExternalProjectPath());
                for (Module module2 : modules) {
                    if (module2.isDisposed()) continue;
                    String path2 = module2.getModuleFilePath();
                    if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                        try {
                            StateStorageManagerKt.saveComponentManager(module2);
                            VirtualFile moduleFile = module2.getModuleFile();
                            if (moduleFile != null) {
                                Path orphanModulePath = unlinkedModulesDir.resolve(String.valueOf(path2.hashCode()));
                                FileUtil.writeToFile(orphanModulePath.toFile(), moduleFile.contentsToByteArray());
                                Path orphanModuleOriginPath = unlinkedModulesDir.resolve(path2.hashCode() + ".path");
                                FileUtil.writeToFile(orphanModuleOriginPath.toFile(), path2);
                                orphanModules.add(orphanModulePath);
                            }
                        }
                        catch (Exception e) {
                            LOG.warn(e);
                        }
                    }
                    modelsProvider.getModifiableModuleModel().disposeModule(module2);
                    ModuleBuilder.deleteModuleFile(path2);
                }
            }
            finally {
                historyAction.finish();
            }
        });
    }

    @Override
    public void onSuccessImport(@NotNull Collection<DataNode<E>> imported, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModelsProvider modelsProvider) {
        Set<Path> orphanModules;
        if (imported == null) {
            AbstractModuleDataService.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(20);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(21);
        }
        if ((orphanModules = project2.getUserData(ORPHAN_MODULE_FILES)) == null || orphanModules.isEmpty()) {
            return;
        }
        AtomicInteger counter = project2.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            return;
        }
        if (counter.decrementAndGet() == 0) {
            project2.putUserData(ORPHAN_MODULE_FILES, null);
            project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
            StringBuilder modulesToRestoreText = new StringBuilder();
            ArrayList<Pair<String, Path>> modulesToRestore = new ArrayList<Pair<String, Path>>();
            for (Path modulePath : orphanModules) {
                try {
                    String path2 = FileUtil.loadFile(modulePath.resolveSibling(modulePath.getFileName() + ".path").toFile());
                    modulesToRestoreText.append(FileUtilRt.getNameWithoutExtension(new File(path2).getName())).append("\n");
                    modulesToRestore.add(Pair.create(path2, modulePath));
                }
                catch (IOException e) {
                    LOG.warn(e);
                }
            }
            String buildSystem = projectData2 != null ? projectData2.getOwner().getReadableName() : "build system";
            String content2 = ExternalSystemBundle.message("orphan.modules.text", buildSystem, StringUtil.shortenTextWithEllipsis(modulesToRestoreText.toString(), 50, 0));
            Notification cleanUpNotification = ORPHAN_MODULE_NOTIFICATION_GROUP.createNotification(content2, NotificationType.INFORMATION).setListener((notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.showRemovedOrphanModules(modulesToRestore, project2)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List<File> filesToRemove = ContainerUtil.map(orphanModules, Path::toFile);
                List<File> toRemove2 = ContainerUtil.map(orphanModules, path2 -> path2.resolveSibling(path2.getFileName() + ".path").toFile());
                FileUtil.asyncDelete(ContainerUtil.concat(filesToRemove, toRemove2));
            });
            Disposer.register(project2, cleanUpNotification::expire);
            cleanUpNotification.notify(project2);
        }
    }

    @Override
    public void onFailureImport(Project project2) {
        project2.putUserData(ORPHAN_MODULE_FILES, null);
        project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
    }

    private static boolean showRemovedOrphanModules(@NotNull List<? extends Pair<String, Path>> orphanModules, @NotNull Project project2) {
        CheckBoxList orphanModulesList;
        DialogWrapper dialog2;
        if (orphanModules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(22);
        }
        if (project2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(23);
        }
        if ((dialog2 = new DialogWrapper(project2, orphanModulesList = new CheckBoxList(), orphanModules){
            final /* synthetic */ CheckBoxList val$orphanModulesList;
            final /* synthetic */ List val$orphanModules;
            {
                this.val$orphanModulesList = checkBoxList;
                this.val$orphanModules = list2;
                super(arg0);
                this.setTitle(ExternalSystemBundle.message("orphan.modules.dialog.title", new Object[0]));
                this.init();
            }

            @Override
            protected JComponent createCenterPanel() {
                this.val$orphanModulesList.setSelectionMode(2);
                this.val$orphanModulesList.setItems(this.val$orphanModules, module2 -> FileUtilRt.getNameWithoutExtension(new File((String)module2.getFirst()).getName()));
                this.val$orphanModulesList.setBorder(JBUI.Borders.empty(5));
                JScrollPane myModulesScrollPane = ScrollPaneFactory.createScrollPane(this.val$orphanModulesList, 20, 30);
                myModulesScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                myModulesScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel content2 = new JPanel(new BorderLayout());
                content2.add((Component)myModulesScrollPane, "Center");
                return content2;
            }

            @Override
            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gbConstraints = new GridBagConstraints();
                JPanel panel2 = new JPanel(new GridBagLayout());
                gbConstraints.insets = JBUI.insets(4, 0, 10, 8);
                panel2.add((Component)new JLabel(ExternalSystemBundle.message("orphan.modules.dialog.text", new Object[0])), gbConstraints);
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$2", "createNorthPanel"));
            }
        }).showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                for (int i = 0; i < orphanModules.size(); ++i) {
                    Pair pair = (Pair)orphanModules.get(i);
                    String originalPath = (String)pair.first;
                    Path savedPath = (Path)pair.second;
                    if (!orphanModulesList.isItemSelected(i) || !savedPath.toFile().isFile()) continue;
                    try {
                        FileUtil.copy(savedPath.toFile(), new File(originalPath));
                        ModuleManager.getInstance(project2).loadModule(originalPath);
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException | JDOMException e) {
                        LOG.warn(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module2) {
        if (module2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(24);
        }
        ExternalSystemModulePropertyManager.getInstance(module2).unlinkExternalOptions();
    }

    protected void setModuleOptions(Module module2, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module2.putUserData(MODULE_DATA_KEY, moduleData);
        ExternalSystemModulePropertyManager.getInstance(module2).setExternalOptions(moduleData.getOwner(), moduleData, moduleDataNode.getData(ProjectKeys.PROJECT));
    }

    @Override
    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(26);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(27);
        }
        for (DataNode<E> moduleDataNode : toImport) {
            Module module2 = moduleDataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            Map<OrderEntry, OrderAware> orderAwareMap = moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module2));
            }
            moduleDataNode.putUserData(MODULE_KEY, null);
            moduleDataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Module module3 : modelsProvider.getModules()) {
            module3.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair;
        int i;
        if (orderEntryDataMap == null) {
            AbstractModuleDataService.$$$reportNull$$$0(28);
        }
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(29);
        }
        OrderEntry[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        OrderEntry[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair<OrderEntry, OrderAware>> priorityQueue = new PriorityQueue<Pair<OrderEntry, OrderAware>>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            if (order1 != (order2 = ((OrderAware)o2.second).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            return ((OrderAware)o1.second).toString().compareTo(((OrderAware)o2.second).toString());
        });
        ArrayList<OrderEntry> noOrderAwareItems = new ArrayList<OrderEntry>();
        for (i = 0; i < length; ++i) {
            OrderEntry orderEntry = orderEntries[i];
            OrderAware orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                noOrderAwareItems.add(orderEntry);
                continue;
            }
            priorityQueue.add(Pair.create(orderEntry, orderAware));
        }
        Collections.sort(noOrderAwareItems, new Comparator<OrderEntry>(){

            @Override
            public int compare(OrderEntry o1, OrderEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (i = 0; i < noOrderAwareItems.size(); ++i) {
            newOrder[i] = (OrderEntry)noOrderAwareItems.get(i);
        }
        int index = noOrderAwareItems.size();
        while ((pair = (Pair)priorityQueue.poll()) != null) {
            newOrder[index] = (OrderEntry)pair.first;
            ++index;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed2 = !ArrayUtil.equals(orderEntries, newOrder, Comparator.naturalOrder());
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed2 ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries(newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx;
    }

    private void importModuleSdk(@NotNull ModifiableRootModel modifiableRootModel, E data2) {
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(30);
        }
        if (!((ModuleData)data2).isSetSdkName()) {
            return;
        }
        if (modifiableRootModel.getSdk() != null) {
            return;
        }
        String skdName = ((ModuleData)data2).getSdkName();
        if (skdName == null) {
            return;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk2 = projectJdkTable.findJdk(skdName);
        if (sdk2 == null) {
            return;
        }
        Project project2 = modifiableRootModel.getProject();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
        Sdk projectSdk = projectRootManager.getProjectSdk();
        if (sdk2.equals(projectSdk)) {
            modifiableRootModel.inheritSdk();
        } else {
            modifiableRootModel.setSdk(sdk2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveComputable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orphanModules";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingModules";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showRemovedOrphanModules";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unlinkModuleFromExternalSystem";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeOrderEntries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "importModuleSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

