/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create("createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @Override
    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key<ContentRootData> key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            ContentRootDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(3);
        }
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]", new Object[0]);
        if (toImport.isEmpty()) {
            return;
        }
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance(project2);
        boolean isNewlyImportedProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode<ProjectData> projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet<Module> modulesToExpand = new THashSet<Module>();
        MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        ContentRootDataService.filterAndReportDuplicatingContentRoots(byModule, project2);
        for (Map.Entry<DataNode<ModuleData>, Collection<DataNode<ContentRootData>>> entry : byModule.entrySet()) {
            Module module2 = entry.getKey().getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module3 = module2 = module2 != null ? module2 : modelsProvider.findIdeModule(entry.getKey().getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, sourceFolderManager, entry.getValue(), module2, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData2 == null || !projectData2.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath(module2)))) continue;
            modulesToExpand.add(module2);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module4 : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module4);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module4).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile2 = roots[0];
                StartupManager.getInstance(project2).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    ProjectView projectView = ProjectView.getInstance(project2);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile2, false));
                }, ModalityState.NON_MODAL, project2.getDisposed()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull SourceFolderManager sourceFolderManager, @NotNull Collection<? extends DataNode<ContentRootData>> data2, @NotNull Module module2, boolean forceDirectoriesCreation) {
        void var10_12;
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(4);
        }
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(5);
        }
        if (data2 == null) {
            ContentRootDataService.$$$reportNull$$$0(6);
        }
        if (module2 == null) {
            ContentRootDataService.$$$reportNull$$$0(7);
        }
        ContentRootDataService.logUnitTest("Import data for module [" + module2.getName() + "], data size [" + data2.size() + "]", new Object[0]);
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap<String, ContentEntry> contentEntriesMap = new HashMap<String, ContentEntry>();
        ContentEntry[] contentEntryArray = contentEntries;
        int n = contentEntryArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            ContentEntry contentEntry = contentEntryArray[var10_12];
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
            ++var10_12;
        }
        sourceFolderManager.removeSourceFolders(module2);
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> dataNode : data2) {
            ContentRootData contentRoot = dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                ContentRootDataService.removeSourceFoldersIfAbsent(contentEntry, contentRoot);
                importedContentEntries.add(contentEntry);
            }
            ContentRootDataService.logDebug("Importing content root '%s' for module '%s' forceDirectoriesCreation=[%b]", contentRoot.getRootPath(), module2.getName(), forceDirectoriesCreation);
            HashSet<String> updatedSourceRoots = new HashSet<String>();
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type == null) continue;
                for (ContentRootData.SourceRoot sourceRoot : contentRoot.getPaths(externalSrcType)) {
                    boolean createSourceFolder;
                    String sourceRootPath = sourceRoot.getPath();
                    boolean bl2 = createSourceFolder = !updatedSourceRoots.contains(sourceRootPath);
                    if (createSourceFolder) {
                        ContentRootDataService.createOrReplaceSourceFolder(sourceFolderManager, contentEntry, sourceRoot, module2, type, forceDirectoriesCreation);
                        if (externalSrcType == ExternalSystemSourceType.SOURCE || externalSrcType == ExternalSystemSourceType.TEST) {
                            updatedSourceRoots.add(sourceRootPath);
                        }
                    }
                    ContentRootDataService.configureSourceFolder(sourceFolderManager, contentEntry, sourceRoot, createSourceFolder, externalSrcType.isGenerated());
                }
            }
            for (ContentRootData.SourceRoot path2 : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path2, module2.getName(), module2.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type) {
        switch (type) {
            case SOURCE: 
            case SOURCE_GENERATED: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST: 
            case TEST_GENERATED: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case EXCLUDED: {
                return null;
            }
            case RESOURCE: 
            case RESOURCE_GENERATED: {
                return JavaResourceRootType.RESOURCE;
            }
            case TEST_RESOURCE: 
            case TEST_RESOURCE_GENERATED: {
                return JavaResourceRootType.TEST_RESOURCE;
            }
        }
        return null;
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path2) {
        ContentEntry[] entries;
        if (model == null) {
            ContentRootDataService.$$$reportNull$$$0(8);
        }
        if (path2 == null) {
            ContentRootDataService.$$$reportNull$$$0(9);
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath(file2).equals(path2)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                ContentRootDataService.$$$reportNull$$$0(10);
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(VfsUtilCore.pathToUrl(path2));
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(11);
        }
        return contentEntry;
    }

    private static Set<String> getSourceRoots(@NotNull ContentRootData contentRoot) {
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(12);
        }
        THashSet<String> sourceRoots2 = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
        for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
            JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
            if (type == null) continue;
            for (ContentRootData.SourceRoot path2 : contentRoot.getPaths(externalSrcType)) {
                if (path2 == null) continue;
                sourceRoots2.add(path2.getPath());
            }
        }
        return sourceRoots2;
    }

    private static void removeSourceFoldersIfAbsent(@NotNull ContentEntry contentEntry, @NotNull ContentRootData contentRoot) {
        SourceFolder[] sourceFolders2;
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(13);
        }
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(14);
        }
        if ((sourceFolders2 = contentEntry.getSourceFolders()).length == 0) {
            return;
        }
        Set<String> sourceRoots2 = ContentRootDataService.getSourceRoots(contentRoot);
        for (SourceFolder sourceFolder : sourceFolders2) {
            String url = sourceFolder.getUrl();
            String path2 = VfsUtilCore.urlToPath(url);
            if (sourceRoots2.contains(path2)) continue;
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    private static void createOrReplaceSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, @NotNull Module module2, @NotNull JpsModuleSourceRootType<?> sourceRootType2, boolean createEmptyContentRootDirectories) {
        SourceFolder folder;
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(15);
        }
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(16);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(17);
        }
        if (module2 == null) {
            ContentRootDataService.$$$reportNull$$$0(18);
        }
        if (sourceRootType2 == null) {
            ContentRootDataService.$$$reportNull$$$0(19);
        }
        if ((folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot)) != null) {
            JpsModuleSourceRootType<?> folderRootType = folder.getRootType();
            if (sourceRootType2.equals(folderRootType)) {
                return;
            }
            contentEntry.removeSourceFolder(folder);
        }
        String path2 = sourceRoot.getPath();
        String url = VfsUtilCore.pathToUrl(path2);
        if (createEmptyContentRootDirectories) {
            ContentRootDataService.createEmptyDirectory(path2);
        }
        if (!FileUtil.exists(path2)) {
            ContentRootDataService.logDebug("Source folder [%s] does not exist and will not be created, will add when dir is created", url);
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [%s] for creation in project [hashCode=%d]", url, module2.getProject().hashCode());
            sourceFolderManager.addSourceFolder(module2, url, sourceRootType2);
        } else {
            contentEntry.addSourceFolder(url, sourceRootType2);
        }
    }

    private static void configureSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, boolean updatePackagePrefix, boolean generated) {
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(20);
        }
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(21);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(22);
        }
        String packagePrefix = sourceRoot.getPackagePrefix();
        String url = VfsUtilCore.pathToUrl(sourceRoot.getPath());
        ContentRootDataService.logDebug("Importing root '%s' with packagePrefix=[%s] generated=[%b]", sourceRoot, packagePrefix, generated);
        SourceFolder folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot);
        if (folder == null) {
            if (updatePackagePrefix) {
                sourceFolderManager.setSourceFolderPackagePrefix(url, packagePrefix);
            }
            if (generated) {
                sourceFolderManager.setSourceFolderGenerated(url, true);
            }
        } else {
            if (updatePackagePrefix && StringUtil.isNotEmpty(packagePrefix)) {
                folder.setPackagePrefix(packagePrefix);
            }
            if (generated) {
                ContentRootDataService.setForGeneratedSources(folder, true);
            }
        }
    }

    private static void createEmptyDirectory(@NotNull String path2) {
        if (path2 == null) {
            ContentRootDataService.$$$reportNull$$$0(23);
        }
        if (FileUtil.exists(path2)) {
            return;
        }
        ExternalSystemApiUtil.doWriteAction(() -> {
            try {
                VfsUtil.createDirectoryIfMissing(path2);
            }
            catch (IOException e) {
                LOG.warn(String.format("Unable to create directory for the path: %s", path2), e);
            }
        });
    }

    @Nullable
    private static SourceFolder findSourceFolder(@NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot) {
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(24);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(25);
        }
        for (SourceFolder folder : contentEntry.getSourceFolders()) {
            String rootPath;
            String folderPath;
            VirtualFile file2 = folder.getFile();
            if (file2 == null || !(folderPath = ExternalSystemApiUtil.getLocalFileSystemPath(file2)).equals(rootPath = sourceRoot.getPath())) continue;
            return folder;
        }
        return null;
    }

    private static void setForGeneratedSources(@NotNull SourceFolder folder, boolean generated) {
        JpsModuleSourceRoot jpsElement;
        JavaSourceRootProperties properties;
        if (folder == null) {
            ContentRootDataService.$$$reportNull$$$0(26);
        }
        if ((properties = (JavaSourceRootProperties)(jpsElement = folder.getJpsElement()).getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(generated);
        }
    }

    private static void logUnitTest(@NotNull String format, Object ... args) {
        if (format == null) {
            ContentRootDataService.$$$reportNull$$$0(27);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(String.format(format, args));
        }
    }

    private static void logDebug(@NotNull String format, Object ... args) {
        if (format == null) {
            ContentRootDataService.$$$reportNull$$$0(28);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(format, args));
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project2) {
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(29);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(30);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(31);
        }
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(32);
        }
        String rootPath = root.getPath();
        for (VirtualFile file2 : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath(file2).equals(rootPath)) continue;
            return;
        }
        ContentRootDataService.logDebug("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName);
        entry.addExcludeFolder(VfsUtilCore.pathToUrl(rootPath));
    }

    private static void filterAndReportDuplicatingContentRoots(@NotNull MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> moduleNodeToRootNodes, @NotNull Project project2) {
        String notificationMessage;
        if (moduleNodeToRootNodes == null) {
            ContentRootDataService.$$$reportNull$$$0(33);
        }
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(34);
        }
        LinkedHashMap<String, DuplicateModuleReport> filter2 = new LinkedHashMap<String, DuplicateModuleReport>();
        for (Map.Entry<DataNode<ModuleData>, Collection<DataNode<ContentRootData>>> entry : moduleNodeToRootNodes.entrySet()) {
            ModuleData moduleData = entry.getKey().getData();
            Collection<DataNode<ContentRootData>> crDataNodes = entry.getValue();
            Iterator<DataNode<ContentRootData>> iterator2 = crDataNodes.iterator();
            while (iterator2.hasNext()) {
                DataNode<ContentRootData> crDataNode = iterator2.next();
                String rootPath = crDataNode.getData().getRootPath();
                DuplicateModuleReport report = filter2.putIfAbsent(rootPath, new DuplicateModuleReport(moduleData));
                if (report == null) continue;
                report.addDuplicate(moduleData);
                iterator2.remove();
                crDataNode.clear(true);
            }
        }
        Map toReport = filter2.entrySet().stream().filter(e -> ((DuplicateModuleReport)e.getValue()).hasDuplicates()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (r1, r2) -> {
            LOG.warn("Unexpected duplicates in keys while collecting filtered reports");
            return r2;
        }, LinkedHashMap::new));
        if (!toReport.isEmpty() && (notificationMessage = ContentRootDataService.prepareMessageAndLogWarnings(toReport)) != null) {
            ContentRootDataService.showNotificationsPopup(project2, toReport.size(), notificationMessage);
        }
    }

    @Nullable
    private static String prepareMessageAndLogWarnings(@NotNull Map<String, DuplicateModuleReport> toReport) {
        if (toReport == null) {
            ContentRootDataService.$$$reportNull$$$0(35);
        }
        String firstMessage = null;
        LOG.warn("Duplicating content roots detected.");
        for (Map.Entry<String, DuplicateModuleReport> entry : toReport.entrySet()) {
            String path2 = entry.getKey();
            DuplicateModuleReport report = entry.getValue();
            String message = String.format("Path [%s] of module [%s] was removed from modules [%s]", path2, report.getOriginalName(), StringUtil.join(report.getDuplicatesNames(), ", "));
            if (firstMessage == null) {
                firstMessage = message;
            }
            LOG.warn(message);
        }
        return firstMessage;
    }

    private static void showNotificationsPopup(@NotNull Project project2, int reportsCount, @NotNull String notificationMessage) {
        int extraReportsCount;
        if (project2 == null) {
            ContentRootDataService.$$$reportNull$$$0(36);
        }
        if (notificationMessage == null) {
            ContentRootDataService.$$$reportNull$$$0(37);
        }
        if ((extraReportsCount = reportsCount - 1) > 0) {
            notificationMessage = notificationMessage + "<br>Also " + extraReportsCount + " more " + StringUtil.pluralize("path", extraReportsCount) + " " + (extraReportsCount == 1 ? "was" : "were") + " deduplicated. See idea log for details";
        }
        Notification notification = new Notification("Content root duplicates", ExternalSystemBundle.message("duplicate.content.roots.detected", new Object[0]), notificationMessage, NotificationType.WARNING);
        Notifications.Bus.notify(notification, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolderManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 13: 
            case 16: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNodeToRootNodes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReport";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFoldersIfAbsent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOrReplaceSourceFolder";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureSourceFolder";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyDirectory";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFolder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setForGeneratedSources";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "logUnitTest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "logDebug";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterAndReportDuplicatingContentRoots";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessageAndLogWarnings";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationsPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DuplicateModuleReport {
        private final ModuleData myOriginal;
        private final List<ModuleData> myDuplicates;

        public DuplicateModuleReport(@NotNull ModuleData original) {
            if (original == null) {
                DuplicateModuleReport.$$$reportNull$$$0(0);
            }
            this.myDuplicates = new ArrayList<ModuleData>();
            this.myOriginal = original;
        }

        public void addDuplicate(@NotNull ModuleData duplicate) {
            if (duplicate == null) {
                DuplicateModuleReport.$$$reportNull$$$0(1);
            }
            this.myDuplicates.add(duplicate);
        }

        public boolean hasDuplicates() {
            return !this.myDuplicates.isEmpty();
        }

        public String getOriginalName() {
            return this.myOriginal.getInternalName();
        }

        public Collection<String> getDuplicatesNames() {
            return ContainerUtil.map(this.myDuplicates, AbstractNamedData::getInternalName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService$DuplicateModuleReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

