/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemKeymapExtension
implements KeymapExtension {
    /*
     * WARNING - void declaration
     */
    @Override
    public KeymapGroup createGroup(Condition<AnAction> condition2, final Project project2) {
        AnAction[] externalSystemActions;
        KeymapGroup result2 = KeymapGroupFactory.getInstance().createGroup(ExternalSystemBundle.message("external.system.keymap.group", new Object[0]), AllIcons.Nodes.ConfigFolder);
        for (AnAction action2 : externalSystemActions = ActionsTreeUtil.getActions("ExternalSystem.Actions")) {
            ActionsTreeUtil.addAction(result2, action2, condition2);
        }
        if (project2 == null) {
            return result2;
        }
        MultiMap<ProjectSystemId, Object> projectToActionsMapping = MultiMap.create();
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
            projectToActionsMapping.putValues(manager.getSystemId(), ContainerUtil.emptyList());
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            void var9_16;
            String[] manager = actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null));
            int n = manager.length;
            boolean bl = false;
            while (var9_16 < n) {
                String eachId = manager[var9_16];
                AnAction anAction = actionManager.getAction(eachId);
                if (anAction instanceof MyExternalSystemAction && (condition2 == null || condition2.value(actionManager.getActionOrStub(eachId)))) {
                    MyExternalSystemAction taskAction = (MyExternalSystemAction)anAction;
                    projectToActionsMapping.putValue(taskAction.getSystemId(), eachId);
                }
                ++var9_16;
            }
        }
        HashMap<ProjectSystemId, KeymapGroup> keymapGroupMap = new HashMap<ProjectSystemId, KeymapGroup>();
        for (ProjectSystemId projectSystemId : projectToActionsMapping.keySet()) {
            if (keymapGroupMap.containsKey(projectSystemId)) continue;
            Icon projectIcon = ExternalSystemUiUtil.getUiAware(projectSystemId).getProjectIcon();
            KeymapGroup keymapGroup = KeymapGroupFactory.getInstance().createGroup(projectSystemId.getReadableName(), projectIcon);
            keymapGroupMap.put(projectSystemId, keymapGroup);
        }
        for (Map.Entry entry : projectToActionsMapping.entrySet()) {
            Collection tasks = (Collection)entry.getValue();
            final ProjectSystemId projectSystemId = (ProjectSystemId)entry.getKey();
            KeymapGroup systemGroup = (KeymapGroup)keymapGroupMap.get(projectSystemId);
            if (systemGroup == null) continue;
            for (String actionId : tasks) {
                systemGroup.addActionId(actionId);
            }
            if (!(systemGroup instanceof Group)) continue;
            Icon icon2 = AllIcons.General.Add;
            ((Group)systemGroup).addHyperlink(new Hyperlink(icon2, "Choose a task to assign a shortcut"){

                @Override
                public void onClick(MouseEvent e) {
                    SelectExternalTaskDialog dialog2 = new SelectExternalTaskDialog(projectSystemId, project2);
                    if (dialog2.showAndGet() && dialog2.getResult() != null) {
                        KeymapPanel keymapPanel;
                        TaskData taskData = (TaskData)dialog2.getResult().second;
                        String ownerModuleName = (String)dialog2.getResult().first;
                        ExternalSystemTaskAction externalSystemAction = (ExternalSystemTaskAction)ExternalSystemKeymapExtension.getOrRegisterAction(project2, ownerModuleName, taskData);
                        ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC).processCurrentKeymapChanged();
                        Settings allSettings = Settings.KEY.getData(DataManager.getInstance().getDataContext(e.getComponent()));
                        KeymapPanel keymapPanel2 = keymapPanel = allSettings != null ? allSettings.find(KeymapPanel.class) : null;
                        if (keymapPanel != null) {
                            keymapPanel.showOption("");
                            keymapPanel.selectAction(externalSystemAction.myId);
                        }
                    }
                }
            });
        }
        for (KeymapGroup keymapGroup : keymapGroupMap.values()) {
            if (!ExternalSystemKeymapExtension.isGroupFiltered(condition2, keymapGroup)) continue;
            result2.addGroup(keymapGroup);
        }
        for (Iterator<Object> iterator2 : ActionsProvider.EP_NAME.getExtensions()) {
            KeymapGroup keymapGroup = iterator2.createGroup(condition2, project2);
            if (!ExternalSystemKeymapExtension.isGroupFiltered(condition2, keymapGroup)) continue;
            result2.addGroup(keymapGroup);
        }
        return result2;
    }

    public static void updateActions(Project project2, @NotNull Collection<? extends DataNode<TaskData>> taskData) {
        if (taskData == null) {
            ExternalSystemKeymapExtension.$$$reportNull$$$0(0);
        }
        ExternalSystemKeymapExtension.clearActions(project2, taskData);
        ExternalSystemKeymapExtension.createActions(project2, taskData);
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, String group, TaskData taskData) {
        ExternalSystemTaskAction action2 = new ExternalSystemTaskAction(project2, group, taskData);
        ActionManager manager = ActionManager.getInstance();
        AnAction anAction = manager.getAction(action2.getId());
        if (anAction instanceof ExternalSystemTaskAction && action2.equals(anAction)) {
            return (ExternalSystemAction)anAction;
        }
        manager.replaceAction(action2.getId(), action2);
        return action2;
    }

    private static boolean isGroupFiltered(Condition<? super AnAction> condition2, KeymapGroup keymapGroup) {
        EmptyAction emptyAction = new EmptyAction();
        if (condition2 != null && !condition2.value(emptyAction) && keymapGroup instanceof Group) {
            Group group = (Group)keymapGroup;
            return group.getSize() > 1 || condition2.value(new EmptyAction(group.getName(), null, null));
        }
        return true;
    }

    private static void createActions(Project project2, Collection<? extends DataNode<TaskData>> taskNodes) {
        ActionManager actionManager = ActionManager.getInstance();
        ExternalSystemShortcutsManager shortcutsManager = ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager();
        if (actionManager != null) {
            for (DataNode<TaskData> dataNode : taskNodes) {
                DataNode<ModuleData> moduleData = ExternalSystemApiUtil.findParent(dataNode, ProjectKeys.MODULE);
                if (moduleData == null || moduleData.isIgnored()) continue;
                TaskData taskData = dataNode.getData();
                ExternalSystemTaskAction eachAction = new ExternalSystemTaskAction(project2, moduleData.getData().getInternalName(), taskData);
                if (shortcutsManager.hasShortcuts(taskData.getLinkedExternalProjectPath(), taskData.getName())) {
                    actionManager.replaceAction(eachAction.getId(), eachAction);
                    continue;
                }
                actionManager.unregisterAction(eachAction.getId());
            }
        }
    }

    static void clearActions(@NotNull ExternalSystemShortcutsManager externalSystemShortcutsManager) {
        ActionManager manager;
        if (externalSystemShortcutsManager == null) {
            ExternalSystemKeymapExtension.$$$reportNull$$$0(1);
        }
        if ((manager = ActionManager.getInstance()) != null) {
            for (String each : manager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(externalSystemShortcutsManager, null))) {
                manager.unregisterAction(each);
            }
        }
    }

    private static void clearActions(Project project2, Collection<? extends DataNode<TaskData>> taskData) {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            HashSet<String> externalProjectPaths = new HashSet<String>();
            for (DataNode<TaskData> dataNode : taskData) {
                externalProjectPaths.add(dataNode.getData().getLinkedExternalProjectPath());
            }
            for (String string : externalProjectPaths) {
                for (String eachAction : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, string))) {
                    AnAction action2 = actionManager.getAction(eachAction);
                    if (action2 instanceof ExternalSystemRunConfigurationAction) continue;
                    actionManager.unregisterAction(eachAction);
                }
            }
        }
    }

    @NotNull
    public static String getActionPrefix(@NotNull Project project2, @Nullable String path2) {
        if (project2 == null) {
            ExternalSystemKeymapExtension.$$$reportNull$$$0(2);
        }
        ExternalSystemShortcutsManager externalSystemShortcutsManager = ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager();
        return ExternalSystemKeymapExtension.getActionPrefix(externalSystemShortcutsManager, path2);
    }

    @NotNull
    private static String getActionPrefix(@NotNull ExternalSystemShortcutsManager externalSystemShortcutsManager, @Nullable String path2) {
        if (externalSystemShortcutsManager == null) {
            ExternalSystemKeymapExtension.$$$reportNull$$$0(3);
        }
        String string = externalSystemShortcutsManager.getActionId(path2, null);
        if (string == null) {
            ExternalSystemKeymapExtension.$$$reportNull$$$0(4);
        }
        return string;
    }

    static void updateRunConfigurationActions(Project project2, ProjectSystemId systemId) {
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemId);
        if (configurationType == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String eachAction : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
            AnAction action2 = actionManager.getAction(eachAction);
            if (!(action2 instanceof ExternalSystemRunConfigurationAction)) continue;
            actionManager.unregisterAction(eachAction);
        }
        THashSet<RunnerAndConfigurationSettings> settings = new THashSet<RunnerAndConfigurationSettings>(RunManager.getInstance(project2).getConfigurationSettingsList(configurationType));
        ExternalSystemShortcutsManager shortcutsManager = ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager();
        for (RunnerAndConfigurationSettings configurationSettings : settings) {
            ExternalSystemRunConfigurationAction runConfigurationAction = new ExternalSystemRunConfigurationAction(project2, configurationSettings);
            String id2 = runConfigurationAction.getId();
            if (shortcutsManager.hasShortcuts(id2)) {
                actionManager.replaceAction(id2, runConfigurationAction);
                continue;
            }
            actionManager.unregisterAction(id2);
        }
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, RunnerAndConfigurationSettings configurationSettings) {
        ActionManager manager = ActionManager.getInstance();
        ExternalSystemRunConfigurationAction runConfigurationAction = new ExternalSystemRunConfigurationAction(project2, configurationSettings);
        String id2 = runConfigurationAction.getId();
        manager.replaceAction(id2, runConfigurationAction);
        return runConfigurationAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemShortcutsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionPrefix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExternalSystemRunConfigurationAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final RunnerAndConfigurationSettings myConfigurationSettings;
        private final ProjectSystemId systemId;

        ExternalSystemRunConfigurationAction(Project project2, RunnerAndConfigurationSettings configurationSettings) {
            this.myConfigurationSettings = configurationSettings;
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)configurationSettings.getConfiguration();
            this.systemId = runConfiguration.getSettings().getExternalSystemId();
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(this.systemId);
            this.myGroup = uiAware.getProjectRepresentationName(runConfiguration.getSettings().getExternalProjectPath(), null);
            String actionIdPrefix = ExternalSystemKeymapExtension.getActionPrefix(project2, runConfiguration.getSettings().getExternalProjectPath());
            this.myId = actionIdPrefix + configurationSettings.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myConfigurationSettings.getName(), false);
            template.setIcon(runConfiguration.getIcon());
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalSystemRunConfigurationAction.$$$reportNull$$$0(0);
            }
            return this.hasProject(e);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalSystemRunConfigurationAction.$$$reportNull$$$0(1);
            }
            ProgramRunnerUtil.executeConfiguration(this.myConfigurationSettings, DefaultRunExecutor.getRunExecutorInstance());
        }

        @Override
        public String toString() {
            return this.myConfigurationSettings.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.systemId;
        }

        @Override
        public String getId() {
            return this.myId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemRunConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExternalSystemTaskAction
    extends MyExternalSystemAction {
        private final String myId;
        private final String myGroup;
        private final TaskData myTaskData;

        ExternalSystemTaskAction(Project project2, String group, TaskData taskData) {
            this.myGroup = group;
            this.myTaskData = taskData;
            this.myId = ExternalSystemKeymapExtension.getActionPrefix(project2, taskData.getLinkedExternalProjectPath()) + taskData.getName();
            Presentation template = this.getTemplatePresentation();
            template.setText(this.myTaskData.getName() + " (" + group + ")", false);
            template.setDescription(ExternalSystemBundle.message("0.task.action", this.myTaskData.getOwner().getReadableName()));
            template.setIcon(ExternalSystemIcons.Task);
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalSystemTaskAction.$$$reportNull$$$0(0);
            }
            return this.hasProject(e);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalSystemTaskAction.$$$reportNull$$$0(1);
            }
            ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(this.myTaskData);
            ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), this.getProject(e), this.myTaskData.getOwner());
        }

        public TaskData getTaskData() {
            return this.myTaskData;
        }

        @Override
        public String toString() {
            return this.myTaskData.toString();
        }

        @Override
        public String getGroup() {
            return this.myGroup;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.myTaskData.getOwner();
        }

        @Override
        public String getId() {
            return this.myId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExternalSystemTaskAction)) {
                return false;
            }
            ExternalSystemTaskAction action2 = (ExternalSystemTaskAction)o;
            if (this.myId != null ? !this.myId.equals(action2.myId) : action2.myId != null) {
                return false;
            }
            if (this.myGroup != null ? !this.myGroup.equals(action2.myGroup) : action2.myGroup != null) {
                return false;
            }
            return this.myTaskData.equals(action2.myTaskData);
        }

        public int hashCode() {
            int result2 = this.myId != null ? this.myId.hashCode() : 0;
            result2 = 31 * result2 + (this.myGroup != null ? this.myGroup.hashCode() : 0);
            result2 = 31 * result2 + this.myTaskData.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemTaskAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyExternalSystemAction
    extends ExternalSystemAction {
        private MyExternalSystemAction() {
        }

        public abstract String getId();

        public abstract String getGroup();

        public abstract ProjectSystemId getSystemId();
    }

    @FunctionalInterface
    public static interface ActionsProvider {
        public static final ExtensionPointName<ActionsProvider> EP_NAME = ExtensionPointName.create("com.intellij.externalSystemKeymapProvider");

        public KeymapGroup createGroup(Condition<? super AnAction> var1, Project var2);
    }
}

