/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectStructureUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483628)
public final class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance(LibraryDataService.class);
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = path2 -> new File((String)path2);

    @Override
    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key<LibraryData> key = ProjectKeys.LIBRARY;
        if (key == null) {
            LibraryDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            LibraryDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(3);
        }
        HashMap<String, LibraryData> processedLibraries = new HashMap<String, LibraryData>();
        for (DataNode<LibraryData> dataNode : toImport) {
            LibraryData libraryData = dataNode.getData();
            String libraryName = libraryData.getInternalName();
            LibraryData importedLibrary = processedLibraries.putIfAbsent(libraryName, libraryData);
            if (importedLibrary == null) {
                this.importLibrary(libraryData, modelsProvider);
                continue;
            }
            LOG.warn("Multiple project level libraries found with the same name '" + libraryName + "'");
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Chosen library:" + importedLibrary.getPaths(LibraryPathType.BINARY));
            LOG.debug("Ignored library:" + libraryData.getPaths(LibraryPathType.BINARY));
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(5);
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        String libraryName = toImport.getInternalName();
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library != null) {
            LibraryDataService.syncPaths(toImport, library, modelsProvider);
            return;
        }
        library = modelsProvider.createLibrary(libraryName, ExternalSystemApiUtil.toExternalSource(toImport.getOwner()));
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        Set<String> excludedPaths = toImport.getPaths(LibraryPathType.EXCLUDED);
        LibraryDataService.registerPaths(toImport.isUnresolved(), libraryFiles, excludedPaths, libraryModel, libraryName);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data2) {
        if (data2 == null) {
            LibraryDataService.$$$reportNull$$$0(6);
        }
        HashMap<OrderRootType, Collection<File>> result2 = new HashMap<OrderRootType, Collection<File>>();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set<String> paths;
            OrderRootType orderRootType = ExternalLibraryPathTypeMapper.getInstance().map(pathType);
            if (orderRootType == null || (paths = data2.getPaths(pathType)).isEmpty()) continue;
            result2.put(orderRootType, ContainerUtil.map(paths, PATH_TO_FILE));
        }
        HashMap<OrderRootType, Collection<File>> hashMap = result2;
        if (hashMap == null) {
            LibraryDataService.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    static void registerPaths(boolean unresolved, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Set<String> excludedPaths, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            LibraryDataService.$$$reportNull$$$0(8);
        }
        if (excludedPaths == null) {
            LibraryDataService.$$$reportNull$$$0(9);
        }
        if (model == null) {
            LibraryDataService.$$$reportNull$$$0(10);
        }
        if (libraryName == null) {
            LibraryDataService.$$$reportNull$$$0(11);
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file2 : entry.getValue()) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3 = virtualFile2 = unresolved ? null : ExternalSystemUtil.refreshAndFindFileByIoFile(file2);
                if (virtualFile2 == null) {
                    String[] urls;
                    String url;
                    if (!unresolved && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file2.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains(url = VfsUtil.getUrlForLibraryRoot(file2), urls = model.getUrls(entry.getKey()))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile2.isDirectory()) {
                    VirtualFile[] files2 = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains(virtualFile2, files2)) continue;
                    model.addRoot(virtualFile2, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile2;
                if (virtualFile2.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile2)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file2.getAbsolutePath(), libraryName));
                    continue;
                }
                VirtualFile[] files3 = model.getFiles(entry.getKey());
                if (ArrayUtil.contains(root, files3)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
        if (model instanceof LibraryEx.ModifiableModelEx) {
            LibraryEx.ModifiableModelEx modelEx = (LibraryEx.ModifiableModelEx)model;
            for (String excludedPath : excludedPaths) {
                String[] urls;
                String url = VfsUtil.getUrlForLibraryRoot(new File(excludedPath));
                if (ArrayUtil.contains(url, urls = modelEx.getExcludedRootUrls())) continue;
                modelEx.addExcludedRoot(url);
            }
        }
    }

    @Override
    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            LibraryDataService.$$$reportNull$$$0(13);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(14);
        }
        if (projectData2 == null) {
            return;
        }
        if (modelsProvider instanceof ProjectStructureUIModifiableModelsProvider) {
            return;
        }
        SmartList<Library> orphanIdeLibraries = new SmartList<Library>();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        final HashMap<String, Library> namesToLibs = new HashMap<String, Library>();
        final HashSet<Library> potentialOrphans = new HashSet<Library>();
        RootPolicy<Void> excludeUsedLibraries = new RootPolicy<Void>(){

            @Override
            public Void visitLibraryOrderEntry(@NotNull LibraryOrderEntry ideDependency, Void value2) {
                if (ideDependency == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ideDependency.isModuleLevel()) {
                    return null;
                }
                Library lib = ideDependency.getLibrary();
                if (lib == null) {
                    lib = (Library)namesToLibs.get(ideDependency.getLibraryName());
                }
                if (lib != null) {
                    potentialOrphans.remove(lib);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideDependency", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "visitLibraryOrderEntry"));
            }
        };
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary(library, projectData2.getOwner())) continue;
            namesToLibs.put(library.getName(), library);
            potentialOrphans.add(library);
        }
        for (Disposable disposable2 : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries((Module)disposable2)) {
                entry.accept(excludeUsedLibraries, null);
            }
        }
        for (Library lib : potentialOrphans) {
            if (modelsProvider.isSubstituted(lib.getName())) continue;
            orphanIdeLibraries.add(lib);
        }
        for (Library library : orphanIdeLibraries) {
            Library library2;
            String libraryName = library.getName();
            if (libraryName == null || (library2 = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(library2);
        }
    }

    private static void syncPaths(@NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (externalLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(15);
        }
        if (ideLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(16);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(17);
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        HashMap toRemove2 = new HashMap();
        HashMap<OrderRootType, HashSet<String>> toAdd = new HashMap<OrderRootType, HashSet<String>>();
        ExternalLibraryPathTypeMapper externalLibraryPathTypeMapper = ExternalLibraryPathTypeMapper.getInstance();
        for (Object pathType : LibraryPathType.values()) {
            OrderRootType ideType = externalLibraryPathTypeMapper.map((LibraryPathType)((Object)pathType));
            if (ideType == null) continue;
            HashSet<String> toAddPerType = new HashSet<String>(externalLibrary.getPaths((LibraryPathType)((Object)pathType)));
            toAdd.put(ideType, toAddPerType);
            if (pathType != LibraryPathType.BINARY && toAddPerType.isEmpty()) continue;
            HashSet<String> toRemovePerType = new HashSet<String>();
            toRemove2.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath(ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove2.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
        for (Map.Entry entry : toRemove2.entrySet()) {
            for (String path2 : (Set)entry.getValue()) {
                libraryModel.removeRoot(path2, (OrderRootType)entry.getKey());
            }
        }
        Set<String> excludedPaths = externalLibrary.getPaths(LibraryPathType.EXCLUDED);
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap<OrderRootType, Collection<File>> roots = new HashMap<OrderRootType, Collection<File>>();
            roots.put((OrderRootType)entry.getKey(), (Collection<File>)ContainerUtil.map((Collection)entry.getValue(), PATH_TO_FILE));
            LibraryDataService.registerPaths(externalLibrary.isUnresolved(), roots, excludedPaths, libraryModel, externalLibrary.getInternalName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 1: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareLibraryFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

