/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    public ProjectDataManagerImpl() {
        this(() -> ProjectDataService.EP_NAME.getExtensions());
    }

    @Override
    @Nullable
    public List<ProjectDataService<?, ?>> findService(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(0);
        }
        return this.myServices.getValue().get(key);
    }

    @NonInjectable
    ProjectDataManagerImpl(ProjectDataService<?, ?> ... dataServices) {
        this(() -> dataServices);
    }

    @NonInjectable
    private ProjectDataManagerImpl(final Supplier<ProjectDataService<?, ?>[]> supplier) {
        this.myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

            @Override
            @NotNull
            protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
                HashMap result2 = new HashMap();
                for (ProjectDataService service : (ProjectDataService[])supplier.get()) {
                    ArrayList<ProjectDataService> services = (ArrayList<ProjectDataService>)result2.get(service.getTargetDataKey());
                    if (services == null) {
                        services = new ArrayList<ProjectDataService>();
                        result2.put(service.getTargetDataKey(), services);
                    }
                    services.add(service);
                }
                for (List services : result2.values()) {
                    ExternalSystemApiUtil.orderAwareSort(services);
                }
                HashMap hashMap = result2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace trace;
        ProjectData projectData2;
        ProjectSystemId projectSystemId;
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(3);
        }
        if (project2.isDisposed()) {
            return;
        }
        MultiMap<Key<?>, DataNode<?>> grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection<DataNode<?>> projects = grouped.get(ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode<ProjectData> projectNode = ContainerUtil.getFirstItem(projects);
        if (projectNode != null) {
            ProjectData projectData3 = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings(projectNode);
        } else {
            projectData2 = null;
            DataNode<?> aModuleNode = ContainerUtil.getFirstItem(grouped.get(ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        SmartList<Runnable> onSuccessImportTasks = new SmartList<Runnable>();
        SmartList<Runnable> onFailureImportTasks = new SmartList<Runnable>();
        Collection<DataNode<?>> traceNodes = grouped.get(PerformanceTrace.TRACE_NODE_KEY);
        if (traceNodes.size() > 0) {
            trace = (PerformanceTrace)traceNodes.iterator().next().getData();
        } else {
            trace = new PerformanceTrace();
            grouped.putValue(PerformanceTrace.TRACE_NODE_KEY, new DataNode<PerformanceTrace>(PerformanceTrace.TRACE_NODE_KEY, trace, null));
        }
        long allStartTime = System.currentTimeMillis();
        try {
            TreeSet allKeys = new TreeSet(grouped.keySet());
            allKeys.addAll(this.myServices.getValue().keySet());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            SmartList<Runnable> postImportTasks = new SmartList<Runnable>();
            for (Key key : allKeys) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message("progress.update.text", projectSystemId != null ? projectSystemId.getReadableName() : "", ExternalSystemBundle.message("progress.update.refresh", ProjectDataManagerImpl.getReadableText(key)));
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                long startTime = System.currentTimeMillis();
                this.doImportData(key, grouped.get(key), projectData2, project2, modelsProvider, postImportTasks, onSuccessImportTasks, onFailureImportTasks);
                trace.logPerformance("Data import by " + key.toString(), System.currentTimeMillis() - startTime);
            }
            for (Runnable runnable2 : postImportTasks) {
                runnable2.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC).onImportFinished(projectData2 != null ? projectData2.getLinkedExternalProjectPath() : null);
            trace.logPerformance("Data import total", System.currentTimeMillis() - allStartTime);
        }
        catch (Throwable t) {
            try {
                ProjectDataManagerImpl.runFinalTasks(project2, synchronous, onFailureImportTasks);
                ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked(t);
            }
        }
        ProjectDataManagerImpl.runFinalTasks(project2, synchronous, onSuccessImportTasks);
    }

    private static void runFinalTasks(@NotNull Project project2, boolean synchronous, final List<Runnable> tasks) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(4);
        }
        DisposeAwareProjectChange runnable2 = new DisposeAwareProjectChange(project2){

            @Override
            public void execute() {
                for (Runnable task2 : ContainerUtil.reverse(tasks)) {
                    task2.run();
                }
            }
        };
        if (synchronous) {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            if (Character.isUpperCase(currChar)) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase(currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(8);
        }
        SmartList dummy = new SmartList();
        dummy.addAll(nodes);
        this.importData(dummy, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    @Override
    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(10);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(11);
        }
        SmartList dummy = new SmartList();
        dummy.add(node);
        this.importData(dummy, project2, modelsProvider, synchronous);
    }

    @Override
    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(13);
        }
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(14);
        }
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(16);
        }
        if (modifiableModelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(17);
        }
        if (postImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (onSuccessImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(19);
        }
        if (onFailureImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (project2.isDisposed()) {
            return;
        }
        SmartList toImport = new SmartList();
        SmartList toIgnore = new SmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals(node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List<ProjectDataService<?, ?>> services = this.myServices.getValue().get(key);
        if (services == null) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            for (ProjectDataService<?, ?> service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData(toImport, projectData2, project2, modifiableModelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData2 == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData(toImport, projectData2, project2, modifiableModelsProvider);
                service.removeData(orphanIdeDataComputable, toIgnore, projectData2, project2, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData2 != null) {
            postImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.postProcess(toImport, projectData2, project2, modifiableModelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.onFailureImport(project2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project2);
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.onSuccessImport(toImport, projectData2, project2, modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    @Override
    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null || startNode.isReady()) {
            return;
        }
        DeduplicateVisitorsSupplier supplier = new DeduplicateVisitorsSupplier();
        startNode.visit(dataNode -> {
            if (dataNode.validateData()) {
                dataNode.visitData(supplier.getVisitor(dataNode.getKey()));
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(21);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(23);
        }
        if (projectData2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(25);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(26);
        }
        try {
            List<ProjectDataService<?, ?>> services = this.myServices.getValue().get(key);
            for (ProjectDataService<?, ?> service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData(new Computable.PredefinedValueComputable<Collection<I>>(toRemove2), toIgnore, projectData2, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrow(t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project2, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(27);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(28);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(29);
        }
        if (projectData2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(30);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(31);
        }
        this.removeData(key, toRemove2, toIgnore, projectData2, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(32);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(33);
        }
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Override
    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(34);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(35);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(36);
        }
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @Override
    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(37);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(38);
        }
        if (!project2.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.$$$reportNull$$$0(39);
            }
            return collection;
        }
        List<ExternalProjectInfo> list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(40);
        }
        return list2;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(41);
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(42);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(43);
        }
        if (commitDesc == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(44);
        }
        ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project2){

            @Override
            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(45);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(46);
        }
        ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project2){

            @Override
            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 7: 
            case 15: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 25: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 11: 
            case 26: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runFinalTasks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

