/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ReprocessContentRootDataActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
public final class ReprocessContentRootDataActivity
implements StartupActivity.Background {
    private final Logger LOG;

    @Override
    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        if (ExternalSystemUtil.isNewProject(project2)) {
            this.LOG.info("Ignored reprocess of content root data service for new projects");
            return;
        }
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance(project2);
        if (sourceFolderManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerImpl");
        }
        SourceFolderManagerImpl instance2 = (SourceFolderManagerImpl)sourceFolderManager;
        instance2.rescanAndUpdateSourceFolders();
    }

    public ReprocessContentRootDataActivity() {
        Logger logger = Logger.getInstance(ReprocessContentRootDataActivity.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Repro\u2026DataActivity::class.java)");
        this.LOG = logger;
    }
}

