/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ProjectTopics;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerState;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderModelState;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="sourceFolderManager", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 92\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u00039:;B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010 2\u0006\u0010!\u001a\u00020\fJ\n\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0004H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010*\u001a\u00020\u0017J\b\u0010+\u001a\u00020\u0017H\u0002J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0002J\u0018\u00100\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010/\u001a\u00020\tH\u0016J\u001a\u00101\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\fH\u0016J.\u00103\u001a\u00020\u00172$\u00104\u001a \u0012\u0004\u0012\u00020\u0019\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u0012070605H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isDisposed", "", "moduleNamesToSourceFolderState", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderModelState;", "mutex", "", "sourceFolders", "Lcom/intellij/openapi/externalSystem/util/PathPrefixTreeMap;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "sourceFoldersByModule", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "addSourceFolder", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "addUrlToModuleModel", "dispose", "getSourceFolders", "", "moduleName", "getState", "listenToModuleAdded", "model", "loadSourceFolderState", "loadState", "state", "removeSourceFolder", "removeSourceFolders", "rescanAndUpdateSourceFolders", "resetModuleAddedListeners", "setForGeneratedSources", "folder", "Lcom/intellij/openapi/roots/SourceFolder;", "generated", "setSourceFolderGenerated", "setSourceFolderPackagePrefix", "packagePrefix", "updateSourceFolders", "sourceFoldersToChange", "", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "ModuleModel", "SourceFolderModel", "intellij.platform.externalSystem.impl"})
public final class SourceFolderManagerImpl
implements SourceFolderManager,
Disposable,
PersistentStateComponent<SourceFolderManagerState> {
    private final MultiMap<String, SourceFolderModelState> moduleNamesToSourceFolderState;
    private boolean isDisposed;
    private final Object mutex;
    private PathPrefixTreeMap<SourceFolderModel> sourceFolders;
    private THashMap<String, ModuleModel> sourceFoldersByModule;
    private final Project project;
    @NotNull
    private static final Map<String, JpsModuleSourceRootType<?>> dictionary;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceFolder(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.sourceFolders.set(url, new SourceFolderModel(module2, url, type, null, false, 24, null));
            this.addUrlToModuleModel(module2, url);
            Unit unit = Unit.INSTANCE;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(url){
            final /* synthetic */ String $url;

            public final void run() {
                VirtualFileManager.getInstance().refreshAndFindFileByUrl(this.$url);
            }
            {
                this.$url = string;
            }
        }, this.project.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSourceFolderPackagePrefix(@NotNull String url, @Nullable String packagePrefix) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.get((Object)url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            sourceFolder.setPackagePrefix(packagePrefix);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSourceFolderGenerated(@NotNull String url, boolean generated) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.get((Object)url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            sourceFolder.setGenerated(generated);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceFolders(@NotNull Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ModuleModel moduleModel = this.sourceFoldersByModule.remove(module2.getName());
            if (moduleModel == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleModel, (String)"sourceFoldersByModule.re\u2026ve(module.name) ?: return");
            ModuleModel moduleModel2 = moduleModel;
            Iterable $this$forEach$iv = moduleModel2.getSourceFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                this.sourceFolders.remove(it);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void dispose() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Source folder manager already disposed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.isDisposed = true;
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Set<String> getSourceFolders(@NotNull String moduleName) {
        Set<String> set;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ModuleModel moduleModel = this.sourceFoldersByModule.get(moduleName);
            set = moduleModel != null ? moduleModel.getSourceFolders() : null;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeSourceFolder(String url) {
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.remove(url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            Module module2 = sourceFolder.getModule();
            ModuleModel moduleModel = this.sourceFoldersByModule.get(module2.getName());
            if (moduleModel == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleModel, (String)"sourceFoldersByModule[module.name] ?: return");
            ModuleModel moduleModel2 = moduleModel;
            Set<String> sourceFolders2 = moduleModel2.getSourceFolders();
            sourceFolders2.remove(url);
            if (sourceFolders2.isEmpty()) {
                this.sourceFoldersByModule.remove(module2.getName());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rescanAndUpdateSourceFolders() {
        List list2;
        HashMap sourceFoldersToChange = new HashMap();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            list2 = (List)this.sourceFolders.values();
        }
        List values2 = list2;
        for (SourceFolderModel sourceFolder : values2) {
            VirtualFile sourceFolderFile = virtualFileManager2.refreshAndFindFileByUrl(sourceFolder.getUrl());
            if (sourceFolderFile != null && sourceFolderFile.isValid()) {
                ((ArrayList)sourceFoldersToChange.computeIfAbsent(sourceFolder.getModule(), rescanAndUpdateSourceFolders.1.INSTANCE)).add(new Pair((Object)sourceFolderFile, (Object)sourceFolder));
                this.removeSourceFolder(sourceFolder.getUrl());
            }
            this.updateSourceFolders(sourceFoldersToChange);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSourceFolders(Map<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> sourceFoldersToChange) {
        Object object = sourceFoldersToChange;
        boolean bl = false;
        Iterator<Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void module2;
            Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> entry;
            Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<? extends Pair<? extends VirtualFile, SourceFolderModel>> p = entry2.getValue();
            ModuleRootModificationUtil.updateModel((Module)module2, (Consumer<? super ModifiableRootModel>)new Consumer<ModifiableRootModel>(this, p){
                final /* synthetic */ SourceFolderManagerImpl this$0;
                final /* synthetic */ List $p;

                /*
                 * WARNING - void declaration
                 */
                public final void consume(ModifiableRootModel model) {
                    for (Pair pair : this.$p) {
                        SourceFolder sourceFolder;
                        void packagePrefix;
                        void type;
                        void url;
                        void eventFile;
                        SourceFolderModel sourceFolders2;
                        VirtualFile virtualFile2 = (VirtualFile)pair.component1();
                        SourceFolderModel sourceFolderModel = sourceFolders2 = (SourceFolderModel)pair.component2();
                        String string = sourceFolderModel.component2();
                        JpsModuleSourceRootType<?> jpsModuleSourceRootType = sourceFolderModel.component3();
                        String string2 = sourceFolderModel.component4();
                        boolean generated = sourceFolderModel.component5();
                        ContentEntry contentEntry = MarkRootActionBase.findContentEntry(model, (VirtualFile)eventFile);
                        if (contentEntry == null) {
                            contentEntry = model.addContentEntry((String)url);
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry, (String)"MarkRootActionBase.findC\u2026odel.addContentEntry(url)");
                        ContentEntry contentEntry2 = contentEntry;
                        Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry2.addSourceFolder((String)url, type), (String)"contentEntry.addSourceFolder(url, type)");
                        if (packagePrefix != null) {
                            CharSequence charSequence = (CharSequence)packagePrefix;
                            boolean bl = false;
                            if (charSequence.length() > 0) {
                                sourceFolder.setPackagePrefix((String)packagePrefix);
                            }
                        }
                        SourceFolderManagerImpl.access$setForGeneratedSources(this.this$0, sourceFolder, generated);
                    }
                }
                {
                    this.this$0 = sourceFolderManagerImpl;
                    this.$p = list2;
                }
            });
        }
    }

    private final void setForGeneratedSources(SourceFolder folder, boolean generated) {
        JpsModuleSourceRoot jpsModuleSourceRoot = folder.getJpsElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"folder.jpsElement");
        JpsModuleSourceRoot jpsElement = jpsModuleSourceRoot;
        JavaSourceRootProperties properties = (JavaSourceRootProperties)jpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
        if (properties != null) {
            properties.setForGeneratedSources(generated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public SourceFolderManagerState getState() {
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Collection<SourceFolderModelState> collection;
            void $this$mapTo$iv$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = this.sourceFolders.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SourceFolderModelState sourceFolderModelState;
                Object object2;
                Object v0;
                void model;
                block7: {
                    SourceFolderModel sourceFolderModel = (SourceFolderModel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    Iterable iterable2 = dictionary.entrySet();
                    boolean bl5 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl6 = false;
                    for (Object t : iterable3) {
                        Map.Entry it = (Map.Entry)t;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)((JpsModuleSourceRootType)it.getValue()), model.getType())) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                if ((object2 = (Map.Entry)v0) == null || (object2 = (String)object2.getKey()) == null) {
                    sourceFolderModelState = null;
                } else {
                    Object modelTypeName = object2;
                    String string = model.getModule().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"model.module.name");
                    sourceFolderModelState = new SourceFolderModelState(string, model.getUrl(), (String)modelTypeName, model.getPackagePrefix(), model.getGenerated());
                }
                SourceFolderModelState sourceFolderModelState2 = sourceFolderModelState;
                collection.add(sourceFolderModelState2);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = CollectionsKt.filterNotNull((Iterable)collection);
            SourceFolderManagerState sourceFolderManagerState = new SourceFolderManagerState(collection2);
            return sourceFolderManagerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull SourceFolderManagerState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.resetModuleAddedListeners();
            if (this.isDisposed) {
                return;
            }
            this.sourceFolders = new PathPrefixTreeMap(null, false, 3, null);
            this.sourceFoldersByModule = new THashMap();
            ModuleManager moduleManager = ModuleManager.getInstance(this.project);
            Iterable $this$forEach$iv = state.getSourceFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceFolderModelState model = (SourceFolderModelState)element$iv;
                boolean bl4 = false;
                Module module2 = moduleManager.findModuleByName(model.getModuleName());
                if (module2 == null) {
                    this.listenToModuleAdded(model);
                    continue;
                }
                this.loadSourceFolderState(model, module2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void resetModuleAddedListeners() {
        this.moduleNamesToSourceFolderState.clear();
    }

    private final void listenToModuleAdded(SourceFolderModelState model) {
        this.moduleNamesToSourceFolderState.putValue(model.getModuleName(), model);
    }

    private final void loadSourceFolderState(SourceFolderModelState model, Module module2) {
        JpsModuleSourceRootType<?> jpsModuleSourceRootType = dictionary.get(model.getType());
        if (jpsModuleSourceRootType == null) {
            return;
        }
        JpsModuleSourceRootType<?> rootType = jpsModuleSourceRootType;
        String url = model.getUrl();
        this.sourceFolders.set(url, new SourceFolderModel(module2, url, rootType, model.getPackagePrefix(), model.getGenerated()));
        this.addUrlToModuleModel(module2, url);
    }

    /*
     * WARNING - void declaration
     */
    private final void addUrlToModuleModel(Module module2, String url) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.sourceFoldersByModule;
        String key$iv = module2.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ModuleModel moduleModel = new ModuleModel(module2, null, 2, null);
            boolean bl2 = false;
            boolean bl3 = false;
            ModuleModel it = moduleModel;
            boolean bl4 = false;
            Disposer.register(module2, new Disposable(this, module2){
                final /* synthetic */ SourceFolderManagerImpl this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.this$0 = sourceFolderManagerImpl;
                    this.$module$inlined = module2;
                }

                public final void dispose() {
                    this.this$0.removeSourceFolders(this.$module$inlined);
                }
            });
            ModuleModel answer$iv = moduleModel;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ModuleModel moduleModel = (ModuleModel)object;
        moduleModel.getSourceFolders().add(url);
    }

    public SourceFolderManagerImpl(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"MultiMap.create()");
        this.moduleNamesToSourceFolderState = multiMap;
        this.mutex = new Object();
        this.sourceFolders = new PathPrefixTreeMap(null, false, 3, null);
        this.sourceFoldersByModule = new THashMap();
        this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                HashMap sourceFoldersToChange = new HashMap();
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
                VirtualFileManager virtualFileManager2 = virtualFileManager;
                for (VFileEvent vFileEvent : events) {
                    Set set;
                    if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                    Object object = mutex;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        PathPrefixTreeMap pathPrefixTreeMap = sourceFolders;
                        String string = VfsUtilCore.pathToUrl(((VFileCreateEvent)vFileEvent).getPath());
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.pathToUrl(event.path)");
                        set = pathPrefixTreeMap.getAllDescendantValues(string);
                    }
                    Set allDescendantValues = set;
                    for (SourceFolderModel sourceFolder : allDescendantValues) {
                        VirtualFile sourceFolderFile = virtualFileManager2.refreshAndFindFileByUrl(sourceFolder.getUrl());
                        if (sourceFolderFile == null || !sourceFolderFile.isValid()) continue;
                        ArrayList arrayList = (ArrayList)sourceFoldersToChange.computeIfAbsent(sourceFolder.getModule(), after.1.INSTANCE);
                        VirtualFile virtualFile2 = ((VFileCreateEvent)vFileEvent).getFile();
                        if (virtualFile2 == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList.add(new Pair((Object)virtualFile2, (Object)sourceFolder));
                        this.removeSourceFolder(sourceFolder.getUrl());
                    }
                }
                this.updateSourceFolders(sourceFoldersToChange);
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, new ModuleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                Object object = mutex;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    Collection collection = moduleNamesToSourceFolderState.get(module2.getName());
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"moduleNamesToSourceFolderState[module.name]");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SourceFolderModelState it = (SourceFolderModelState)element$iv;
                        boolean bl4 = false;
                        SourceFolderModelState sourceFolderModelState = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolderModelState, (String)"it");
                        this.loadSourceFolderState(sourceFolderModelState, module2);
                    }
                    Collection collection2 = moduleNamesToSourceFolderState.remove(module2.getName());
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        dictionary = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"SOURCE", (Object)JavaSourceRootType.SOURCE), TuplesKt.to((Object)"TEST_SOURCE", (Object)JavaSourceRootType.TEST_SOURCE), TuplesKt.to((Object)"RESOURCE", (Object)JavaResourceRootType.RESOURCE), TuplesKt.to((Object)"TEST_RESOURCE", (Object)JavaResourceRootType.TEST_RESOURCE)});
    }

    public static final /* synthetic */ void access$setForGeneratedSources(SourceFolderManagerImpl $this, SourceFolder folder, boolean generated) {
        $this.setForGeneratedSources(folder, generated);
    }

    public static final /* synthetic */ void access$setSourceFolders$p(SourceFolderManagerImpl $this, PathPrefixTreeMap pathPrefixTreeMap) {
        $this.sourceFolders = pathPrefixTreeMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "packagePrefix", "generated", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Ljava/lang/String;Z)V", "getGenerated", "()Z", "setGenerated", "(Z)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPackagePrefix", "()Ljava/lang/String;", "setPackagePrefix", "(Ljava/lang/String;)V", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getUrl", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class SourceFolderModel {
        @NotNull
        private final Module module;
        @NotNull
        private final String url;
        @NotNull
        private final JpsModuleSourceRootType<?> type;
        @Nullable
        private String packagePrefix;
        private boolean generated;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        public final void setPackagePrefix(@Nullable String string) {
            this.packagePrefix = string;
        }

        public final boolean getGenerated() {
            return this.generated;
        }

        public final void setGenerated(boolean bl) {
            this.generated = bl;
        }

        public SourceFolderModel(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @Nullable String packagePrefix, boolean generated) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            this.module = module2;
            this.url = url;
            this.type = type;
            this.packagePrefix = packagePrefix;
            this.generated = generated;
        }

        public /* synthetic */ SourceFolderModel(Module module2, String string, JpsModuleSourceRootType jpsModuleSourceRootType, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(module2, string, jpsModuleSourceRootType, string2, bl);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> component3() {
            return this.type;
        }

        @Nullable
        public final String component4() {
            return this.packagePrefix;
        }

        public final boolean component5() {
            return this.generated;
        }

        @NotNull
        public final SourceFolderModel copy(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @Nullable String packagePrefix, boolean generated) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            return new SourceFolderModel(module2, url, type, packagePrefix, generated);
        }

        public static /* synthetic */ SourceFolderModel copy$default(SourceFolderModel sourceFolderModel, Module module2, String string, JpsModuleSourceRootType jpsModuleSourceRootType, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                module2 = sourceFolderModel.module;
            }
            if ((n & 2) != 0) {
                string = sourceFolderModel.url;
            }
            if ((n & 4) != 0) {
                jpsModuleSourceRootType = sourceFolderModel.type;
            }
            if ((n & 8) != 0) {
                string2 = sourceFolderModel.packagePrefix;
            }
            if ((n & 0x10) != 0) {
                bl = sourceFolderModel.generated;
            }
            return sourceFolderModel.copy(module2, string, jpsModuleSourceRootType, string2, bl);
        }

        @NotNull
        public String toString() {
            return "SourceFolderModel(module=" + this.module + ", url=" + this.url + ", type=" + this.type + ", packagePrefix=" + this.packagePrefix + ", generated=" + this.generated + ")";
        }

        public int hashCode() {
            Module module2 = this.module;
            String string = this.url;
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = this.type;
            String string2 = this.packagePrefix;
            int n = ((((module2 != null ? module2.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (jpsModuleSourceRootType != null ? jpsModuleSourceRootType.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.generated ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceFolderModel)) break block3;
                    SourceFolderModel sourceFolderModel = (SourceFolderModel)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)sourceFolderModel.module) || !Intrinsics.areEqual((Object)this.url, (Object)sourceFolderModel.url) || !Intrinsics.areEqual(this.type, sourceFolderModel.type) || !Intrinsics.areEqual((Object)this.packagePrefix, (Object)sourceFolderModel.packagePrefix) || this.generated != sourceFolderModel.generated) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "sourceFolders", "", "", "(Lcom/intellij/openapi/module/Module;Ljava/util/Set;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getSourceFolders", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class ModuleModel {
        @NotNull
        private final Module module;
        @NotNull
        private final Set<String> sourceFolders;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final Set<String> getSourceFolders() {
            return this.sourceFolders;
        }

        public ModuleModel(@NotNull Module module2, @NotNull Set<String> sourceFolders2) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull(sourceFolders2, (String)"sourceFolders");
            this.module = module2;
            this.sourceFolders = sourceFolders2;
        }

        public /* synthetic */ ModuleModel(Module module2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
            }
            this(module2, set);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final Set<String> component2() {
            return this.sourceFolders;
        }

        @NotNull
        public final ModuleModel copy(@NotNull Module module2, @NotNull Set<String> sourceFolders2) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull(sourceFolders2, (String)"sourceFolders");
            return new ModuleModel(module2, sourceFolders2);
        }

        public static /* synthetic */ ModuleModel copy$default(ModuleModel moduleModel, Module module2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                module2 = moduleModel.module;
            }
            if ((n & 2) != 0) {
                set = moduleModel.sourceFolders;
            }
            return moduleModel.copy(module2, set);
        }

        @NotNull
        public String toString() {
            return "ModuleModel(module=" + this.module + ", sourceFolders=" + this.sourceFolders + ")";
        }

        public int hashCode() {
            Module module2 = this.module;
            Set<String> set = this.sourceFolders;
            return (module2 != null ? module2.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleModel)) break block3;
                    ModuleModel moduleModel = (ModuleModel)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)moduleModel.module) || !Intrinsics.areEqual(this.sourceFolders, moduleModel.sourceFolders)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$Companion;", "", "()V", "dictionary", "", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getDictionary", "()Ljava/util/Map;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final Map<String, JpsModuleSourceRootType<?>> getDictionary() {
            return dictionary;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

