/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleConfigurationImporter;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleImporterExtensionManager;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/CodeStyleConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "importCommonSettings", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "langCfg", "", "ForceEnum", "intellij.platform.externalSystem.impl"})
public final class CodeStyleConfigurationHandler
implements ConfigurationHandler {
    @Override
    public void apply(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Map map2;
        CodeStyleSettings styleSettings;
        CodeStyleScheme importedScheme;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String importedSchemeName = "Gradle Imported";
        Object object = configuration.find("codeStyle");
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map3 = (Map)object;
        if (map3 == null) {
            return;
        }
        Map codeStyleSettings = map3;
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        CodeStyleScheme codeStyleScheme = schemes.findPreferredScheme(importedSchemeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleScheme, (String)"schemes.findPreferredScheme(importedSchemeName)");
        CodeStyleScheme existingScheme = codeStyleScheme;
        if (Intrinsics.areEqual((Object)existingScheme.getName(), (Object)importedSchemeName)) {
            schemes.deleteScheme(existingScheme);
        }
        CodeStyleSchemes codeStyleSchemes = schemes;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSchemes, (String)"schemes");
        CodeStyleScheme codeStyleScheme2 = importedScheme = schemes.createNewScheme(importedSchemeName, codeStyleSchemes.getDefaultScheme());
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleScheme2, (String)"importedScheme");
        CodeStyleSettings codeStyleSettings2 = codeStyleScheme2.getCodeStyleSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings2, (String)"importedScheme.codeStyleSettings");
        CodeStyleSettings codeStyleSettings3 = styleSettings = codeStyleSettings2;
        boolean bl = false;
        boolean bl2 = false;
        CodeStyleSettings $this$apply = codeStyleSettings3;
        boolean bl3 = false;
        ObjectUtils.consumeIfCast(codeStyleSettings.get("USE_SAME_INDENTS"), Boolean.TYPE, new Consumer<T>($this$apply){
            final /* synthetic */ CodeStyleSettings $this_apply;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.$this_apply.USE_SAME_INDENTS = bl;
            }
            {
                this.$this_apply = codeStyleSettings;
            }
        });
        ObjectUtils.consumeIfCast(codeStyleSettings.get("RIGHT_MARGIN"), Number.class, new Consumer<T>($this$apply){
            final /* synthetic */ CodeStyleSettings $this_apply;

            public final void consume(Number it) {
                this.$this_apply.setDefaultRightMargin(it.intValue());
            }
            {
                this.$this_apply = codeStyleSettings;
            }
        });
        ObjectUtils.consumeIfCast(codeStyleSettings.get("KEEP_CONTROL_STATEMENT_IN_ONE_LINE"), Boolean.TYPE, new Consumer<T>($this$apply){
            final /* synthetic */ CodeStyleSettings $this_apply;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.$this_apply.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = bl;
            }
            {
                this.$this_apply = codeStyleSettings;
            }
        });
        List languages = CollectionsKt.listOf((Object[])new String[]{"java", "groovy"});
        Object v = codeStyleSettings.get("languages");
        if (!(v instanceof Map)) {
            v = null;
        }
        if ((map2 = (Map)v) == null) {
            bl2 = false;
            map2 = MapsKt.emptyMap();
        }
        Map importedLangs = map2;
        Iterable $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String langName = (String)element$iv;
            boolean bl4 = false;
            ObjectUtils.consumeIfCast(importedLangs.get(langName), Map.class, new Consumer<T>(langName, this, importedLangs, styleSettings){
                final /* synthetic */ String $langName;
                final /* synthetic */ CodeStyleConfigurationHandler this$0;
                final /* synthetic */ Map $importedLangs$inlined;
                final /* synthetic */ CodeStyleSettings $styleSettings$inlined;
                {
                    this.$langName = string;
                    this.this$0 = codeStyleConfigurationHandler;
                    this.$importedLangs$inlined = map2;
                    this.$styleSettings$inlined = codeStyleSettings;
                }

                public final void consume(Map<?, ?> langCfg) {
                    CodeStyleConfigurationImporter<CustomCodeStyleSettings> importer = CodeStyleImporterExtensionManager.Companion.importerForLang(this.$langName);
                    if (importer != null) {
                        CommonCodeStyleSettings commonCodeStyleSettings = this.$styleSettings$inlined.getCommonSettings(importer.getLanguage());
                        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"styleSettings.getCommonSettings(importer.language)");
                        Map<?, ?> map2 = langCfg;
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"langCfg");
                        CodeStyleConfigurationHandler.access$importCommonSettings(this.this$0, commonCodeStyleSettings, map2);
                        importer.processSettings(this.$styleSettings$inlined.getCustomSettings(importer.getCustomClass()), langCfg);
                    }
                }
            });
        }
        schemes.addScheme(importedScheme);
        schemes.setCurrentScheme(importedScheme);
    }

    private final void importCommonSettings(CommonCodeStyleSettings commonSettings, Map<?, ?> langCfg) {
        CommonCodeStyleSettings commonCodeStyleSettings = commonSettings;
        boolean bl = false;
        boolean bl2 = false;
        CommonCodeStyleSettings $this$apply = commonCodeStyleSettings;
        boolean bl3 = false;
        Map<?, ?> map2 = langCfg;
        String string = "RIGHT_MARGIN";
        boolean bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), Number.class, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(Number it) {
                this.$this_apply.RIGHT_MARGIN = it.intValue();
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "WRAP_COMMENTS";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), Boolean.TYPE, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.$this_apply.WRAP_COMMENTS = bl;
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "IF_BRACE_FORCE";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), String.class, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.$this_apply.IF_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "DOWHILE_BRACE_FORCE";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), String.class, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.$this_apply.DOWHILE_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "WHILE_BRACE_FORCE";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), String.class, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.$this_apply.WHILE_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "FOR_BRACE_FORCE";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), String.class, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.$this_apply.FOR_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
        map2 = langCfg;
        string = "KEEP_CONTROL_STATEMENT_IN_ONE_LINE";
        bl4 = false;
        ObjectUtils.consumeIfCast(map2.get(string), Boolean.TYPE, new Consumer<T>($this$apply){
            final /* synthetic */ CommonCodeStyleSettings $this_apply;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.$this_apply.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = bl;
            }
            {
                this.$this_apply = commonCodeStyleSettings;
            }
        });
    }

    public static final /* synthetic */ void access$importCommonSettings(CodeStyleConfigurationHandler $this, CommonCodeStyleSettings commonSettings, Map langCfg) {
        $this.importCommonSettings(commonSettings, langCfg);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/CodeStyleConfigurationHandler$ForceEnum;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "DO_NOT_FORCE", "FORCE_BRACES_IF_MULTILINE", "FORCE_BRACES_ALWAYS", "intellij.platform.externalSystem.impl"})
    public static final class ForceEnum
    extends Enum<ForceEnum> {
        public static final /* enum */ ForceEnum DO_NOT_FORCE;
        public static final /* enum */ ForceEnum FORCE_BRACES_IF_MULTILINE;
        public static final /* enum */ ForceEnum FORCE_BRACES_ALWAYS;
        private static final /* synthetic */ ForceEnum[] $VALUES;
        private final int index;

        static {
            ForceEnum[] forceEnumArray = new ForceEnum[3];
            ForceEnum[] forceEnumArray2 = forceEnumArray;
            forceEnumArray[0] = DO_NOT_FORCE = new ForceEnum(0);
            forceEnumArray[1] = FORCE_BRACES_IF_MULTILINE = new ForceEnum(1);
            forceEnumArray[2] = FORCE_BRACES_ALWAYS = new ForceEnum(3);
            $VALUES = forceEnumArray;
        }

        public final int getIndex() {
            return this.index;
        }

        private ForceEnum(int index) {
            this.index = index;
        }

        public static ForceEnum[] values() {
            return (ForceEnum[])$VALUES.clone();
        }

        public static ForceEnum valueOf(String string) {
            return Enum.valueOf(ForceEnum.class, string);
        }
    }
}

