/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J6\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "onSuccessImport", "imported", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public final class ConfigurationDataService
extends AbstractProjectDataService<ConfigurationData, Void> {
    private static final Logger LOG;
    @NotNull
    public static final String EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED = "external.system.configuration.import.enabled";
    public static final Companion Companion;

    @Override
    @NotNull
    public Key<ConfigurationData> getTargetDataKey() {
        Key<ConfigurationData> key = ProjectKeys.CONFIGURATION;
        Intrinsics.checkExpressionValueIsNotNull(key, (String)"ProjectKeys.CONFIGURATION");
        return key;
    }

    @Override
    public void importData(@NotNull Collection<? extends DataNode<ConfigurationData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        ConfigurationDataService.Companion.withConfigurationData(toImport, projectData2, project2, modelsProvider, importData.1.INSTANCE, importData.2.INSTANCE);
    }

    @Override
    public void onSuccessImport(@NotNull Collection<? extends DataNode<ConfigurationData>> imported, @Nullable ProjectData projectData2, @NotNull Project project2, @NotNull IdeModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(imported, (String)"imported");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        ConfigurationDataService.Companion.withConfigurationData(imported, projectData2, project2, modelsProvider, onSuccessImport.1.INSTANCE, onSuccessImport.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ConfigurationDataService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Confi\u2026nDataService::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00a3\u0001\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\n21\u0010\u0015\u001a-\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u00182)\u0010\u0019\u001a%\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u001a\u00a2\u0006\u0002\b\u0018H\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService$Companion;", "", "()V", "EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "withConfigurationData", "", "ModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "configurationData", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "acceptProject", "Lkotlin/Function5;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "Lkotlin/ExtensionFunctionType;", "acceptModule", "Lkotlin/Function4;", "Lcom/intellij/openapi/module/Module;", "(Ljava/util/Collection;Lcom/intellij/openapi/externalSystem/model/project/ProjectData;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function4;)V", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private final <ModelsProvider extends IdeModelsProvider> void withConfigurationData(Collection<? extends DataNode<ConfigurationData>> configurationData, ProjectData projectData2, Project project2, ModelsProvider modelsProvider, Function5<? super ConfigurationHandler, ? super Project, ? super ProjectData, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptProject, Function4<? super ConfigurationHandler, ? super Module, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptModule) {
            if (configurationData.isEmpty() || !Registry.is(ConfigurationDataService.EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED)) {
                LOG.debug("Configuration data is" + (!configurationData.isEmpty() ? " not " : " ") + "empty, Registry flag is " + Registry.is(ConfigurationDataService.EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED));
                return;
            }
            DataNode<ConfigurationData> javaProjectDataNode = configurationData.iterator().next();
            DataNode<ProjectData> dataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, ProjectKeys.PROJECT);
            if (dataNode == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(dataNode, (String)"ExternalSystemApiUtil.fi\u2026e, ProjectKeys.PROJECT)!!");
            DataNode<ProjectData> projectDataNode = dataNode;
            DataNode<ConfigurationData> projectConfigurationNode = ExternalSystemApiUtil.find(projectDataNode, ProjectKeys.CONFIGURATION);
            if (projectConfigurationNode != null) {
                ConfigurationData configurationData2 = projectConfigurationNode.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationData2, (String)"projectConfigurationNode.data");
                ConfigurationData configurationData3 = configurationData2;
                if (LOG.isDebugEnabled() && configurationData3 instanceof ConfigurationDataImpl) {
                    LOG.debug("Importing project configuration: " + ((ConfigurationDataImpl)configurationData3).getJsonString());
                }
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                if (!ExternalSystemApiUtil.isOneToOneMapping(project2, projectDataNode.getData(), moduleManager.getModules())) {
                    LOG.warn("This external project are not the only project in the current IDE workspace, found project level configuration can override the configuration came from other external projects.");
                }
                ExtensionPointName<ConfigurationHandler> extensionPointName = ConfigurationHandler.EP_NAME;
                Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ConfigurationHandler.EP_NAME");
                ConfigurationHandler[] configurationHandlerArray = extensionPointName.getExtensions();
                int n = configurationHandlerArray.length;
                for (int i = 0; i < n; ++i) {
                    ConfigurationHandler handler2;
                    ConfigurationHandler configurationHandler = handler2 = configurationHandlerArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationHandler, (String)"handler");
                    acceptProject.invoke((Object)configurationHandler, (Object)project2, (Object)projectData2, modelsProvider, (Object)configurationData3);
                }
            }
            for (DataNode<ConfigurationData> dataNode2 : configurationData) {
                ConfigurationData data3;
                DataNode<ModuleData> moduleDataNode;
                if (dataNode2 == projectConfigurationNode || (moduleDataNode = ExternalSystemApiUtil.findParent(dataNode2, ProjectKeys.MODULE)) == null) continue;
                Module module2 = moduleDataNode.getUserData(AbstractModuleDataService.MODULE_KEY);
                Module module3 = module2;
                if (module3 == null) {
                    module3 = module2 = modelsProvider.findIdeModule(moduleDataNode.getData());
                }
                if (module2 == null) {
                    String string;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "Can't import module level configuration. Reason: target module (%s) is not found at the ide";
                    Object[] objectArray = new Object[]{moduleDataNode};
                    Logger logger = LOG;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    logger.warn(string);
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2.getData(), (String)"node.data");
                if (LOG.isDebugEnabled() && data3 instanceof ConfigurationDataImpl) {
                    LOG.debug("Importing module configuration: " + ((ConfigurationDataImpl)data3).getJsonString());
                }
                ExtensionPointName<ConfigurationHandler> extensionPointName = ConfigurationHandler.EP_NAME;
                Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ConfigurationHandler.EP_NAME");
                ConfigurationHandler[] configurationHandlerArray = extensionPointName.getExtensions();
                int n = configurationHandlerArray.length;
                for (int i = 0; i < n; ++i) {
                    ConfigurationHandler handler3;
                    ConfigurationHandler configurationHandler = handler3 = configurationHandlerArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationHandler, (String)"handler");
                    acceptModule.invoke((Object)configurationHandler, (Object)module2, modelsProvider, (Object)data3);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

