/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizerImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.BooleanValueHolder;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectDataSelectorDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 50;
    private static final Set<? extends Key<?>> DATA_KEYS = ContainerUtil.set(ProjectKeys.PROJECT, ProjectKeys.MODULE);
    private static final com.intellij.openapi.util.Key<DataNode> MODIFIED_NODE_KEY = com.intellij.openapi.util.Key.create("modifiedData");
    private static final com.intellij.openapi.util.Key<DataNodeCheckedTreeNode> CONNECTED_UI_NODE_KEY = com.intellij.openapi.util.Key.create("connectedUiNode");
    @NotNull
    private final Project myProject;
    private JBLoadingPanel loadingPanel;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JBLabel myDescriptionLbl;
    private JBLabel mySelectionStatusLbl;
    private ExternalSystemUiAware myExternalSystemUiAware;
    private ExternalProjectInfo myProjectInfo;
    private final Set<Key<?>> myIgnorableKeys;
    private final Set<Key<?>> myPublicKeys;
    private final Set<Key<? extends Identifiable>> myDependencyAwareDataKeys;
    @Nullable
    private final Object myPreselectedNodeObject;
    private CheckboxTree myTree;
    private final MultiMap<DataNode<Identifiable>, DataNode<Identifiable>> dependentNodeMap;
    private final SimpleModificationTracker myModificationTracker;
    private final CachedValue<SelectionState> selectionState;
    private boolean myShowSelectedRowsOnly;
    private int myModulesCount;

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo projectInfo) {
        if (project2 == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(0);
        }
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(1);
        }
        this(project2, projectInfo, null);
    }

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo projectInfo, @Nullable Object preselectedNodeDataObject) {
        if (project2 == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(3);
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.dependentNodeMap = MultiMap.create(TObjectHashingStrategy.IDENTITY);
        this.myModificationTracker = new SimpleModificationTracker();
        this.selectionState = new CachedValueImpl<SelectionState>(() -> CachedValueProvider.Result.createSingleDependency(this.getSelectionStatus(), this.myModificationTracker));
        this.myProject = project2;
        this.myIgnorableKeys = ExternalProjectDataSelectorDialog.getIgnorableKeys();
        this.myPublicKeys = ExternalProjectDataSelectorDialog.getPublicKeys();
        this.myDependencyAwareDataKeys = ExternalProjectDataSelectorDialog.getDependencyAwareDataKeys();
        this.myPreselectedNodeObject = preselectedNodeDataObject;
        this.init(projectInfo);
    }

    private void init(@NotNull ExternalProjectInfo projectInfo) {
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(4);
        }
        this.myProjectInfo = projectInfo;
        this.myExternalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.myProjectInfo.getProjectSystemId());
        this.myTree = this.createTree();
        this.updateSelectionState();
        this.myTree.addCheckboxTreeListener(new CheckboxTreeListener(){

            @Override
            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalProjectDataSelectorDialog.this.updateSelectionState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$1", "nodeStateChanged"));
            }
        });
        String externalSystemName = this.myProjectInfo.getProjectSystemId().getReadableName();
        this.setTitle(String.format("%s Project Data To Import", externalSystemName));
        this.init();
    }

    public boolean hasMultipleDataToSelect() {
        return this.myModulesCount > 1;
    }

    private void updateSelectionState() {
        this.myModificationTracker.incModificationCount();
        this.mySelectionStatusLbl.setText(this.selectionState.getValue().message);
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree).addExtraAction(new SelectAllButton()).addExtraAction(new UnselectAllButton()).addExtraAction(new ShowSelectedOnlyButton()).addExtraAction(new SelectRequiredButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM);
        this.contentPanel.add(decorator.createPanel());
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.loadingPanel.add((Component)this.mainPanel, "Center");
        return this.loadingPanel;
    }

    private void reloadTree() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        Object root = treeModel.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        CheckedTreeNode rootNode = (CheckedTreeNode)root;
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode rootCopy = (CheckedTreeNode)rootAndPreselectedNode.first;
        List<TreeNode> nodes = TreeUtil.listChildren(rootCopy);
        rootNode.removeAllChildren();
        TreeUtil.addChildrenTo(rootNode, nodes);
        treeModel.reload();
    }

    @Override
    protected void doOKAction() {
        this.loadingPanel.setLoadingText("Please wait...");
        this.loadingPanel.startLoading();
        final DataNode<ProjectData> projectStructure = this.myProjectInfo.getExternalProjectStructure();
        if (projectStructure != null) {
            boolean[] isModified = new boolean[]{false};
            projectStructure.visit(node -> {
                DataNode modifiedDataNode = node.getUserData(MODIFIED_NODE_KEY);
                if (modifiedDataNode != null) {
                    if (node.isIgnored() != modifiedDataNode.isIgnored()) {
                        node.setIgnored(modifiedDataNode.isIgnored());
                        isModified[0] = true;
                    }
                    node.removeUserData(MODIFIED_NODE_KEY);
                    node.removeUserData(CONNECTED_UI_NODE_KEY);
                }
            });
            if (isModified[0]) {
                DataNode notIgnoredNode = (DataNode)((Object)ContainerUtil.find(projectStructure.getChildren(), node -> !node.isIgnored()));
                projectStructure.setIgnored(notIgnoredNode == null);
                ExternalSystemUtil.invokeLater(this.myProject, ModalityState.NON_MODAL, () -> {
                    ProjectData projectData2 = (ProjectData)projectStructure.getData();
                    String title = ExternalSystemBundle.message("progress.refresh.text", projectData2.getExternalName(), projectData2.getOwner().getReadableName());
                    new Task.Backgroundable(this.myProject, title, true, PerformInBackgroundOption.DEAF){

                        @Override
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            ServiceManager.getService(ProjectDataManager.class).importData(projectStructure, this.myProject, false);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$2", "run"));
                        }
                    }.queue();
                });
            }
        }
        super.doOKAction();
    }

    @Override
    public void doCancelAction() {
        ExternalSystemApiUtil.visit(this.myProjectInfo.getExternalProjectStructure(), node -> {
            node.removeUserData(MODIFIED_NODE_KEY);
            node.removeUserData(CONNECTED_UI_NODE_KEY);
        });
        super.doCancelAction();
    }

    private CheckboxTree createTree() {
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode root = (CheckedTreeNode)rootAndPreselectedNode.first;
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            @Override
            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof DataNodeCheckedTreeNode)) {
                    return;
                }
                DataNodeCheckedTreeNode node = (DataNodeCheckedTreeNode)value2;
                String tooltip = null;
                boolean hasErrors = false;
                if (node.isChecked()) {
                    String listOfUncheckedDependencies;
                    Enumeration<TreeNode> children2 = node.children();
                    while (children2.hasMoreElements()) {
                        TreeNode o = children2.nextElement();
                        if (!(o instanceof DataNodeCheckedTreeNode) || ((DataNodeCheckedTreeNode)o).isChecked()) continue;
                        this.myCheckbox.setEnabled(false);
                        break;
                    }
                    if (ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && StringUtil.isNotEmpty(listOfUncheckedDependencies = StringUtil.join(ExternalProjectDataSelectorDialog.this.dependentNodeMap.get(node.myDataNode), depNode -> {
                        DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)depNode.getUserData(CONNECTED_UI_NODE_KEY);
                        return uiNode != null && !uiNode.isChecked() ? ((Identifiable)depNode.getData()).getId() : null;
                    }, "<br>"))) {
                        hasErrors = true;
                        tooltip = "There are not selected module dependencies of the module: <br><b>" + listOfUncheckedDependencies + "</b>";
                    }
                }
                ColoredTreeCellRenderer renderer = this.getTextRenderer();
                renderer.setIcon(node.icon);
                renderer.append(node.text, hasErrors ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!StringUtil.isEmptyOrSpaces(node.comment)) {
                    String description = node.comment;
                    if (node.comment.length() > 50) {
                        description = node.comment.substring(0, 50) + "...";
                    }
                    renderer.append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setToolTipText(StringUtil.isEmpty(tooltip) ? node.comment : tooltip);
                } else {
                    this.setToolTipText(StringUtil.isNotEmpty(tooltip) ? tooltip : null);
                }
            }
        }, root, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        TreeUtil.expand(tree, 1);
        if (rootAndPreselectedNode.second != null) {
            TreeUtil.selectNode(tree, (TreeNode)rootAndPreselectedNode.second);
        } else {
            tree.setSelectionRow(0);
        }
        return tree;
    }

    private Couple<CheckedTreeNode> createRoot() {
        THashMap treeNodeMap = ContainerUtil.newIdentityTroveMap();
        TreeMap ideGroupingMap = new TreeMap();
        DataNodeCheckedTreeNode[] preselectedNode = new DataNodeCheckedTreeNode[]{null};
        DataNodeCheckedTreeNode[] rootModuleNode = new DataNodeCheckedTreeNode[]{null};
        MultiMap<String, String> moduleDependenciesMap = MultiMap.create();
        HashMap modulesNodeMap = new HashMap();
        for (DataNode<ModuleDependencyData> dataNode : ExternalSystemApiUtil.findAllRecursively(this.myProjectInfo.getExternalProjectStructure(), ProjectKeys.MODULE_DEPENDENCY)) {
            ModuleDependencyData moduleDependencyData = dataNode.getData();
            moduleDependenciesMap.putValue(moduleDependencyData.getOwnerModule().getId(), ((ModuleData)moduleDependencyData.getTarget()).getId());
        }
        int[] modulesCount = new int[]{0};
        ExternalSystemApiUtil.visit(this.myProjectInfo.getExternalProjectStructure(), node -> {
            Key key = node.getKey();
            if (!this.myPublicKeys.contains(key)) {
                return;
            }
            DataNode modifiableDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(node);
            if (this.myDependencyAwareDataKeys.contains(key)) {
                modulesCount[0] = modulesCount[0] + 1;
            }
            if (modifiableDataNode.isIgnored() && this.myShowSelectedRowsOnly) {
                return;
            }
            DataNodeCheckedTreeNode treeNode = (DataNodeCheckedTreeNode)treeNodeMap.get(node);
            if (treeNode == null) {
                Identifiable moduleData;
                treeNode = new DataNodeCheckedTreeNode((DataNode)node);
                if (this.myDependencyAwareDataKeys.contains(key)) {
                    moduleData = (Identifiable)node.getData();
                    modulesNodeMap.put(moduleData.getId(), node);
                }
                if (this.myPreselectedNodeObject != null && this.myPreselectedNodeObject.equals(node.getData())) {
                    preselectedNode[0] = treeNode;
                }
                if (node.getData() instanceof ModuleData) {
                    String ideGrouping;
                    moduleData = (ModuleData)node.getData();
                    if (key.equals(ProjectKeys.MODULE) && this.myProjectInfo.getExternalProjectPath().equals(((ModuleData)moduleData).getLinkedExternalProjectPath())) {
                        rootModuleNode[0] = treeNode;
                    }
                    if ((ideGrouping = ((ModuleData)moduleData).getIdeGrouping()) != null) {
                        ideGroupingMap.put(ideGrouping, node);
                    }
                } else {
                    DataNodeCheckedTreeNode moduleTreeNode;
                    DataNode<ModuleData> parentModule = node.getParent(ModuleData.class);
                    if (parentModule != null && (moduleTreeNode = (DataNodeCheckedTreeNode)treeNodeMap.get(parentModule)) != null) {
                        moduleTreeNode.add(treeNode);
                        treeNode.setParent(moduleTreeNode);
                    }
                }
                treeNode.setEnabled(this.myIgnorableKeys.contains(key));
                treeNodeMap.put(node, treeNode);
            }
        });
        for (Map.Entry entry : ideGroupingMap.entrySet()) {
            DataNode node2 = (DataNode)entry.getValue();
            if (!(node2.getData() instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)node2.getData();
            String ideParentGrouping = moduleData.getIdeParentGrouping();
            DataNode structuralParent = ideParentGrouping != null ? (DataNode)ideGroupingMap.get(ideParentGrouping) : null;
            DataNodeCheckedTreeNode treeParentNode = structuralParent != null ? (DataNodeCheckedTreeNode)treeNodeMap.get(structuralParent) : null;
            DataNodeCheckedTreeNode treeNode = (DataNodeCheckedTreeNode)treeNodeMap.get(node2);
            if (treeParentNode == null) {
                treeParentNode = (DataNodeCheckedTreeNode)treeNodeMap.get(node2.getParent());
            }
            if (treeNode == null || treeParentNode == null) continue;
            treeParentNode.add(treeNode);
            treeNode.setParent(treeParentNode);
        }
        this.myModulesCount = modulesCount[0];
        this.dependentNodeMap.clear();
        for (String string : moduleDependenciesMap.keySet()) {
            Collection moduleDependencies = moduleDependenciesMap.get(string);
            DataNode moduleNode = (DataNode)modulesNodeMap.get(string);
            if (moduleNode == null) continue;
            this.dependentNodeMap.putValues(moduleNode, ContainerUtil.mapNotNull(moduleDependencies, modulesNodeMap::get));
        }
        CheckedTreeNode checkedTreeNode = new CheckedTreeNode(null);
        DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)treeNodeMap.get(this.myProjectInfo.getExternalProjectStructure());
        String rootModuleComment = "root module";
        if (rootModuleNode[0] != null && dataNodeCheckedTreeNode != null) {
            rootModuleNode[0].comment = rootModuleComment;
            if (!dataNodeCheckedTreeNode.isNodeChild(rootModuleNode[0])) {
                dataNodeCheckedTreeNode.add(rootModuleNode[0]);
            }
        }
        List<Object> nodes = dataNodeCheckedTreeNode != null ? TreeUtil.listChildren(dataNodeCheckedTreeNode) : ContainerUtil.emptyList();
        Collections.sort(nodes, (o1, o2) -> {
            if (o1 instanceof DataNodeCheckedTreeNode && o2 instanceof DataNodeCheckedTreeNode) {
                if (rootModuleComment.equals(((DataNodeCheckedTreeNode)o1).comment)) {
                    return -1;
                }
                if (rootModuleComment.equals(((DataNodeCheckedTreeNode)o2).comment)) {
                    return 1;
                }
                return StringUtil.naturalCompare(((DataNodeCheckedTreeNode)o1).text, ((DataNodeCheckedTreeNode)o2).text);
            }
            return 0;
        });
        TreeUtil.addChildrenTo(checkedTreeNode, nodes);
        return Couple.of(checkedTreeNode, preselectedNode[0]);
    }

    @NotNull
    private static Set<Key<?>> getPublicKeys() {
        HashSet result2 = new HashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getPublicDataKeys());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<?>> getIgnorableKeys() {
        HashSet result2 = new HashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getIgnorableDataKeys());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<? extends Identifiable>> getDependencyAwareDataKeys() {
        HashSet<Key<? extends Identifiable>> result2 = new HashSet<Key<? extends Identifiable>>();
        result2.add(ProjectKeys.MODULE);
        for (ExternalProjectStructureCustomizer customizer : ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getDependencyAwareDataKeys());
        }
        HashSet<Key<? extends Identifiable>> hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    private static DataNode getModifiableDataNode(@NotNull DataNode node) {
        DataNode modifiedDataNode;
        if (node == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(8);
        }
        if ((modifiedDataNode = node.getUserData(MODIFIED_NODE_KEY)) == null) {
            modifiedDataNode = node.nodeCopy();
            node.putUserData(MODIFIED_NODE_KEY, modifiedDataNode);
        }
        DataNode dataNode = modifiedDataNode;
        if (dataNode == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(9);
        }
        return dataNode;
    }

    private SelectionState getSelectionStatus() {
        boolean isRequiredSelectionEnabled = this.computeRequiredSelectionStatus();
        String stateMessage = "";
        Object root = this.myTree.getModel().getRoot();
        if (root instanceof CheckedTreeNode) {
            int[] selectedModulesCount = new int[]{0};
            TreeUtil.traverse((CheckedTreeNode)root, node -> {
                if (node instanceof DataNodeCheckedTreeNode && ((DataNodeCheckedTreeNode)node).isChecked() && this.myDependencyAwareDataKeys.contains(((DataNodeCheckedTreeNode)node).myDataNode.getKey())) {
                    selectedModulesCount[0] = selectedModulesCount[0] + 1;
                }
                return true;
            });
            stateMessage = String.format("%1$d Modules. %2$d selected", this.myModulesCount, selectedModulesCount[0]);
        }
        return new SelectionState(isRequiredSelectionEnabled, stateMessage);
    }

    private boolean computeRequiredSelectionStatus() {
        for (DataNode<Identifiable> node : this.dependentNodeMap.keySet()) {
            DataNodeCheckedTreeNode uiNode = node.getUserData(CONNECTED_UI_NODE_KEY);
            assert (uiNode != null);
            if (!uiNode.isChecked()) continue;
            for (DataNode<Identifiable> depNode : this.dependentNodeMap.get(node)) {
                DataNodeCheckedTreeNode uiDependentNode = depNode.getUserData(CONNECTED_UI_NODE_KEY);
                assert (uiDependentNode != null);
                if (uiDependentNode.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean showAndGet() {
        BooleanValueHolder result2 = new BooleanValueHolder(false);
        DumbService.getInstance(this.myProject).suspendIndexingAndRun("Select External Data", () -> result2.setValue(super.showAndGet()));
        return result2.getValue();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.setMinimumSize(new Dimension(300, 100));
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(400, 300));
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setAutoscrolls(true);
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.mySelectionStatusLbl = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, "South");
        this.myDescriptionLbl = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel, DynamicBundle.getBundle("messages/ExternalSystemBundle", ExternalProjectDataSelectorDialog.class).getString("label.please.select.the.modules.data.to.include.in.the.project"));
        jPanel2.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnorableKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyAwareDataKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableDataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectRequiredButton
    extends AnActionButton {
        SelectRequiredButton() {
            super(ExternalSystemBundle.message("select.required", new Object[0]), ExternalSystemBundle.message("select.modules.depended.on.currently.selected.modules", new Object[0]), AllIcons.Actions.IntentionBulb);
            this.addCustomUpdater(e -> ((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).selectionState.getValue()).isRequiredSelectionEnabled);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean showSelectedRowsOnly;
            if (e == null) {
                SelectRequiredButton.$$$reportNull$$$0(0);
            }
            if (showSelectedRowsOnly = ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.myTree.clearSelection();
            for (DataNode node : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)node.getUserData(CONNECTED_UI_NODE_KEY);
                assert (uiNode != null);
                if (!uiNode.isChecked()) continue;
                for (DataNode treeNode : ExternalProjectDataSelectorDialog.this.dependentNodeMap.get(node)) {
                    DataNodeCheckedTreeNode uiDependentNode = (DataNodeCheckedTreeNode)treeNode.getUserData(CONNECTED_UI_NODE_KEY);
                    assert (uiDependentNode != null);
                    ExternalProjectDataSelectorDialog.this.myTree.setNodeState(uiDependentNode, true);
                }
            }
            if (showSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
        }

        @Override
        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$SelectRequiredButton", "actionPerformed"));
        }
    }

    private class ShowSelectedOnlyButton
    extends ToggleActionButton {
        ShowSelectedOnlyButton() {
            super(ExternalSystemBundle.messagePointer("show.selected.only", new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        @Override
        public boolean isSelected(AnActionEvent e) {
            return ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly;
        }

        @Override
        public void setSelected(AnActionEvent e, boolean state) {
            ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = state;
            ExternalProjectDataSelectorDialog.this.reloadTree();
        }
    }

    private class UnselectAllButton
    extends AnActionButton {
        UnselectAllButton() {
            super(ExternalSystemBundle.messagePointer("action.text.unselect.all", new Object[0]), AllIcons.Actions.Unselectall);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultTreeModel treeModel;
            Object root;
            if (e == null) {
                UnselectAllButton.$$$reportNull$$$0(0);
            }
            if (!((root = (treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel()).getRoot()) instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$UnselectAllButton", "actionPerformed"));
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        SelectAllButton() {
            super(ExternalSystemBundle.messagePointer("action.text.select.all", new Object[0]), AllIcons.Actions.Selectall);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultTreeModel treeModel;
            Object root;
            if (e == null) {
                SelectAllButton.$$$reportNull$$$0(0);
            }
            if (!((root = (treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel()).getRoot()) instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$SelectAllButton", "actionPerformed"));
        }
    }

    private static class SelectionState {
        boolean isRequiredSelectionEnabled;
        @Nullable
        String message;

        SelectionState(boolean isRequiredSelectionEnabled, @Nullable String message) {
            this.isRequiredSelectionEnabled = isRequiredSelectionEnabled;
            this.message = message;
        }
    }

    private class DataNodeCheckedTreeNode
    extends CheckedTreeNode {
        private static final int MAX_DEPENDENCIES_TO_DESCRIBE = 5;
        private final DataNode myDataNode;
        @Nullable
        private final Icon icon;
        private String text;
        @Nullable
        private String comment;

        private DataNodeCheckedTreeNode(DataNode node) {
            super(node);
            this.myDataNode = node;
            node.putUserData(CONNECTED_UI_NODE_KEY, this);
            DataNode modifiableDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
            assert (modifiableDataNode != null);
            this.isChecked = !modifiableDataNode.isIgnored();
            Icon anIconCandidate = null;
            boolean multipleIconCandidatesFound = false;
            ExternalProjectStructureCustomizer projectStructureCustomizer = new ExternalProjectStructureCustomizerImpl();
            for (ExternalProjectStructureCustomizer customizer : ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
                Icon icon2 = customizer.suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
                if (!multipleIconCandidatesFound && icon2 != null) {
                    if (anIconCandidate != null) {
                        multipleIconCandidatesFound = true;
                        anIconCandidate = null;
                    } else {
                        anIconCandidate = icon2;
                    }
                }
                if (!customizer.getPublicDataKeys().contains(node.getKey())) continue;
                projectStructureCustomizer = customizer;
                break;
            }
            this.icon = anIconCandidate != null ? anIconCandidate : ((ExternalProjectStructureCustomizer)projectStructureCustomizer).suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
            Couple<String> representationName = ((ExternalProjectStructureCustomizer)projectStructureCustomizer).getRepresentationName(node);
            this.text = (String)representationName.first;
            this.comment = (String)representationName.second;
            if (this.text == null) {
                this.text = node.getKey().toString();
            }
        }

        @Override
        public void setChecked(boolean checked) {
            DataNodeCheckedTreeNode[] unprocessedNodes;
            super.setChecked(checked);
            if (checked) {
                DataNodeCheckedTreeNode parent = this;
                DataNodeCheckedTreeNode moduleNode = null;
                while (parent.parent instanceof DataNodeCheckedTreeNode) {
                    if (moduleNode == null && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(parent.myDataNode.getKey())) {
                        moduleNode = parent;
                    }
                    parent = (DataNodeCheckedTreeNode)parent.parent;
                }
                parent.isChecked = true;
                DataNode modifiedParentDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(parent.myDataNode);
                modifiedParentDataNode.setIgnored(false);
                if (moduleNode != null) {
                    moduleNode.isChecked = true;
                }
                ExternalSystemApiUtil.visit(moduleNode == null ? this.myDataNode : moduleNode.myDataNode, node -> ExternalProjectDataSelectorDialog.getModifiableDataNode(node).setIgnored(false));
            } else {
                ExternalSystemApiUtil.visit(this.myDataNode, node -> ExternalProjectDataSelectorDialog.getModifiableDataNode(node).setIgnored(true));
                if (ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                    TreePath[] before = ExternalProjectDataSelectorDialog.this.myTree.getSelectionPaths();
                    treeModel.removeNodeFromParent(this);
                    ExternalProjectDataSelectorDialog.this.myTree.addSelectionPaths(before);
                }
            }
            if (!checked && this.parent instanceof DataNodeCheckedTreeNode && this.myDataNode.getKey().equals(ProjectKeys.MODULE) && ((DataNodeCheckedTreeNode)this.parent).myDataNode.getKey().equals(ProjectKeys.PROJECT)) {
                DataNode projectDataNode = ((DataNodeCheckedTreeNode)this.parent).myDataNode;
                ProjectData projectData2 = (ProjectData)projectDataNode.getData();
                ModuleData moduleData = (ModuleData)this.myDataNode.getData();
                if (moduleData.getLinkedExternalProjectPath().equals(projectData2.getLinkedExternalProjectPath()) && ExternalSystemApiUtil.findAll(projectDataNode, ProjectKeys.MODULE).size() == 1) {
                    ((DataNodeCheckedTreeNode)this.parent).setChecked(false);
                }
            }
            boolean isCheckCompleted = (unprocessedNodes = ExternalProjectDataSelectorDialog.this.myTree.getSelectedNodes(DataNodeCheckedTreeNode.class, node -> ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && checked != node.isChecked())).length == 0 && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(this.myDataNode.getKey());
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
            if (((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).selectionState.getValue()).isRequiredSelectionEnabled && isCheckCompleted) {
                this.warnAboutMissedDependencies(checked);
            }
        }

        private void warnAboutMissedDependencies(boolean checked) {
            String string;
            SmartList<DataNode> selectedModules = new SmartList<DataNode>();
            for (DataNode dataNode : TreeUtil.collectSelectedObjectsOfType(ExternalProjectDataSelectorDialog.this.myTree, DataNode.class)) {
                if (!ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(dataNode.getKey())) continue;
                selectedModules.add(dataNode);
            }
            HashSet<DataNode> deps = new HashSet<DataNode>();
            for (DataNode dataNode : selectedModules) {
                if (checked) {
                    deps.addAll(ContainerUtil.filter(ExternalProjectDataSelectorDialog.this.dependentNodeMap.get(dataNode), node -> {
                        DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)node.getUserData(CONNECTED_UI_NODE_KEY);
                        return uiNode != null && !uiNode.isChecked();
                    }));
                    continue;
                }
                for (DataNode dataNode2 : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                    Collection dependencies;
                    DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)dataNode2.getUserData(CONNECTED_UI_NODE_KEY);
                    if (uiNode != null && !uiNode.isChecked() || !(dependencies = ExternalProjectDataSelectorDialog.this.dependentNodeMap.get(dataNode2)).contains(dataNode)) continue;
                    deps.add(dataNode2);
                }
            }
            if (!deps.isEmpty() && !selectedModules.isEmpty() && Messages.showOkCancelDialog(string = checked ? this.getEnableMessage(selectedModules, deps) : this.getDisableMessage(deps), checked ? ExternalSystemBundle.message("enable.dependant.modules", new Object[0]) : ExternalSystemBundle.message("disable.modules.with.dependency.on.this", new Object[0]), Messages.getQuestionIcon()) == 0) {
                List<DataNodeCheckedTreeNode> list2 = ContainerUtil.mapNotNull(deps, node -> (DataNodeCheckedTreeNode)node.getUserData(CONNECTED_UI_NODE_KEY));
                for (DataNodeCheckedTreeNode dataNodeCheckedTreeNode : list2) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                    ExternalProjectDataSelectorDialog.this.myTree.addSelectionPath(new TreePath(treeModel.getPathToRoot(dataNodeCheckedTreeNode)));
                }
                for (DataNodeCheckedTreeNode dataNodeCheckedTreeNode : list2) {
                    dataNodeCheckedTreeNode.setChecked(checked);
                }
            }
        }

        private String getEnableMessage(List<? extends DataNode<Identifiable>> selectedModules, Set<? extends DataNode<Identifiable>> deps) {
            if (deps.size() > 5 || selectedModules.size() > 5) {
                return String.format("%d disabled %s depend on %d selected %s. Would you like to enable %s too?", deps.size(), StringUtil.pluralize("module", deps.size()), selectedModules.size(), StringUtil.pluralize("module", selectedModules.size()), deps.size() == 1 ? "it" : "them");
            }
            String listOfSelectedModules = StringUtil.join(selectedModules, node -> ((Identifiable)node.getData()).getId(), ", ");
            String listOfDependencies = StringUtil.join(deps, node -> ((Identifiable)node.getData()).getId(), "<br>");
            return String.format("<html>The following %s on which <b>%s</b> %s %s disabled:<br><b>%s</b><br>Would you like to enable %s?</html>", StringUtil.pluralize("module", deps.size()), listOfSelectedModules, StringUtil.pluralize("depend", selectedModules.size()), deps.size() == 1 ? "is" : "are", listOfDependencies, deps.size() == 1 ? "it" : "them");
        }

        private String getDisableMessage(Set<? extends DataNode<Identifiable>> deps) {
            if (deps.size() > 5) {
                return String.format("%d enabled modules depend on selected modules. Would you like to disable them too?", deps.size());
            }
            String listOfDependencies = StringUtil.join(deps, node -> ((Identifiable)node.getData()).getId(), "<br>");
            return String.format("<html>The following %s <br><b>%s</b><br>%s enabled and %s on selected modules. <br>Would you like to disable %s too?</html>", StringUtil.pluralize("module", deps.size()), listOfDependencies, deps.size() == 1 ? "is" : "are", StringUtil.pluralize("depend", deps.size()), deps.size() == 1 ? "it" : "them");
        }
    }
}

