/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u0006\u001a\u0016\u0010\u000b\u001a\u00020\u0003*\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u000f"}, d2={"resolveJdkReference", "", "item", "Lcom/intellij/openapi/roots/ui/configuration/SdkListItem;", "resolveJdkReferenceInTests", "addAndGetSdkItem", "Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "findSdkItem", "getSelectedJdkReference", "resolveSdkItem", "jdkReference", "setSelectedJdkReference", "", "intellij.platform.externalSystem.impl"})
@JvmName(name="ExternalSystemJdkComboBoxUtil")
public final class ExternalSystemJdkComboBoxUtil {
    @Nullable
    public static final String getSelectedJdkReference(@NotNull SdkComboBox $this$getSelectedJdkReference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getSelectedJdkReference, (String)"$this$getSelectedJdkReference");
        return ExternalSystemJdkComboBoxUtil.resolveJdkReference($this$getSelectedJdkReference.getSelectedItem());
    }

    private static final String resolveJdkReference(SdkListItem item) {
        String string;
        SdkListItem sdkListItem = item;
        if (sdkListItem instanceof SdkListItem.ProjectSdkItem) {
            string = "#USE_PROJECT_JDK";
        } else if (sdkListItem instanceof SdkListItem.SdkItem) {
            Sdk sdk2 = ((SdkListItem.SdkItem)item).getSdk();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdk2, (String)"item.sdk");
            string = sdk2.getName();
        } else {
            string = sdkListItem instanceof SdkListItem.InvalidSdkItem ? ((SdkListItem.InvalidSdkItem)item).getSdkName() : null;
        }
        return string;
    }

    public static final void setSelectedJdkReference(@NotNull SdkComboBox $this$setSelectedJdkReference, @Nullable String jdkReference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setSelectedJdkReference, (String)"$this$setSelectedJdkReference");
        $this$setSelectedJdkReference.setSelectedItem(ExternalSystemJdkComboBoxUtil.resolveSdkItem($this$setSelectedJdkReference, jdkReference));
    }

    private static final SdkListItem resolveSdkItem(@NotNull SdkComboBox $this$resolveSdkItem, String jdkReference) {
        if (jdkReference == null) {
            SdkListItem sdkListItem = $this$resolveSdkItem.showNoneSdkItem();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkListItem, (String)"showNoneSdkItem()");
            return sdkListItem;
        }
        if (Intrinsics.areEqual((Object)jdkReference, (Object)"#USE_PROJECT_JDK")) {
            SdkListItem sdkListItem = $this$resolveSdkItem.showProjectSdkItem();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkListItem, (String)"showProjectSdkItem()");
            return sdkListItem;
        }
        try {
            Sdk selectedJdk = ExternalSystemJdkUtil.resolveJdkName(null, jdkReference);
            if (selectedJdk == null) {
                SdkListItem sdkListItem = $this$resolveSdkItem.showInvalidSdkItem(jdkReference);
                Intrinsics.checkExpressionValueIsNotNull((Object)sdkListItem, (String)"showInvalidSdkItem(jdkReference)");
                return sdkListItem;
            }
            SdkListItem sdkListItem = ExternalSystemJdkComboBoxUtil.findSdkItem($this$resolveSdkItem, selectedJdk);
            if (sdkListItem == null) {
                sdkListItem = ExternalSystemJdkComboBoxUtil.addAndGetSdkItem($this$resolveSdkItem, selectedJdk);
            }
            return sdkListItem;
        }
        catch (ExternalSystemJdkException ex) {
            SdkListItem sdkListItem = $this$resolveSdkItem.showInvalidSdkItem(jdkReference);
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkListItem, (String)"showInvalidSdkItem(jdkReference)");
            return sdkListItem;
        }
    }

    private static final SdkListItem addAndGetSdkItem(@NotNull SdkComboBox $this$addAndGetSdkItem, Sdk sdk2) {
        SdkConfigurationUtil.addSdk(sdk2);
        $this$addAndGetSdkItem.getModel().getSdksModel().addSdk(sdk2);
        $this$addAndGetSdkItem.reloadModel();
        SdkListItem sdkListItem = ExternalSystemJdkComboBoxUtil.findSdkItem($this$addAndGetSdkItem, sdk2);
        if (sdkListItem == null) {
            SdkListItem sdkListItem2 = $this$addAndGetSdkItem.showInvalidSdkItem(sdk2.getName());
            sdkListItem = sdkListItem2;
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkListItem2, (String)"showInvalidSdkItem(sdk.name)");
        }
        return sdkListItem;
    }

    private static final SdkListItem findSdkItem(@NotNull SdkComboBox $this$findSdkItem, Sdk sdk2) {
        return $this$findSdkItem.getModel().getListModel().findSdkItem(sdk2);
    }

    @Nullable
    public static final String resolveJdkReferenceInTests(@Nullable SdkListItem item) {
        return ExternalSystemJdkComboBoxUtil.resolveJdkReference(item);
    }
}

