/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemUsagesCollector
extends ProjectUsagesCollector {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGroupId() {
        return "build.tools";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Set usages;
        block3: {
            Module module2;
            boolean bl;
            Module[] moduleArray;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                boolean bl2 = false;
                usages = new LinkedHashSet();
                for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
                    if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun(project2)).getLinkedProjectsSettings().isEmpty()) continue;
                    ProjectSystemId projectSystemId = manager.getSystemId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectSystemId, (String)"manager.getSystemId()");
                    usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId)));
                }
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray2 = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray2, (String)"ModuleManager.getInstance(project).modules");
                moduleArray = moduleArray2;
                bl = false;
                Module[] moduleArray3 = moduleArray;
                boolean bl3 = false;
                Module[] moduleArray4 = moduleArray3;
                int n = moduleArray4.length;
                for (int i = 0; i < n; ++i) {
                    Module module3;
                    Module it = module3 = moduleArray4[i];
                    boolean bl4 = false;
                    Module module4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"it");
                    if (!ExternalSystemModulePropertyManager.Companion.getInstance(module4).isMavenized()) continue;
                    module2 = module3;
                    break block2;
                }
                module2 = null;
            }
            if (module2 == null) break block3;
            moduleArray = module2;
            bl = false;
            boolean bl5 = false;
            Module[] it = moduleArray;
            boolean bl6 = false;
            usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)"Maven"));
        }
        return usages;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$Companion;", "", "()V", "getJRETypeUsage", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "key", "", "jreName", "getJREVersionUsage", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final MetricEvent getJRETypeUsage(@NotNull String key, @Nullable String jreName) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            CharSequence charSequence = jreName;
            boolean bl = false;
            boolean bl2 = false;
            String anonymizedName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "empty" : (CollectionsKt.listOf((Object[])new String[]{"#JAVA_INTERNAL", "#USE_PROJECT_JDK", "#JAVA_HOME"}).contains(jreName) ? jreName : "custom");
            return MetricEventFactoryKt.newMetric((String)key, (String)anonymizedName);
        }

        @NotNull
        public final MetricEvent getJREVersionUsage(@NotNull Project project2, @NotNull String key, @Nullable String jreName) {
            Object object;
            block6: {
                block5: {
                    Object object2;
                    Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Sdk jdk = ExternalSystemJdkUtil.getJdk(project2, jreName);
                    object = jdk;
                    if (object == null || (object = object.getVersionString()) == null) break block5;
                    Object object3 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object3;
                    boolean bl3 = false;
                    Version version2 = Version.parseVersion((String)it);
                    if (version2 != null) {
                        Version version3 = version2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Version parsed = version3;
                        boolean bl6 = false;
                        object2 = "" + parsed.major + '.' + parsed.minor;
                    } else {
                        object2 = object = null;
                    }
                    if (object2 != null) break block6;
                }
                object = "unknown";
            }
            Object versionString = object;
            return MetricEventFactoryKt.newMetric((String)key, (String)versionString);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

