/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=10)
public class TasksNode
extends ExternalSystemNode<Object> {
    private final MultiMap<String, TaskNode> myTasksMap = new MultiMap();

    public TasksNode(ExternalProjectsView externalProjectsView, Collection<? extends DataNode<?>> dataNodes) {
        super(externalProjectsView, null, null);
        if (dataNodes != null && !dataNodes.isEmpty()) {
            for (DataNode<TaskData> dataNode : dataNodes) {
                if (!(dataNode.getData() instanceof TaskData)) continue;
                String group = ((TaskData)dataNode.getData()).getGroup();
                if (group == null) {
                    group = "other";
                }
                this.myTasksMap.putValue(StringUtil.toLowerCase(group), new TaskNode(externalProjectsView, dataNode));
            }
        }
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            TasksNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        presentation.setIcon(AllIcons.Nodes.ConfigFolder);
    }

    @Override
    public String getName() {
        return "Tasks";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        ArrayList<ExternalSystemNode> result2 = new ArrayList<ExternalSystemNode>();
        boolean isGroup = this.getExternalProjectsView().getGroupTasks();
        if (isGroup) {
            for (Map.Entry<String, Collection<TaskNode>> collectionEntry : this.myTasksMap.entrySet()) {
                final String group = ObjectUtils.notNull(collectionEntry.getKey(), "other");
                ExternalSystemNode<Object> tasksGroupNode = new ExternalSystemNode<Object>(this.getExternalProjectsView(), null, null){

                    @Override
                    protected void update(@NotNull PresentationData presentation) {
                        if (presentation == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.update(presentation);
                        presentation.setIcon(AllIcons.Nodes.ConfigFolder);
                    }

                    @Override
                    public String getName() {
                        return group;
                    }

                    @Override
                    public boolean isVisible() {
                        return super.isVisible() && this.hasChildren();
                    }

                    @Override
                    public int compareTo(@NotNull ExternalSystemNode node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return "other".equals(group) ? 1 : super.compareTo(node);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "presentation";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "node";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/view/TasksNode$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "compareTo";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                tasksGroupNode.addAll(collectionEntry.getValue());
                result2.add(tasksGroupNode);
            }
        } else {
            result2.addAll(this.myTasksMap.values());
        }
        ArrayList<ExternalSystemNode> arrayList = result2;
        if (arrayList == null) {
            TasksNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/TasksNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/TasksNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

