/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDescriptor
implements Cloneable {
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJars;
    private final boolean myChooseJarsAsFiles;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    private String myTitle;
    private String myDescription;
    private boolean myHideIgnored;
    private final List<VirtualFile> myRoots;
    private boolean myShowFileSystemRoots;
    private boolean myTreeRootVisible;
    private boolean myShowHiddenFiles;
    private Condition<? super VirtualFile> myFileFilter;
    private boolean myForcedToUseIdeaFileChooser;
    private final Map<String, Object> myUserData;

    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myTitle = UIBundle.message("file.chooser.default.title", new Object[0]);
        this.myHideIgnored = true;
        this.myRoots = new ArrayList<VirtualFile>();
        this.myShowFileSystemRoots = true;
        this.myTreeRootVisible = false;
        this.myShowHiddenFiles = false;
        this.myFileFilter = null;
        this.myForcedToUseIdeaFileChooser = false;
        this.myUserData = new THashMap<String, Object>();
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public FileChooserDescriptor(@NotNull FileChooserDescriptor d) {
        if (d == null) {
            FileChooserDescriptor.$$$reportNull$$$0(0);
        }
        this(d.isChooseFiles(), d.isChooseFolders(), d.isChooseJars(), d.isChooseJarsAsFiles(), d.isChooseJarContents(), d.isChooseMultiple());
        this.withTitle(d.getTitle());
        this.withDescription(d.getDescription());
        this.withHideIgnored(d.isHideIgnored());
        this.withRoots(d.getRoots());
        this.withShowFileSystemRoots(d.isShowFileSystemRoots());
        this.withTreeRootVisible(d.isTreeRootVisible());
        this.withShowHiddenFiles(d.isShowHiddenFiles());
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJars() {
        return this.myChooseJars;
    }

    public boolean isChooseJarsAsFiles() {
        return this.myChooseJarsAsFiles;
    }

    public boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.withTitle(title);
    }

    public FileChooserDescriptor withTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myTitle = title;
        return this;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nls(capitalization=Nls.Capitalization.Sentence) String description) {
        this.withDescription(description);
    }

    public FileChooserDescriptor withDescription(@Nls(capitalization=Nls.Capitalization.Sentence) String description) {
        this.myDescription = description;
        return this;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    public void setHideIgnored(boolean hideIgnored) {
        this.withHideIgnored(hideIgnored);
    }

    public FileChooserDescriptor withHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
        return this;
    }

    public List<VirtualFile> getRoots() {
        return Collections.unmodifiableList(this.myRoots);
    }

    public void setRoots(VirtualFile ... roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(1);
        }
        this.withRoots(roots);
    }

    public void setRoots(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(2);
        }
        this.withRoots(roots);
    }

    public FileChooserDescriptor withRoots(VirtualFile ... roots) {
        return this.withRoots(Arrays.asList(roots));
    }

    public FileChooserDescriptor withRoots(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            FileChooserDescriptor.$$$reportNull$$$0(3);
        }
        if (roots.contains(null)) {
            throw new IllegalArgumentException("'null' in roots: " + roots);
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        return this;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.withShowFileSystemRoots(showFileSystemRoots);
    }

    public FileChooserDescriptor withShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
        return this;
    }

    public boolean isTreeRootVisible() {
        return this.myTreeRootVisible;
    }

    public FileChooserDescriptor withTreeRootVisible(boolean isTreeRootVisible) {
        this.myTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public FileChooserDescriptor withShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
        return this;
    }

    public FileChooserDescriptor withFileFilter(@Nullable Condition<? super VirtualFile> filter2) {
        this.myFileFilter = filter2;
        return this;
    }

    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
        if (file2.is(VFileProperty.SYMLINK) && file2.getCanonicalPath() == null) {
            return false;
        }
        if (!file2.isDirectory()) {
            if (FileElement.isArchive(file2) ? !this.myChooseJars && !this.myChooseJarContents : !this.myChooseFiles) {
                return false;
            }
            if (this.myFileFilter != null && !this.myFileFilter.value(file2)) {
                return false;
            }
        }
        if (this.isHideIgnored() && FileTypeManager.getInstance().isFileIgnored(file2)) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file2);
    }

    public boolean isFileSelectable(VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        if (file2.is(VFileProperty.SYMLINK) && file2.getCanonicalPath() == null) {
            return false;
        }
        if (file2.isDirectory() && this.myChooseFolders) {
            return true;
        }
        if (this.myFileFilter != null && !file2.isDirectory()) {
            return this.myFileFilter.value(file2);
        }
        return this.acceptAsJarFile(file2) || this.acceptAsGeneralFile(file2);
    }

    public Icon getIcon(VirtualFile file2) {
        return FileChooserDescriptor.dressIcon(file2, IconUtil.getIcon((VirtualFile)file2, (int)2, null));
    }

    protected static Icon dressIcon(VirtualFile file2, Icon baseIcon) {
        return file2.isValid() && file2.is(VFileProperty.SYMLINK) ? new LayeredIcon(new Icon[]{baseIcon, PlatformIcons.SYMLINK_ICON}) : baseIcon;
    }

    public String getName(VirtualFile file2) {
        return file2.getPath();
    }

    @Nullable
    public String getComment(VirtualFile file2) {
        return null;
    }

    public void validateSelectedFiles(VirtualFile @NotNull [] files2) throws Exception {
        if (files2 == null) {
            FileChooserDescriptor.$$$reportNull$$$0(4);
        }
    }

    public boolean isForcedToUseIdeaFileChooser() {
        return this.myForcedToUseIdeaFileChooser;
    }

    public void setForcedToUseIdeaFileChooser(boolean forcedToUseIdeaFileChooser) {
        this.myForcedToUseIdeaFileChooser = forcedToUseIdeaFileChooser;
    }

    private boolean acceptAsGeneralFile(VirtualFile file2) {
        if (FileElement.isArchive(file2)) {
            return false;
        }
        return !file2.isDirectory() && this.myChooseFiles;
    }

    private boolean acceptAsJarFile(VirtualFile file2) {
        return this.myChooseJars && FileElement.isArchive(file2);
    }

    @Nullable
    public final VirtualFile getFileToSelect(VirtualFile file2) {
        if (file2.isDirectory() && (this.myChooseFolders || this.isFileSelectable(file2))) {
            return file2;
        }
        boolean isJar = FileTypeRegistry.getInstance().isFileOfType(file2, ArchiveFileType.INSTANCE);
        if (!isJar) {
            return this.acceptAsGeneralFile(file2) ? file2 : null;
        }
        if (this.myChooseJarsAsFiles) {
            return file2;
        }
        if (!this.acceptAsJarFile(file2)) {
            return null;
        }
        String path2 = file2.getPath();
        return JarFileSystem.getInstance().findFileByPath(path2 + "!/");
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Object getUserData(@NotNull String dataId) {
        if (dataId == null) {
            FileChooserDescriptor.$$$reportNull$$$0(5);
        }
        return this.myUserData.get(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull DataKey<T> key) {
        if (key == null) {
            FileChooserDescriptor.$$$reportNull$$$0(6);
        }
        Object t = this.myUserData.get(key.getName());
        return (T)t;
    }

    public <T> void putUserData(@NotNull DataKey<T> key, @Nullable T data2) {
        if (key == null) {
            FileChooserDescriptor.$$$reportNull$$$0(7);
        }
        this.myUserData.put(key.getName(), data2);
    }

    public String toString() {
        return "FileChooserDescriptor [" + this.myTitle + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/FileChooserDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSelectedFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

