/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileElement {
    private final VirtualFile myFile;
    private final String myName;
    private String myPath;
    private FileElement myParent;

    public FileElement(@Nullable VirtualFile file2, String name) {
        this.myFile = file2;
        this.myName = name;
    }

    public void setParent(FileElement parent) {
        this.myParent = parent;
    }

    public FileElement getParent() {
        return this.myParent;
    }

    public final VirtualFile getFile() {
        return this.myFile;
    }

    public final String getName() {
        return this.myName;
    }

    @NotNull
    public final String getPath() {
        if (this.myPath == null) {
            StringBuilder sb = new StringBuilder();
            FileElement element2 = this;
            while (element2 != null) {
                if (element2.myParent != null || !element2.myName.equals(File.separator)) {
                    sb.insert(0, element2.myName);
                }
                if ((element2 = element2.myParent) == null) continue;
                sb.insert(0, File.separator);
            }
            this.myPath = sb.toString();
        }
        String string = this.myPath;
        if (string == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int hashCode() {
        return this.myFile == null ? 0 : this.myFile.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileElement && Comparing.equal(((FileElement)obj).myFile, this.myFile);
    }

    public final String toString() {
        return this.myName != null ? this.myName : "";
    }

    public final boolean isHidden() {
        return FileElement.isFileHidden(this.myFile);
    }

    public final boolean isArchive() {
        return FileElement.isArchive(this.getFile());
    }

    public static boolean isFileHidden(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid() && file2.isInLocalFileSystem() && (file2.is(VFileProperty.HIDDEN) || SystemInfo.isUnix && file2.getName().startsWith("."));
    }

    public static boolean isArchive(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        if (FileElement.isArchiveFileSystem(file2) && file2.getParent() == null) {
            return true;
        }
        return !file2.isDirectory() && FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && !FileElement.isArchiveFileSystem(file2.getParent());
    }

    private static boolean isArchiveFileSystem(VirtualFile file2) {
        return file2.getFileSystem() instanceof JarFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/FileElement", "getPath"));
    }
}

